/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.hive.ai.task.impl;

import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.hive.Hive;
import com.alien.common.gameplay.hive.HiveRemovalReason;
import com.alien.common.gameplay.hive.ai.task.HiveTask;
import com.alien.common.gameplay.hive.util.HiveLeaderDispositionUtil;
import com.alien.common.gameplay.level.saveddata.HiveLevelData;
import com.alien.common.model.hive.HiveMemberData;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_2338;

public class MergeWithNearbyHiveTask
extends HiveTask {
    public MergeWithNearbyHiveTask(Hive hive) {
        super(hive);
    }

    @Override
    public boolean canRun() {
        return super.canRun() && !this.hive.isAngry() && this.hive.ageInTicks() % 1200 == 0;
    }

    @Override
    public void run() {
        Hive nearestHive = (Hive)HiveLevelData.getOrCreate(this.hive.level()).andThen(hiveLevelData -> hiveLevelData.findNearestHive(this.hive.centerPosition(), hive -> !Objects.equals(hive.id(), this.hive.id()) && Objects.equals((Object)hive.getVariant(), (Object)this.hive.getVariant()))).unwrapOr(null);
        if (nearestHive == null) {
            return;
        }
        class_2338 neighborHiveCenter = nearestHive.centerPosition();
        if (!this.hive.getSpaceManager().isBlockPosLeashedToHive(neighborHiveCenter)) {
            return;
        }
        Hive strongerHive = this.getStrongerHive(this.hive, nearestHive);
        Hive weakerHive = Objects.equals(strongerHive.id(), this.hive.id()) ? nearestHive : this.hive;
        this.mergeLeftHiveIntoRight(weakerHive, strongerHive);
    }

    private Hive getStrongerHive(Hive left, Hive right) {
        int rightAgeInTicks;
        int rightMemberCount;
        int leftMemberCount;
        Alien leftLeader = left.getLeadershipManager().getLeaderOrNull();
        Alien rightLeader = right.getLeadershipManager().getLeaderOrNull();
        if (leftLeader != null && rightLeader != null) {
            int rightDisposition;
            int leftDisposition = HiveLeaderDispositionUtil.getDispositionForEntityType(leftLeader.method_5864());
            if (leftDisposition > (rightDisposition = HiveLeaderDispositionUtil.getDispositionForEntityType(rightLeader.method_5864()))) {
                return left;
            }
            if (leftDisposition < rightDisposition) {
                return right;
            }
        }
        if ((leftMemberCount = left.getMembershipManager().getMemberCount()) > (rightMemberCount = right.getMembershipManager().getMemberCount())) {
            return left;
        }
        if (leftMemberCount < rightMemberCount) {
            return right;
        }
        int leftAgeInTicks = left.ageInTicks();
        if (leftAgeInTicks > (rightAgeInTicks = right.ageInTicks())) {
            return left;
        }
        if (leftAgeInTicks < rightAgeInTicks) {
            return right;
        }
        return left;
    }

    private void mergeLeftHiveIntoRight(Hive left, Hive right) {
        List leftMemberData = left.getMembershipManager().getMemberUUIDs().stream().flatMap(uuid -> left.getMembershipManager().getMemberData((UUID)uuid).map(hiveMemberData -> Map.entry(uuid, hiveMemberData)).toStream()).toList();
        leftMemberData.forEach(entry -> right.getMembershipManager().addMember((UUID)entry.getKey(), (HiveMemberData)entry.getValue()));
        left.getMembershipManager().clearMembers();
        left.getLeadershipManager().setLeaderId(null);
        left.remove(HiveRemovalReason.DISCARDED);
    }
}

