/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.level.saveddata;

import com.just.core.functional.option.Option;
import com.lib.common.gameplay.util.spatial.region.RegionPos;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2501;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;

public class QueenSpawnChunkData
extends class_18 {
    private static final String DATA_NAME = "queen_spawn_chunk_data_v2";
    private static final String NBT_REGIONS = "blacklistedRegions";
    private final Map<RegionPos, BitSet> regionChunkBits = new HashMap<RegionPos, BitSet>();

    private QueenSpawnChunkData() {
    }

    private QueenSpawnChunkData(Map<RegionPos, BitSet> regionChunkBits) {
        this.regionChunkBits.putAll(regionChunkBits);
    }

    public void addChunkToBlacklist(class_2338 pos) {
        this.addChunkToBlacklist(new class_1923(pos));
    }

    public void addChunkToBlacklist(class_1923 pos) {
        RegionPos region = RegionPos.fromChunkPos(pos);
        BitSet bitSet = this.regionChunkBits.computeIfAbsent(region, k -> new BitSet(16384));
        int bitIndex = QueenSpawnChunkData.bitIndexInRegion(pos.field_9181, pos.field_9180);
        bitSet.set(bitIndex);
        this.method_80();
    }

    public boolean isChunkBlacklisted(class_2338 pos) {
        return this.isChunkBlacklisted(new class_1923(pos));
    }

    public boolean isChunkBlacklisted(class_1923 pos) {
        RegionPos region = RegionPos.fromChunkPos(pos);
        BitSet bitSet = this.regionChunkBits.get(region);
        if (bitSet == null) {
            return false;
        }
        int bitIndex = QueenSpawnChunkData.bitIndexInRegion(pos.field_9181, pos.field_9180);
        return bitSet.get(bitIndex);
    }

    @NotNull
    public class_2487 method_75(@NotNull class_2487 compoundTag, @NotNull class_7225.class_7874 provider) {
        class_2487 regionsTag = new class_2487();
        for (Map.Entry<RegionPos, BitSet> entry : this.regionChunkBits.entrySet()) {
            RegionPos region = entry.getKey();
            BitSet bits = entry.getValue();
            byte[] bytes = bits.toByteArray();
            long[] longs = QueenSpawnChunkData.toLongArray(bytes);
            regionsTag.method_10566(Long.toString(region.toLong()), (class_2520)new class_2501(longs));
        }
        compoundTag.method_10566(NBT_REGIONS, (class_2520)regionsTag);
        return compoundTag;
    }

    public static QueenSpawnChunkData load(class_2487 compoundTag, class_7225.class_7874 provider) {
        HashMap<RegionPos, BitSet> regionMap = new HashMap<RegionPos, BitSet>();
        class_2487 regionsTag = compoundTag.method_10562(NBT_REGIONS);
        for (String key : regionsTag.method_10541()) {
            long packedKey = Long.parseLong(key);
            RegionPos region = RegionPos.fromLong(packedKey);
            long[] longs = regionsTag.method_10565(key);
            byte[] bytes = QueenSpawnChunkData.toByteArray(longs);
            BitSet bitSet = BitSet.valueOf(bytes);
            regionMap.put(region, bitSet);
        }
        return new QueenSpawnChunkData(regionMap);
    }

    public static Option<QueenSpawnChunkData> getOrCreate(class_1937 level) {
        return level.field_9236 ? Option.none() : Option.some((Object)((Object)((QueenSpawnChunkData)((class_3218)level).method_17983().method_17924(QueenSpawnChunkData.factory(level), DATA_NAME))));
    }

    public static class_18.class_8645<QueenSpawnChunkData> factory(class_1937 level) {
        return new class_18.class_8645(QueenSpawnChunkData::new, QueenSpawnChunkData::load, null);
    }

    private static int bitIndexInRegion(int chunkX, int chunkZ) {
        int localX = chunkX & 0x7F;
        int localZ = chunkZ & 0x7F;
        return localZ * 128 + localX;
    }

    private static long[] toLongArray(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        int len = (int)Math.ceil((double)bytes.length / 8.0);
        long[] result = new long[len];
        for (int i = 0; i < len && buffer.remaining() >= 8; ++i) {
            result[i] = buffer.getLong();
        }
        if (buffer.remaining() > 0) {
            long last = 0L;
            int i = 0;
            while (buffer.remaining() > 0) {
                last |= ((long)buffer.get() & 0xFFL) << 8 * i;
                ++i;
            }
            result[len - 1] = last;
        }
        return result;
    }

    private static byte[] toByteArray(long[] longs) {
        ByteBuffer buffer = ByteBuffer.allocate(longs.length * 8);
        for (long l : longs) {
            buffer.putLong(l);
        }
        return buffer.array();
    }
}

