/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.util;

import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.model.alien.Host;
import com.avp.common.registry.init.AVPSoundEvents;
import com.avp.common.registry.key.AVPDamageTypeKeys;
import com.just.core.functional.option.Option;
import com.lib.common.model.GeneCarrier;
import com.lib.common.util.EmbryoUtil;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1267;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlienEmbryoUtil {
    public static void runAlienEmbryoRoutines(class_1309 hostEntity) {
        class_1657 player;
        Host host = (Host)hostEntity;
        class_1937 level = hostEntity.method_37908();
        if (level.field_9236) {
            return;
        }
        if (hostEntity instanceof class_1657 && ((player = (class_1657)hostEntity).method_7337() || player.method_7325() || player.method_5655())) {
            host.removeEmbryo();
            return;
        }
        if (host.getEmbryoType().isSome()) {
            AlienEmbryoUtil.tickAlienEmbryoGrowth(hostEntity);
        } else {
            host.removeEmbryo();
        }
    }

    private static void tickAlienEmbryoGrowth(class_1309 hostEntity) {
        Host host = (Host)hostEntity;
        if (hostEntity.method_37908().method_8407() == class_1267.field_5801) {
            host.removeEmbryo();
            return;
        }
        host.incrementEmbryoGrowthTimeInTicks();
        long burstTimeInTicks = TimeUnit.MINUTES.toSeconds(5L) * 20L;
        if ((long)host.getEmbryoGrowthTimeInTicks() <= burstTimeInTicks) {
            if (hostEntity instanceof class_1657) {
                class_1657 player = (class_1657)hostEntity;
                if ((long)host.getEmbryoGrowthTimeInTicks() > TimeUnit.MINUTES.toSeconds(4L) * 20L + 600L) {
                    hostEntity.method_6092(new class_1293(class_1294.field_5916, 80, 1, true, false, true));
                    if (player.field_6012 % 10 == 0) {
                        player.method_17356(AVPSoundEvents.EFFECT_HEARTBEAT_3.get(), class_3419.field_15250, 1.0f, 1.0f);
                    }
                } else if ((long)host.getEmbryoGrowthTimeInTicks() > TimeUnit.MINUTES.toSeconds(4L) * 20L) {
                    if (player.field_6012 % 20 == 0) {
                        player.method_17356(AVPSoundEvents.EFFECT_HEARTBEAT_2.get(), class_3419.field_15250, 0.75f, 1.0f);
                    }
                } else if ((long)host.getEmbryoGrowthTimeInTicks() > TimeUnit.MINUTES.toSeconds(3L) * 20L + 600L) {
                    if (player.field_6012 % 30 == 0) {
                        player.method_17356(AVPSoundEvents.EFFECT_HEARTBEAT_1.get(), class_3419.field_15250, 0.5f, 1.0f);
                    }
                } else if ((long)host.getEmbryoGrowthTimeInTicks() > TimeUnit.MINUTES.toSeconds(3L) * 20L && player.field_6012 % 40 == 0) {
                    player.method_17356(AVPSoundEvents.EFFECT_HEARTBEAT_0.get(), class_3419.field_15250, 0.25f, 1.0f);
                }
            }
            if ((long)host.getEmbryoGrowthTimeInTicks() >= burstTimeInTicks - 160L && hostEntity.field_6012 % 10 == 0) {
                hostEntity.method_37908().method_43129(null, (class_1297)hostEntity, AVPSoundEvents.EFFECT_BONE_CRUNCH.get(), class_3419.field_15251, 0.2f, 1.0f);
                hostEntity.method_5643(hostEntity.method_48923().method_48795(AVPDamageTypeKeys.CHESTBURSTING), 0.01f);
            }
            return;
        }
        List<class_1297> embryos = AlienEmbryoUtil.birthEmbryos(hostEntity);
        embryos.forEach(embryo -> {});
        hostEntity.method_37908().method_43129(null, (class_1297)hostEntity, AVPSoundEvents.ENTITY_CHESTBURSTER_BURST.get(), class_3419.field_15251, 0.25f, 1.0f);
        hostEntity.method_5643(hostEntity.method_48923().method_48795(AVPDamageTypeKeys.CHESTBURSTING), Float.MAX_VALUE);
        host.removeEmbryo();
    }

    public static List<class_1297> birthEmbryos(class_1309 parentEntity) {
        return EmbryoUtil.birthEmbryos(parentEntity, ((Host)parentEntity).getOrCreateParasiteGeneContainer(), AlienEmbryoUtil::alienEmbryoFactory, 1);
    }

    @Nullable
    public static class_1297 alienEmbryoFactory(@NotNull class_1309 hostEntity) {
        class_1937 level = hostEntity.method_37908();
        Host host = (Host)hostEntity;
        Option<class_1299<?>> embryoTypeOption = host.getEmbryoType();
        if (embryoTypeOption.isNone()) {
            return null;
        }
        class_1297 embryo = ((class_1299)embryoTypeOption.unwrap()).method_5883(level);
        if (embryo == null) {
            return null;
        }
        if (embryo instanceof class_1308) {
            class_1308 mob = (class_1308)embryo;
            mob.method_5971();
        }
        if (embryo instanceof Alien) {
            Alien alien = (Alien)embryo;
            EmbryoUtil.applyGenesToEmbryo(hostEntity.method_5864(), host.getOrCreateParasiteGeneContainer(), (GeneCarrier)((Object)alien), true);
            alien.setHostType(hostEntity.method_5864());
        }
        embryo.method_60949(hostEntity.method_19538(), hostEntity.method_36454(), hostEntity.method_36455());
        embryo.method_36456(hostEntity.method_36454());
        embryo.method_36457(hostEntity.method_36455());
        if (embryo instanceof class_1309) {
            class_1309 livingEmbryo = (class_1309)embryo;
            for (class_1293 effect : hostEntity.method_6026()) {
                livingEmbryo.method_6092(new class_1293(effect.method_5579(), Integer.MAX_VALUE, effect.method_5578(), false, false));
            }
        }
        level.method_8649(embryo);
        return embryo;
    }
}

