/*
 * Decompiled with CFR 0.152.
 */
package com.avp.client.animation;

import mod.azure.azurelib.common.animation.AzAnimationContext;
import mod.azure.azurelib.common.model.AzBakedModel;
import mod.azure.azurelib.common.model.AzBone;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_3532;
import net.minecraft.class_8080;

public class BasicAnimationUtils {
    public static void applyHeadRotations(class_1309 entity, AzAnimationContext<?> context, float partialTick, String headName, float pitchOffset) {
        AzBakedModel bakedModel = context.boneCache().getBakedModel();
        AzBone head = bakedModel.getBoneOrNull(headName);
        if (head != null) {
            float headPitch = BasicAnimationUtils.computeHeadPitch(entity, partialTick);
            head.setRotX(headPitch * ((float)Math.PI / 180) + pitchOffset);
            head.setRotY(BasicAnimationUtils.computeNetHeadYaw(entity, partialTick) * ((float)Math.PI / 180));
        }
    }

    public static void applyLimbRotations(class_1309 entity, AzAnimationContext<?> context, float partialTick, String leftArmName, String rightArmName, String leftLegName, String rightLegName, float armOffset, float legOffset) {
        AzBakedModel bakedModel = context.boneCache().getBakedModel();
        float constant = 0.6662f;
        class_8080 walkAnimation = entity.field_42108;
        float walkPosition = walkAnimation.method_48572(partialTick);
        float walkSpeed = walkAnimation.method_48566();
        AzBone leftArm = bakedModel.getBoneOrNull(leftArmName);
        AzBone rightArm = bakedModel.getBoneOrNull(rightArmName);
        AzBone leftLeg = bakedModel.getBoneOrNull(leftLegName);
        AzBone rightLeg = bakedModel.getBoneOrNull(rightLegName);
        if (leftArm != null) {
            leftArm.setRotX(class_3532.method_15362((float)(walkPosition * constant)) * 2.0f * walkSpeed * 0.5f + armOffset);
        }
        if (rightArm != null) {
            rightArm.setRotX(class_3532.method_15362((float)(walkPosition * constant + (float)Math.PI)) * 2.0f * walkSpeed * 0.5f + armOffset);
        }
        if (leftLeg != null) {
            leftLeg.setRotX(class_3532.method_15362((float)(walkPosition * constant + (float)Math.PI)) * 1.4f * walkSpeed * 0.5f + legOffset);
        }
        if (rightLeg != null) {
            rightLeg.setRotX(class_3532.method_15362((float)(walkPosition * constant)) * 1.4f * walkSpeed * 0.5f + legOffset);
        }
    }

    private static float computeNetHeadYaw(class_1309 entity, float partialTick) {
        class_1297 class_12972;
        boolean shouldSit = entity.method_5765() && entity.method_5854() != null;
        float lerpBodyRot = class_3532.method_17821((float)partialTick, (float)entity.field_6220, (float)entity.field_6283);
        float lerpHeadRot = class_3532.method_17821((float)partialTick, (float)entity.field_6259, (float)entity.field_6241);
        float netHeadYaw = lerpHeadRot - lerpBodyRot;
        if (shouldSit && (class_12972 = entity.method_5854()) instanceof class_1309) {
            class_1309 livingVehicle = (class_1309)class_12972;
            lerpBodyRot = class_3532.method_17821((float)partialTick, (float)livingVehicle.field_6220, (float)livingVehicle.field_6283);
            netHeadYaw = lerpHeadRot - lerpBodyRot;
            float clampedHeadYaw = class_3532.method_15363((float)class_3532.method_15393((float)netHeadYaw), (float)-85.0f, (float)85.0f);
            lerpBodyRot = lerpHeadRot - clampedHeadYaw;
            if (clampedHeadYaw * clampedHeadYaw > 2500.0f) {
                lerpBodyRot += clampedHeadYaw * 0.2f;
            }
            netHeadYaw = lerpHeadRot - lerpBodyRot;
        }
        return -netHeadYaw;
    }

    private static float computeHeadPitch(class_1309 entity, float partialTick) {
        return -class_3532.method_16439((float)partialTick, (float)entity.field_6004, (float)entity.method_36455());
    }

    private BasicAnimationUtils() {
        throw new UnsupportedOperationException();
    }
}

