/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.gameplay.ai.goal;

import com.alien.common.data.AlienVariantTypes;
import com.alien.common.gameplay.entity.living.alien.ovomorph.Ovomorph;
import com.alien.common.gameplay.entity.living.alien.xenomorph.queen.Queen;
import com.alien.common.model.alien.variant.AlienVariant;
import com.avp.common.registry.init.AVPSoundEvents;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import com.lib.common.model.GeneCarrier;
import com.lib.common.model.GeneDecayLevelType;
import com.lib.common.util.GeneIntegrityUtil;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1352;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3419;

public class QueenLayEggGoal
extends class_1352 {
    private static final int MAX_EGG_LAY_COOLDOWN_IN_TICKS = (int)TimeUnit.MINUTES.toSeconds(1L) * 20;
    private static final int MAX_EGG_COUNT_IN_HIVE = 60;
    private final Queen queen;
    private int eggLayCooldownInTicks;

    public QueenLayEggGoal(Queen queen) {
        this.queen = queen;
        this.eggLayCooldownInTicks = MAX_EGG_LAY_COOLDOWN_IN_TICKS;
    }

    public boolean method_6264() {
        if (this.eggLayCooldownInTicks > 0) {
            --this.eggLayCooldownInTicks;
            return false;
        }
        return this.queen.method_5805() && this.queen.getOvipositorManager().hasOvipositor() && AlienVariantTypes.getFor(this.queen.getVariant()).canReproduce() && this.queen.getHiveManager().hive().isSomeAnd(hive -> hive.isAlive() && hive.getSpaceManager().isEntityWithinHive((class_1297)this.queen) && hive.getMembershipManager().getMembersMatching(member -> member.method_20210(AVPEntityTypeTags.OVOMORPHS)).size() < 60) && this.noEggsNearby();
    }

    public void method_6269() {
        Ovomorph ovomorph;
        this.eggLayCooldownInTicks = MAX_EGG_LAY_COOLDOWN_IN_TICKS;
        class_1937 level = this.queen.method_37908();
        boolean isRoyal = this.queen.method_59922().method_43048(100) < 5;
        AlienVariant variant = this.shouldBeAberrant() ? AlienVariant.ABERRANT : this.queen.getVariant();
        class_1299<? extends Ovomorph> ovomorphType = Ovomorph.getType(variant, isRoyal);
        Ovomorph ovomorph2 = ovomorph = ovomorphType == null ? null : (Ovomorph)ovomorphType.method_5883(level);
        if (ovomorph == null) {
            return;
        }
        ovomorph.method_33574(this.queen.getOvipositorManager().getEggLayingPosition());
        ovomorph.method_5971();
        ovomorph.isRooted.set(false);
        this.queen.getGeneManager().getGeneContainer().transfer(ovomorph.getGeneManager().getGeneContainer(), false);
        level.method_43129(null, (class_1297)this.queen, AVPSoundEvents.ENTITY_OVOMORPH_LAID.get(), class_3419.field_15251, 1.0f, 1.0f);
        level.method_8649((class_1297)ovomorph);
    }

    private boolean shouldBeAberrant() {
        GeneCarrier geneCarrier = (GeneCarrier)((Object)this.queen);
        GeneDecayLevelType geneDecayLevel = GeneIntegrityUtil.getGeneDecayLevel(geneCarrier);
        return switch (geneDecayLevel) {
            default -> throw new MatchException(null, null);
            case GeneDecayLevelType.FATAL, GeneDecayLevelType.VOLATILE -> true;
            case GeneDecayLevelType.STABLE -> false;
            case GeneDecayLevelType.UNSTABLE -> {
                double totalGeneIntegrity = Math.abs(GeneIntegrityUtil.getTotalGeneticIntegrity(geneCarrier));
                double chance = totalGeneIntegrity - Math.floor(totalGeneIntegrity);
                if (this.queen.method_59922().method_43058() < chance) {
                    yield true;
                }
                yield false;
            }
        };
    }

    private boolean noEggsNearby() {
        this.eggLayCooldownInTicks = MAX_EGG_LAY_COOLDOWN_IN_TICKS;
        return this.queen.method_37908().method_8390(Ovomorph.class, this.getBoundingBoxAtEggLayingPosition(), entity -> entity.method_5864().method_20210(AVPEntityTypeTags.OVOMORPHS) && entity.isRooted.get() == false).isEmpty();
    }

    private class_238 getBoundingBoxAtEggLayingPosition() {
        class_243 eggPos = this.queen.getOvipositorManager().getEggLayingPosition();
        double halfSize = 0.5;
        return new class_238(eggPos.field_1352 - halfSize, eggPos.field_1351 - (double)this.queen.method_37908().method_8597().comp_652(), eggPos.field_1350 - halfSize, eggPos.field_1352 + halfSize, eggPos.field_1351 + 5.0, eggPos.field_1350 + halfSize);
    }
}

