/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.gameplay.block.property;

import com.just.core.functional.option.Option;
import java.util.function.ToIntFunction;
import net.minecraft.class_1299;
import net.minecraft.class_1767;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2766;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class BlockPropertyBuilder {
    private final Option<class_4970> blockBehaviourOption;
    private Option<Float> explosionResistanceOption;
    private Option<Boolean> forceSolidOnOption;
    private Option<Boolean> forceSolidOffOption;
    private Option<Float> frictionOption;
    private Option<class_2766> instrumentOption;
    private Option<class_4970.class_4973> isRedstoneConductorOption;
    private Option<class_4970.class_4973> isSuffocatingOption;
    private Option<class_4970.class_4972<class_1299<?>>> isValidSpawnOption;
    private Option<class_4970.class_4973> isViewBlockingOption;
    private Option<ToIntFunction<class_2680>> lightLevelOption;
    private Option<class_3620> mapColorOption;
    private Option<Boolean> noCollisionOption;
    private Option<Boolean> noOcclusionOption;
    private Option<class_3619> pushReactionOption;
    private Option<Boolean> randomTicksOption;
    private Option<Boolean> replaceableOption;
    private Option<Boolean> requiresCorrectToolForDropsOption;
    private Option<class_2498> soundTypeOption;
    private Option<Float> strengthOption;

    public static BlockPropertyBuilder inherit(class_4970 blockBehaviour) {
        return new BlockPropertyBuilder(blockBehaviour);
    }

    public static BlockPropertyBuilder of() {
        return new BlockPropertyBuilder();
    }

    private BlockPropertyBuilder() {
        this(null);
    }

    private BlockPropertyBuilder(@Nullable class_4970 blockBehaviour) {
        this((Option<class_4970>)Option.ofNullable((Object)blockBehaviour), (Option<Float>)Option.none(), (Option<Boolean>)Option.none(), (Option<Boolean>)Option.none(), (Option<Float>)Option.none(), (Option<class_2766>)Option.none(), (Option<class_4970.class_4973>)Option.none(), (Option<class_4970.class_4973>)Option.none(), (Option<class_4970.class_4972<class_1299<?>>>)Option.none(), (Option<class_4970.class_4973>)Option.none(), (Option<ToIntFunction<class_2680>>)Option.none(), (Option<class_3620>)Option.none(), (Option<Boolean>)Option.none(), (Option<Boolean>)Option.none(), (Option<class_3619>)Option.none(), (Option<Boolean>)Option.none(), (Option<Boolean>)Option.none(), (Option<Boolean>)Option.none(), (Option<class_2498>)Option.none(), (Option<Float>)Option.none());
    }

    private BlockPropertyBuilder(Option<class_4970> blockBehaviourOption, Option<Float> explosionResistanceOption, Option<Boolean> forceSolidOnOption, Option<Boolean> forceSolidOffOption, Option<Float> frictionOption, Option<class_2766> instrumentOption, Option<class_4970.class_4973> isRedstoneConductorOption, Option<class_4970.class_4973> isSuffocatingOption, Option<class_4970.class_4972<class_1299<?>>> isValidSpawnOption, Option<class_4970.class_4973> isViewBlockingOption, Option<ToIntFunction<class_2680>> lightLevelOption, Option<class_3620> mapColorOption, Option<Boolean> noCollisionOption, Option<Boolean> noOcclusionOption, Option<class_3619> pushReactionOption, Option<Boolean> randomTicksOption, Option<Boolean> replaceableOption, Option<Boolean> requiresCorrectToolForDropsOption, Option<class_2498> soundTypeOption, Option<Float> strengthOption) {
        this.blockBehaviourOption = blockBehaviourOption;
        this.explosionResistanceOption = explosionResistanceOption;
        this.forceSolidOnOption = forceSolidOnOption;
        this.forceSolidOffOption = forceSolidOffOption;
        this.frictionOption = frictionOption;
        this.instrumentOption = instrumentOption;
        this.isRedstoneConductorOption = isRedstoneConductorOption;
        this.isSuffocatingOption = isSuffocatingOption;
        this.isValidSpawnOption = isValidSpawnOption;
        this.isViewBlockingOption = isViewBlockingOption;
        this.lightLevelOption = lightLevelOption;
        this.mapColorOption = mapColorOption;
        this.noCollisionOption = noCollisionOption;
        this.noOcclusionOption = noOcclusionOption;
        this.pushReactionOption = pushReactionOption;
        this.randomTicksOption = randomTicksOption;
        this.replaceableOption = replaceableOption;
        this.requiresCorrectToolForDropsOption = requiresCorrectToolForDropsOption;
        this.soundTypeOption = soundTypeOption;
        this.strengthOption = strengthOption;
    }

    public BlockPropertyBuilder explosionResistance(float explosionResistance) {
        BlockPropertyBuilder copy = this.copy();
        copy.explosionResistanceOption = Option.some((Object)Float.valueOf(explosionResistance));
        return copy;
    }

    public BlockPropertyBuilder forceSolidOn() {
        BlockPropertyBuilder copy = this.copy();
        copy.forceSolidOnOption = Option.some((Object)true);
        return copy;
    }

    public BlockPropertyBuilder forceSolidOff() {
        BlockPropertyBuilder copy = this.copy();
        copy.forceSolidOffOption = Option.some((Object)true);
        return copy;
    }

    public BlockPropertyBuilder friction(float friction) {
        BlockPropertyBuilder copy = this.copy();
        copy.frictionOption = Option.some((Object)Float.valueOf(friction));
        return copy;
    }

    public BlockPropertyBuilder instrument(class_2766 instrument) {
        BlockPropertyBuilder copy = this.copy();
        copy.instrumentOption = Option.some((Object)instrument);
        return copy;
    }

    public BlockPropertyBuilder isRedstoneConductor(class_4970.class_4973 predicate) {
        BlockPropertyBuilder copy = this.copy();
        copy.isRedstoneConductorOption = Option.some((Object)predicate);
        return copy;
    }

    public BlockPropertyBuilder isSuffocating(class_4970.class_4973 predicate) {
        BlockPropertyBuilder copy = this.copy();
        copy.isSuffocatingOption = Option.some((Object)predicate);
        return copy;
    }

    public BlockPropertyBuilder isValidSpawn(class_4970.class_4972<class_1299<?>> predicate) {
        BlockPropertyBuilder copy = this.copy();
        copy.isValidSpawnOption = Option.some(predicate);
        return copy;
    }

    public BlockPropertyBuilder isViewBlocking(class_4970.class_4973 predicate) {
        BlockPropertyBuilder copy = this.copy();
        copy.isViewBlockingOption = Option.some((Object)predicate);
        return copy;
    }

    public BlockPropertyBuilder lightLevel(ToIntFunction<class_2680> toIntFunction) {
        BlockPropertyBuilder copy = this.copy();
        copy.lightLevelOption = Option.some(toIntFunction);
        return copy;
    }

    public BlockPropertyBuilder mapColor(class_1767 dyeColor) {
        return this.mapColor(dyeColor.method_7794());
    }

    public BlockPropertyBuilder mapColor(class_3620 mapColor) {
        BlockPropertyBuilder copy = this.copy();
        copy.mapColorOption = Option.some((Object)mapColor);
        return copy;
    }

    public BlockPropertyBuilder noCollision() {
        BlockPropertyBuilder copy = this.copy();
        copy.noCollisionOption = Option.some((Object)true);
        return copy;
    }

    public BlockPropertyBuilder noOcclusion() {
        BlockPropertyBuilder copy = this.copy();
        copy.noOcclusionOption = Option.some((Object)true);
        return copy;
    }

    public BlockPropertyBuilder pushReaction(class_3619 pushReaction) {
        BlockPropertyBuilder copy = this.copy();
        copy.pushReactionOption = Option.some((Object)pushReaction);
        return copy;
    }

    public BlockPropertyBuilder randomTicks() {
        BlockPropertyBuilder copy = this.copy();
        copy.randomTicksOption = Option.some((Object)true);
        return copy;
    }

    public BlockPropertyBuilder replaceable() {
        BlockPropertyBuilder copy = this.copy();
        copy.replaceableOption = Option.some((Object)true);
        return copy;
    }

    public BlockPropertyBuilder requiresCorrectToolForDrops() {
        BlockPropertyBuilder copy = this.copy();
        copy.requiresCorrectToolForDropsOption = Option.some((Object)true);
        return copy;
    }

    public BlockPropertyBuilder sound(class_2498 soundType) {
        BlockPropertyBuilder copy = this.copy();
        copy.soundTypeOption = Option.some((Object)soundType);
        return copy;
    }

    public BlockPropertyBuilder strength(float strength) {
        BlockPropertyBuilder copy = this.copy();
        copy.strengthOption = Option.some((Object)Float.valueOf(strength));
        return copy;
    }

    public BlockPropertyBuilder strength(float strength, float explosionResistance) {
        return this.strength(strength).explosionResistance(explosionResistance);
    }

    public BlockPropertyBuilder copy() {
        return new BlockPropertyBuilder(this.blockBehaviourOption, this.explosionResistanceOption, this.forceSolidOnOption, this.forceSolidOffOption, this.frictionOption, this.instrumentOption, this.isRedstoneConductorOption, this.isSuffocatingOption, this.isValidSpawnOption, this.isViewBlockingOption, this.lightLevelOption, this.mapColorOption, this.noCollisionOption, this.noOcclusionOption, this.pushReactionOption, this.randomTicksOption, this.replaceableOption, this.requiresCorrectToolForDropsOption, this.soundTypeOption, this.strengthOption);
    }

    public class_4970.class_2251 build() {
        class_4970.class_2251 baseProperties = (class_4970.class_2251)this.blockBehaviourOption.map(class_4970.class_2251::method_9630).unwrapOr((Object)class_4970.class_2251.method_9637());
        this.explosionResistanceOption.ifSome(arg_0 -> ((class_4970.class_2251)baseProperties).method_36558(arg_0));
        this.forceSolidOnOption.ifSome($ -> baseProperties.method_51369());
        this.forceSolidOffOption.ifSome($ -> baseProperties.method_51370());
        this.frictionOption.ifSome(arg_0 -> ((class_4970.class_2251)baseProperties).method_9628(arg_0));
        this.instrumentOption.ifSome(arg_0 -> ((class_4970.class_2251)baseProperties).method_51368(arg_0));
        this.isSuffocatingOption.ifSome(arg_0 -> ((class_4970.class_2251)baseProperties).method_26243(arg_0));
        this.isRedstoneConductorOption.ifSome(arg_0 -> ((class_4970.class_2251)baseProperties).method_26236(arg_0));
        this.isValidSpawnOption.ifSome(arg_0 -> ((class_4970.class_2251)baseProperties).method_26235(arg_0));
        this.isViewBlockingOption.ifSome(arg_0 -> ((class_4970.class_2251)baseProperties).method_26245(arg_0));
        this.lightLevelOption.ifSome(arg_0 -> ((class_4970.class_2251)baseProperties).method_9631(arg_0));
        this.mapColorOption.ifSome(arg_0 -> ((class_4970.class_2251)baseProperties).method_31710(arg_0));
        this.noCollisionOption.ifSome($ -> baseProperties.method_9634());
        this.noOcclusionOption.ifSome($ -> baseProperties.method_22488());
        this.pushReactionOption.ifSome(arg_0 -> ((class_4970.class_2251)baseProperties).method_50012(arg_0));
        this.randomTicksOption.ifSome($ -> baseProperties.method_9640());
        this.replaceableOption.ifSome($ -> baseProperties.method_51371());
        this.requiresCorrectToolForDropsOption.ifSome($ -> baseProperties.method_29292());
        this.soundTypeOption.ifSome(arg_0 -> ((class_4970.class_2251)baseProperties).method_9626(arg_0));
        this.strengthOption.ifSome(arg_0 -> ((class_4970.class_2251)baseProperties).method_9632(arg_0));
        return baseProperties;
    }
}

