/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.gameplay.explosion;

import com.avp.common.gameplay.explosion.Explosion;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public class ExplosionCursor {
    private final Explosion explosion;
    private final class_2350 direction;
    private int x;
    private int y;
    private int depth;

    public ExplosionCursor(Explosion explosion, class_2350 direction) {
        this.explosion = explosion;
        this.direction = direction;
    }

    public class_2338 next() {
        class_2338 centerPos = this.explosion.config().centerBlockPosition();
        class_2338 wallCenterPos = centerPos.method_10079(this.direction, this.depth);
        class_2338 wallTopLeftCorner = wallCenterPos.method_10079(this.getPerpendicularDirection1(), this.depth).method_10079(this.getPerpendicularDirection2(), this.depth);
        class_2338 currentPos = wallTopLeftCorner.method_10069(this.getXOffset(), this.getYOffset(), this.getZOffset());
        this.advanceCursor();
        return currentPos;
    }

    private void advanceCursor() {
        ++this.x;
        if (this.x > this.depth * 2) {
            this.x = 0;
            ++this.y;
        }
        if (this.y > this.depth * 2) {
            this.y = 0;
            ++this.depth;
        }
    }

    public boolean canExpandFurther() {
        return this.depth < this.explosion.config().directionToRadiusMap().get(this.direction);
    }

    private class_2350 getPerpendicularDirection1() {
        return switch (this.direction) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11043, class_2350.field_11035 -> class_2350.field_11039;
            case class_2350.field_11034, class_2350.field_11039 -> class_2350.field_11036;
            case class_2350.field_11036, class_2350.field_11033 -> class_2350.field_11043;
        };
    }

    private class_2350 getPerpendicularDirection2() {
        return switch (this.direction) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11043, class_2350.field_11035 -> class_2350.field_11036;
            case class_2350.field_11034, class_2350.field_11039 -> class_2350.field_11043;
            case class_2350.field_11036, class_2350.field_11033 -> class_2350.field_11039;
        };
    }

    private int getXOffset() {
        return switch (this.direction) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11043, class_2350.field_11035 -> this.x;
            case class_2350.field_11034, class_2350.field_11039 -> 0;
            case class_2350.field_11036, class_2350.field_11033 -> this.x;
        };
    }

    private int getYOffset() {
        return switch (this.direction) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039 -> -this.y;
            case class_2350.field_11036, class_2350.field_11033 -> 0;
        };
    }

    private int getZOffset() {
        return switch (this.direction) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11043, class_2350.field_11035 -> 0;
            case class_2350.field_11034, class_2350.field_11039 -> this.x;
            case class_2350.field_11036, class_2350.field_11033 -> this.y;
        };
    }
}

