/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.gameplay.explosion;

import com.avp.common.gameplay.explosion.Explosion;
import com.avp.common.gameplay.explosion.ExplosionCallbacks;
import com.avp.common.gameplay.explosion.ExplosionConfig;
import com.avp.common.gameplay.explosion.ExplosionCursor;
import com.avp.server.ServerScheduler;
import com.lib.common.util.DirectionUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public class ExplosionProcessor {
    private final Explosion explosion;
    private final Map<class_2350, ExplosionCursor> directionToExplosionCursorMap;

    public ExplosionProcessor(Explosion explosion) {
        this.explosion = explosion;
        this.directionToExplosionCursorMap = new EnumMap(Arrays.stream(DirectionUtil.VALUES).collect(Collectors.toMap(Function.identity(), direction -> new ExplosionCursor(explosion, (class_2350)direction))));
    }

    public void process() {
        ExplosionConfig config = this.explosion.config();
        this.processBatch(config.blockSampleCountPerCycle(), config.cycleDelayInTicks());
    }

    private void processBatch(int maxBlocksPerCycle, int delayBetweenCycles) {
        ExplosionCallbacks callbacks = this.explosion.callbacks();
        callbacks.onCycleStart();
        List<class_2338> blocksToSample = this.sampleBlocks(maxBlocksPerCycle);
        for (class_2338 pos : blocksToSample) {
            callbacks.onBlockSample(this.explosion, pos);
        }
        callbacks.onCycleFinish(blocksToSample);
        if (this.canAnyWallMoveFurther()) {
            ServerScheduler.schedule(() -> this.processBatch(maxBlocksPerCycle, delayBetweenCycles), Duration.ofMillis((long)delayBetweenCycles * 50L));
        } else {
            callbacks.onExplosionFinish();
        }
    }

    private List<class_2338> sampleBlocks(int maxBlocksPerCycle) {
        int count = 0;
        ArrayList<class_2338> sampledBlocks = new ArrayList<class_2338>();
        block0: while (count < maxBlocksPerCycle && this.canAnyWallMoveFurther()) {
            for (Map.Entry<class_2350, ExplosionCursor> entry : this.directionToExplosionCursorMap.entrySet()) {
                if (count >= maxBlocksPerCycle) continue block0;
                if (!entry.getValue().canExpandFurther()) continue;
                class_2338 pos = entry.getValue().next();
                if (!this.explosion.samplerPredicate().test(this.explosion, pos)) continue;
                sampledBlocks.add(pos);
                ++count;
            }
        }
        return sampledBlocks;
    }

    private boolean canAnyWallMoveFurther() {
        return this.directionToExplosionCursorMap.values().stream().anyMatch(ExplosionCursor::canExpandFurther);
    }
}

