/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.util;

import java.util.Set;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2487;

public class AVPEntityTransitionUtil {
    public static final Set<String> DEFAULT_NBT_KEY_BLACKLIST = Set.of("id", "UUID", "Pos", "Motion", "Rotation", "Health", "attributes");

    public static <T extends class_1297> EntityTransitionResult transitionInto(class_1297 oldEntity, class_1299<T> newEntityType) {
        return AVPEntityTransitionUtil.transitionInto(oldEntity, newEntityType, DEFAULT_NBT_KEY_BLACKLIST);
    }

    public static <T extends class_1297> EntityTransitionResult transitionInto(class_1297 oldEntity, class_1299<T> newEntityType, Set<String> blacklistedKeys) {
        boolean canFitAtPosition;
        class_1937 level = oldEntity.method_37908();
        if (level.field_9236) {
            return EntityTransitionResult.ClientSide.INSTANCE;
        }
        class_1297 newEntity = newEntityType.method_5883(level);
        if (newEntity == null) {
            return EntityTransitionResult.EntityCreation.INSTANCE;
        }
        newEntity.method_33574(oldEntity.method_19538());
        boolean bl = canFitAtPosition = level.method_52569(newEntity, newEntity.method_5829()) && !level.method_22345(newEntity.method_5829());
        if (!canFitAtPosition) {
            return EntityTransitionResult.Obstructed.INSTANCE;
        }
        AVPEntityTransitionUtil.migrateEntityData(oldEntity, newEntity, blacklistedKeys);
        level.method_8649(newEntity);
        oldEntity.method_31472();
        return new EntityTransitionResult.Success<class_1297>(newEntity);
    }

    public static void migrateEntityData(class_1297 oldEntity, class_1297 newEntity) {
        AVPEntityTransitionUtil.migrateEntityData(oldEntity, newEntity, DEFAULT_NBT_KEY_BLACKLIST);
    }

    public static void migrateEntityData(class_1297 oldEntity, class_1297 newEntity, Set<String> blacklistedKeys) {
        class_2487 oldEntityData = new class_2487();
        oldEntity.method_5662(oldEntityData);
        blacklistedKeys.forEach(arg_0 -> ((class_2487)oldEntityData).method_10551(arg_0));
        newEntity.method_5651(oldEntityData);
        newEntity.method_60949(oldEntity.method_19538(), oldEntity.method_36454(), oldEntity.method_36455());
        newEntity.method_36456(oldEntity.method_36454());
        newEntity.method_36457(oldEntity.method_36455());
        newEntity.method_18799(oldEntity.method_18798());
        if (oldEntity instanceof class_1309) {
            class_1309 oldLivingEntity = (class_1309)oldEntity;
            if (newEntity instanceof class_1309) {
                class_1309 newLivingEntity = (class_1309)newEntity;
                newLivingEntity.field_6283 = oldLivingEntity.field_6283;
                newLivingEntity.field_6241 = oldLivingEntity.field_6241;
                for (class_1293 effect : oldLivingEntity.method_6026()) {
                    newLivingEntity.method_6092(new class_1293(effect));
                }
            }
        }
        if (oldEntity instanceof class_1308) {
            class_1308 oldMobEntity = (class_1308)oldEntity;
            if (newEntity instanceof class_1308) {
                class_1308 newMobEntity = (class_1308)newEntity;
                if (oldMobEntity.method_5947()) {
                    newMobEntity.method_5971();
                }
            }
        }
    }

    public static sealed interface EntityTransitionResult {

        public record Success<T extends class_1297>(T newEntity) implements EntityTransitionResult
        {
        }

        public static enum Obstructed implements EntityTransitionResult
        {
            INSTANCE;

        }

        public static enum EntityCreation implements EntityTransitionResult
        {
            INSTANCE;

        }

        public static enum ClientSide implements EntityTransitionResult
        {
            INSTANCE;

        }
    }
}

