/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.util;

import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.model.alien.Host;
import com.avp.common.registry.init.AVPMobEffects;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import com.avp.common.registry.tag.AVPItemTags;
import com.predator.common.gameplay.entity.living.yautja.Yautja;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;

public class AVPPredicates {
    public static final Predicate<class_1309> IS_IMMORTAL = livingEntity -> {
        class_1657 player;
        return livingEntity instanceof class_1657 && ((player = (class_1657)livingEntity).method_7337() || player.method_7325());
    };
    public static final Predicate<class_1309> HAS_FACE_MASK = livingEntity -> livingEntity.method_6118(class_1304.field_6169).method_31573(AVPItemTags.FACEHUGGER_RESISTANT_HELMETS);
    public static final Predicate<class_1309> HAS_MASK = livingEntity -> {
        Yautja yautja;
        return livingEntity instanceof Yautja && (yautja = (Yautja)livingEntity).hasMask();
    };

    public static <T> Predicate<T> alwaysTrue() {
        return $ -> true;
    }

    public static boolean canBeIrradiated(class_1297 entity) {
        class_1309 livingEntity;
        if (!(entity instanceof class_1309) || (livingEntity = (class_1309)entity).method_5864().method_20210(AVPEntityTypeTags.RADIATION_RESISTANT) || IS_IMMORTAL.test(livingEntity) || livingEntity.method_6059(AVPMobEffects.RADIATION.getHolder()) || !livingEntity.method_5805()) {
            return false;
        }
        boolean hasFullRadiationResistantArmor = AVPPredicates.hasFullArmorSetMatching(livingEntity, itemStack -> itemStack.method_31573(AVPItemTags.RADIATION_RESISTANT_ARMORS));
        return !hasFullRadiationResistantArmor;
    }

    public static boolean hasFullArmorSetMatching(class_1309 livingEntity, Predicate<class_1799> itemStackPredicate) {
        return itemStackPredicate.test(livingEntity.method_6118(class_1304.field_6169)) && itemStackPredicate.test(livingEntity.method_6118(class_1304.field_6174)) && itemStackPredicate.test(livingEntity.method_6118(class_1304.field_6172)) && itemStackPredicate.test(livingEntity.method_6118(class_1304.field_6166));
    }

    public static boolean hasShield(class_1297 target) {
        class_1309 livingEntity;
        return target instanceof class_1309 && (livingEntity = (class_1309)target).method_6030().method_31574(class_1802.field_8255);
    }

    public static boolean hasEmbryo(class_1297 target) {
        Host host;
        return target instanceof Host && (host = (Host)target).getEmbryoType().isSome();
    }

    public static boolean isFreeHost(Alien parasite, class_1297 hostTarget) {
        return AVPPredicates.isLiving(hostTarget) && AVPPredicates.isHost(hostTarget) && !AVPPredicates.hasEmbryo(hostTarget) && !AVPPredicates.isSelfOrOtherParasiteAttached(parasite, hostTarget) && !HAS_MASK.test((class_1309)hostTarget) && !HAS_FACE_MASK.test((class_1309)hostTarget);
    }

    public static boolean isHost(class_1297 target) {
        return target.method_5864().method_20210(AVPEntityTypeTags.HOSTS) && AVPPredicates.isLiving(target) && !AVPPredicates.isBaby(target) && !IS_IMMORTAL.test((class_1309)target);
    }

    public static boolean isParasiteAttached(class_1297 target) {
        return target.method_5703(passenger -> passenger.method_5864().method_20210(AVPEntityTypeTags.PARASITES));
    }

    public static boolean isSelfOrOtherParasiteAttached(Alien parasite, class_1297 target) {
        return target.method_5703(passenger -> passenger.equals((Object)parasite) || passenger.method_5864().method_20210(AVPEntityTypeTags.PARASITES));
    }

    public static boolean isBaby(class_1297 target) {
        class_1309 livingEntity;
        return target instanceof class_1309 && (livingEntity = (class_1309)target).method_6109();
    }

    public static boolean isLiving(class_1297 target) {
        class_1309 livingEntity;
        return target instanceof class_1309 && (livingEntity = (class_1309)target).method_5805() && !livingEntity.method_29504();
    }
}

