/*
 * Decompiled with CFR 0.152.
 */
package com.avp.fabric.data.recipe.builder;

import com.avp.fabric.data.recipe.builder.RecipeBuilder;
import com.avp.fabric.data.recipe.util.RecipeProviderProxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2450;
import net.minecraft.class_6862;
import net.minecraft.class_7800;

public class ShapelessRecipeBuilder {
    private final RecipeBuilder baseBuilder;
    private final List<UnaryOperator<class_2450>> transformations;
    private class_7800 recipeCategory;
    private UnaryOperator<String> customNameOperator;

    ShapelessRecipeBuilder(RecipeBuilder baseBuilder) {
        this.baseBuilder = baseBuilder;
        this.transformations = new ArrayList<UnaryOperator<class_2450>>();
        this.recipeCategory = class_7800.field_40642;
    }

    public ShapelessRecipeBuilder withCategory(class_7800 recipeCategory) {
        this.recipeCategory = recipeCategory;
        return this;
    }

    public ShapelessRecipeBuilder withCustomName(UnaryOperator<String> customNameOperator) {
        this.customNameOperator = customNameOperator;
        return this;
    }

    public ShapelessRecipeBuilder requires(int count, class_1856 ingredient) {
        this.transformations.add(shapelessRecipeBuilder -> {
            shapelessRecipeBuilder.method_10453(ingredient, count);
            List<class_1799> ingredientItemStacks = Arrays.stream(ingredient.method_8105()).sorted(Comparator.comparing(itemStackA -> RecipeProviderProxy.getNameForItem((class_1935)itemStackA.method_7909()))).toList();
            for (class_1799 itemStack : ingredientItemStacks) {
                String itemName = RecipeProviderProxy.getNameForItem((class_1935)itemStack.method_7909());
                shapelessRecipeBuilder.method_10442("has_" + itemName, RecipeProviderProxy.has((class_1935)itemStack.method_7909()));
            }
            return shapelessRecipeBuilder;
        });
        return this;
    }

    public ShapelessRecipeBuilder requires(int count, Supplier<? extends class_1935> itemLikeSupplier) {
        return this.requires(count, itemLikeSupplier.get());
    }

    public ShapelessRecipeBuilder requires(int count, class_1935 itemLike) {
        this.transformations.add(shapelessRecipeBuilder -> {
            String itemName = RecipeProviderProxy.getNameForItem((class_1935)itemLike.method_8389());
            shapelessRecipeBuilder.method_10449(itemLike, count);
            shapelessRecipeBuilder.method_10442("has_" + itemName, RecipeProviderProxy.has(itemLike));
            return shapelessRecipeBuilder;
        });
        return this;
    }

    public ShapelessRecipeBuilder requires(int count, class_6862<class_1792> itemTagKey) {
        this.transformations.add(shapelessRecipeBuilder -> {
            shapelessRecipeBuilder.method_10453(class_1856.method_8106((class_6862)itemTagKey), count);
            shapelessRecipeBuilder.method_10442("has_" + itemTagKey.comp_327().method_12832(), RecipeProviderProxy.has(itemTagKey));
            return shapelessRecipeBuilder;
        });
        return this;
    }

    public void into(int count, Supplier<? extends class_1935> destinationSupplier) {
        this.into(count, destinationSupplier.get());
    }

    public void into(int count, class_1935 destination) {
        class_2450 builder = class_2450.method_10448((class_7800)this.recipeCategory, (class_1935)destination, (int)count);
        for (UnaryOperator<class_2450> transformation : this.transformations) {
            builder = (class_2450)transformation.apply(builder);
        }
        if (this.customNameOperator == null) {
            builder.method_10431(this.baseBuilder.getRecipeOutput());
        } else {
            String destinationName = RecipeProviderProxy.getNameForItem(destination);
            builder.method_36443(this.baseBuilder.getRecipeOutput(), (String)this.customNameOperator.apply(destinationName));
        }
    }
}

