/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.block.entity.power.impl;

import com.avp.common.registry.init.AVPBlockEntityTypes;
import com.human.common.gameplay.block.entity.power.PowerNodeBlockEntity;
import com.human.common.gameplay.power.PowerNode;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class SolarPanelBlockEntity
extends PowerNodeBlockEntity
implements PowerNode.PowerProducer {
    private static final int MC_DAY_LENGTH_IN_TICKS = 24000;
    private static final int MC_START_OF_DUSK_IN_TICKS = 12000;
    private static final int MC_START_OF_NIGHT_IN_TICKS = 14000;
    private static final int MC_START_OF_DAWN_IN_TICKS = 23000;
    private static final int MC_START_OF_DAY_IN_TICKS = 1000;

    public SolarPanelBlockEntity(class_2338 pos, class_2680 state) {
        super(AVPBlockEntityTypes.SOLAR_PANEL.get(), pos, state);
    }

    @Override
    public long getAvailablePower() {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return 0L;
        }
        class_2338 abovePos = this.method_11016().method_10084();
        if (!this.field_11863.method_8311(abovePos)) {
            return 0L;
        }
        int skyLight = this.field_11863.method_8314(class_1944.field_9284, abovePos);
        if (skyLight == 0) {
            return 0L;
        }
        int baseOutput = skyLight * 10;
        double sunlightFactor = this.computeSunlightFactor(this.field_11863);
        double weatherFactor = 1.0;
        if (this.field_11863.method_8546()) {
            weatherFactor = 0.2;
        } else if (this.field_11863.method_8419()) {
            weatherFactor = 0.5;
        }
        return (long)((double)baseOutput * sunlightFactor * weatherFactor);
    }

    private double computeSunlightFactor(class_1937 level) {
        long timeOfDay = level.method_8532() % 24000L;
        double sunlightFactor = timeOfDay <= 1000L ? class_3532.method_33722((double)timeOfDay, (double)0.0, (double)1000.0, (double)0.5, (double)1.0) : (timeOfDay <= 12000L ? 1.0 : (timeOfDay <= 14000L ? (double)class_3532.method_37959((float)(14000L - timeOfDay), (float)0.0f, (float)2000.0f, (float)0.0f, (float)1.0f) : (timeOfDay <= 23000L ? 0.0 : class_3532.method_33722((double)timeOfDay, (double)23000.0, (double)23999.0, (double)0.0, (double)0.5))));
        return sunlightFactor;
    }

    @Override
    public long extractPower(long maxAmount) {
        return maxAmount;
    }
}

