/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.entity.living.human.marine.ai;

import com.human.common.gameplay.entity.living.human.marine.Marine;
import com.human.common.gameplay.item.GunItem;
import com.human.common.gameplay.item.gun.FireModeConfig;
import com.human.common.gameplay.item.gun.pipeline.GunShootContext;
import com.human.common.gameplay.item.gun.pipeline.GunShootResult;
import com.lib.common.gameplay.entity.ai.action.AttackAction;
import com.lib.common.gameplay.entity.ai.util.CombatResponse;
import com.lib.common.gameplay.goap.TypedIdentifier;
import com.lib.common.gameplay.goap.state.GOAPBlackboard;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2183;

public class MarineRangedAttackAction
extends AttackAction<Marine> {
    private static final TypedIdentifier<Integer> COOLDOWN = new TypedIdentifier("cooldown");
    private static final TypedIdentifier<Integer> TICK_PROGRESS = new TypedIdentifier("tickProgress");

    public MarineRangedAttackAction() {
        super(CombatResponse.FightType.RANGED);
    }

    @Override
    protected void performAttack(Marine context, class_1309 target, GOAPBlackboard blackboard) {
        class_1799 itemStack = context.method_6047();
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof GunItem) {
            GunItem gunItem = (GunItem)class_17922;
            MarineRangedAttackAction.shootGun(context, target, blackboard, gunItem, itemStack);
        }
    }

    private static void shootGun(Marine context, class_1309 target, GOAPBlackboard blackboard, GunItem gunItem, class_1799 itemStack) {
        FireModeConfig fireMode = gunItem.getGunConfig().getDefaultFireMode();
        int currentCooldown = blackboard.getOrDefault(COOLDOWN, 0) - 1;
        Integer tickProgress = blackboard.getOrDefault(TICK_PROGRESS, 0);
        blackboard.set(COOLDOWN, currentCooldown);
        context.method_5702(class_2183.class_2184.field_9851, target.method_33571());
        context.method_5988().method_35111((class_1297)target);
        if (currentCooldown <= 0) {
            GunShootContext.create((class_1309)context, itemStack, tickProgress).map(GunShootContext::shoot).filter(result -> result == GunShootResult.SHOT).ifSome($ -> blackboard.set(COOLDOWN, fireMode.cooldownInTicks() * fireMode.consumedAmmunitionPerShot()));
        }
        blackboard.set(TICK_PROGRESS, tickProgress + 1);
    }
}

