/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.entity.machine;

import com.avp.AVP;
import com.avp.common.registry.init.AVPSoundEvents;
import com.avp.common.registry.init.block.AVPBlocks;
import com.avp.common.registry.key.AVPDamageTypeKeys;
import com.avp.common.registry.tag.AVPDamageTypesTags;
import com.human.common.gameplay.block.entity.AmmoChestBlockEntity;
import com.human.common.gameplay.entity.machine.SentryTurretAnimDispatcher;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_8046;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SentryTurret
extends class_1308
implements class_8046 {
    public static float DAMAGE = AVP.config.blockConfigs.TURRET_DAMAGE;
    public static int RANGE = AVP.config.blockConfigs.TURRET_RANGE;
    protected static int AMMO_CHEST_RANGE = AVP.config.blockConfigs.TURRET_AMMO_CHEST_SEARCH_RANGE;
    protected static int FOV = AVP.config.blockConfigs.TURRET_FOV;
    private static final int MAX_TURRET_FIRE_COOLDOWN_IN_TICKS = 2;
    private static final String FIRE_COOLDOWN_KEY = "FireCooldown";
    private static final String OWNER_KEY = "Owner";
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private class_1297 cachedOwner;
    private int fireCooldown = 0;
    protected final SentryTurretAnimDispatcher animDispatcher = new SentryTurretAnimDispatcher((class_1297)this);

    public SentryTurret(class_1299<? extends class_1308> entityType, class_1937 level) {
        super(entityType, level);
    }

    public void setOwner(@Nullable class_1297 owner) {
        if (owner != null) {
            this.ownerUUID = owner.method_5667();
            this.cachedOwner = owner;
        }
    }

    @Nullable
    public class_1297 method_24921() {
        class_1937 class_19372;
        if (this.cachedOwner != null && !this.cachedOwner.method_31481()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.cachedOwner = serverLevel.method_14190(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    public static class_5132.class_5133 createSentryTurretAttributes() {
        return class_1309.method_26827().method_26868(class_5134.field_23716, 16.0).method_26868(class_5134.field_23719, 0.0).method_26868(class_5134.field_23718, 100.0).method_26868(class_5134.field_23717, (double)RANGE);
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            AmmoChestBlockEntity ammoChestBlockEntity;
            if (!this.isPoweredByRedstone()) {
                this.animDispatcher.unpowered();
                return;
            }
            if (this.method_5968() == null) {
                this.animDispatcher.idle();
            }
            if ((ammoChestBlockEntity = SentryTurret.findNearbyAmmoChest(this, this.method_24515())) == null || !ammoChestBlockEntity.hasAmmo()) {
                this.method_5980(null);
                this.animDispatcher.idle();
                return;
            }
            if (this.method_5968() != null && !this.method_5968().method_5805()) {
                this.method_5980(null);
                this.animDispatcher.idle();
                return;
            }
            if (this.fireCooldown > 0) {
                --this.fireCooldown;
                return;
            }
            if (ammoChestBlockEntity.hasAmmo()) {
                this.targetAndFire(ammoChestBlockEntity);
            }
        }
    }

    public void method_5749(class_2487 compound) {
        if (compound.method_25928(OWNER_KEY)) {
            this.ownerUUID = compound.method_25926(OWNER_KEY);
            this.cachedOwner = null;
        }
        this.fireCooldown = compound.method_10550(FIRE_COOLDOWN_KEY);
    }

    public void method_5652(@NotNull class_2487 compound) {
        if (this.ownerUUID != null) {
            compound.method_25927(OWNER_KEY, this.ownerUUID);
        }
        compound.method_10569(FIRE_COOLDOWN_KEY, this.fireCooldown);
    }

    @Nullable
    public class_1799 method_31480() {
        return AVPBlocks.SENTRY_TURRET.get().method_8389().method_7854();
    }

    public boolean method_5862() {
        return false;
    }

    public boolean method_6049(@NotNull class_1293 effectInstance) {
        return false;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_48789(AVPDamageTypesTags.DOES_NOT_HURT_SENTRY_TURRETS)) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    public boolean method_5947() {
        return true;
    }

    @NotNull
    protected class_1269 method_5992(@NotNull class_1657 player, @NotNull class_1268 hand) {
        if (!this.method_37908().field_9236 && this.method_24921() != null && this.method_24921().method_5779((class_1297)player)) {
            this.dropTurretItem();
            this.method_31472();
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public boolean method_30948() {
        return this.method_5805();
    }

    public boolean method_5810() {
        return false;
    }

    public boolean method_5675() {
        return false;
    }

    private void dropTurretItem() {
        class_1799 turretItem = this.method_31480();
        if (turretItem != null) {
            this.method_5699(turretItem, 0.5f);
        }
    }

    private boolean isPoweredByRedstone() {
        return this.method_37908().method_49803(this.method_24515());
    }

    private void targetAndFire(AmmoChestBlockEntity ammoChestBlockEntity) {
        class_1309 target = this.method_5968();
        if (target != null && (!target.method_5805() || target.method_31481())) {
            this.method_5980(null);
            this.fireCooldown = 0;
            this.animDispatcher.idle();
            return;
        }
        if (this.method_5968() == null) {
            this.findTarget();
        }
        if (this.method_5968() != null) {
            this.fireAtTarget(ammoChestBlockEntity);
        }
    }

    private void findTarget() {
        List monsters = this.method_37908().method_8390(class_1588.class, this.method_5829().method_1014((double)RANGE), this::canTargetMonster);
        if (!monsters.isEmpty()) {
            this.method_5980((class_1309)monsters.getFirst());
        }
    }

    private void fireAtTarget(AmmoChestBlockEntity ammoChestBlockEntity) {
        class_1309 target = this.method_5968();
        if (target != null && target.method_5805() && SentryTurret.isFacingTarget(this.method_24515(), this.method_5720(), target) && this.method_5985().method_6369((class_1297)target)) {
            this.animDispatcher.firing();
            this.method_37908().method_8396(null, this.method_24515(), AVPSoundEvents.WEAPON_GENERIC_SHOOT.get(), class_3419.field_15245, 1.0f, 1.0f);
            target.method_5643(this.method_48923().method_48796(AVPDamageTypeKeys.BULLET, (class_1297)this), DAMAGE);
            target.method_6114((class_1297)this);
            ammoChestBlockEntity.consumeAmmo(1);
            this.fireCooldown = 2;
            target.field_6008 = 0;
        } else {
            this.method_5980(null);
        }
    }

    private boolean canTargetMonster(class_1588 monster) {
        return monster.method_5805() && this.method_5739((class_1297)monster) <= (float)RANGE && SentryTurret.isFacingTarget(this.method_24515(), this.method_5720(), (class_1309)monster) && this.method_5985().method_6369((class_1297)monster);
    }

    private static boolean isFacingTarget(class_2338 turretPos, class_243 facingVec, class_1309 target) {
        class_243 turretCenter = class_243.method_24953((class_2382)turretPos);
        class_243 entityPos = class_243.method_24953((class_2382)target.method_24515());
        class_243 directionToEntity = entityPos.method_1020(turretCenter).method_1029();
        double dotProduct = directionToEntity.method_1026(facingVec.method_1029());
        return dotProduct > Math.cos(Math.toRadians(FOV));
    }

    @Nullable
    private static AmmoChestBlockEntity findNearbyAmmoChest(SentryTurret sentryTurret, class_2338 pos) {
        class_1937 level = sentryTurret.method_37908();
        for (class_2338 searchRadius : class_2338.method_10097((class_2338)pos.method_10069(-AMMO_CHEST_RANGE, -AMMO_CHEST_RANGE, -AMMO_CHEST_RANGE), (class_2338)pos.method_10069(AMMO_CHEST_RANGE, AMMO_CHEST_RANGE, AMMO_CHEST_RANGE))) {
            class_2586 ammoEntity = level.method_8321(searchRadius);
            if (!(ammoEntity instanceof AmmoChestBlockEntity)) continue;
            AmmoChestBlockEntity ammoChestBlockEntity = (AmmoChestBlockEntity)ammoEntity;
            return ammoChestBlockEntity;
        }
        return null;
    }
}

