/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.entity.projectile;

import com.avp.common.gameplay.effect.RadiationStatusEffect;
import com.avp.common.gameplay.entity.projectile.BouncingItemProjectile;
import com.avp.common.registry.init.AVPMobEffects;
import com.avp.common.registry.init.item.AVPItems;
import com.human.common.registry.init.entity_type.HumanEntityTypes;
import net.minecraft.class_1293;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3417;
import net.minecraft.class_3857;
import org.jetbrains.annotations.NotNull;

public class ThrownGrenade
extends BouncingItemProjectile {
    private static final String IS_INCENDIARY_KEY = "IsIncendiary";
    private static final String IS_IRRADIATED_KEY = "IsIrradiated";
    private boolean isIncendiary;
    private boolean isIrradiated;

    public ThrownGrenade(class_1299<? extends class_3857> entityType, class_1937 level) {
        super(entityType, level);
        this.shouldBounce = true;
        this.maxLife = 100;
    }

    public ThrownGrenade(class_1937 level, class_1309 livingEntity) {
        super(HumanEntityTypes.GRENADE_THROWN.get(), livingEntity, level);
        this.shouldBounce = true;
        this.maxLife = 100;
    }

    @Override
    public void method_5773() {
        super.method_5773();
        class_1937 level = this.method_37908();
        class_243 pos = this.method_19538();
        double posX = pos.field_1352;
        double posY = pos.field_1351;
        double posZ = pos.field_1350;
        if (this.field_5953) {
            this.method_5783(class_3417.field_15079, 1.0f, 1.0f);
        }
        if (level.field_9236) {
            level.method_8406((class_2394)class_2398.field_11251, posX, posY + 0.5, posZ, 0.0, 0.0, 0.0);
        }
    }

    @NotNull
    protected class_1792 method_16942() {
        if (this.isIrradiated) {
            return AVPItems.GRENADE_IRRADIATED.get();
        }
        if (this.isIncendiary) {
            return AVPItems.GRENADE_INCENDIARY.get();
        }
        return AVPItems.GRENADE.get();
    }

    @Override
    protected void onDeath() {
        class_1937 level = this.method_37908();
        if (level.field_9236) {
            return;
        }
        level.method_8537((class_1297)this, this.method_23317(), this.method_23318(), this.method_23321(), this.isIrradiated ? 9.0f : 3.0f, this.isIncendiary, class_1937.class_7867.field_40889);
        if (this.isIrradiated) {
            this.createIrradiatedCloudEffect(level);
        }
    }

    private void createIrradiatedCloudEffect(class_1937 level) {
        class_2338 blockPos = this.method_24515();
        class_1295 areaEffectCloudEntity = new class_1295(level, (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260());
        areaEffectCloudEntity.method_5603(10.0f);
        areaEffectCloudEntity.method_5604(100);
        areaEffectCloudEntity.method_5596(-areaEffectCloudEntity.method_5599() / (float)areaEffectCloudEntity.method_5605());
        areaEffectCloudEntity.method_5608((class_2394)class_2398.field_22247);
        areaEffectCloudEntity.method_5610(new class_1293(AVPMobEffects.RADIATION.getHolder(), RadiationStatusEffect.EFFECT_DURATION_IN_TICKS, 0));
        level.method_8649((class_1297)areaEffectCloudEntity);
    }

    public void method_5749(@NotNull class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.isIncendiary = compoundTag.method_10577(IS_INCENDIARY_KEY);
        this.isIrradiated = compoundTag.method_10577(IS_IRRADIATED_KEY);
    }

    public void method_5652(@NotNull class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10556(IS_INCENDIARY_KEY, this.isIncendiary);
        compoundTag.method_10556(IS_IRRADIATED_KEY, this.isIncendiary);
    }

    public void setIncendiary(boolean incendiary) {
        this.isIncendiary = incendiary;
    }

    public void setIrradiated(boolean isIrradiated) {
        this.isIrradiated = isIrradiated;
    }
}

