/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.item;

import com.human.common.gameplay.component.GeneReaderContents;
import com.human.common.gameplay.component.GeneReaderMode;
import com.human.common.registry.init.HumanDataComponents;
import com.lib.common.gameplay.entity.manager.GeneContainer;
import com.lib.common.gameplay.gene.Gene;
import com.lib.common.gameplay.gene.GeneBonusDataEntry;
import com.lib.common.gameplay.gene.GeneModifierKey;
import com.lib.common.gameplay.gene.GeneOperationType;
import com.lib.common.gameplay.gene.GeneRegistry;
import com.lib.common.model.GeneCarrier;
import com.lib.common.registry.GeneBonusDataRegistry;
import com.lib.common.util.GeneDataUtil;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5244;
import org.jetbrains.annotations.NotNull;

public class GeneReaderItem
extends class_1792 {
    private static final GeneReaderMode DEFAULT_MODE = GeneReaderMode.BONUS_GENES;

    public GeneReaderItem() {
        super(new class_1792.class_1793().method_7889(1).method_57349(HumanDataComponents.GENE_READER_MODE.get(), (Object)DEFAULT_MODE).method_7895(1024));
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 level, @NotNull class_1657 player, @NotNull class_1268 hand) {
        GeneReaderMode mode;
        class_1799 stack = player.method_5998(hand);
        if (player.method_5715()) {
            if (!level.field_9236) {
                this.cycleGeneReaderMode(stack, player);
            }
            return class_1271.method_29237((Object)stack, (boolean)level.field_9236);
        }
        if (!level.field_9236 && (mode = (GeneReaderMode)((Object)stack.method_57825(HumanDataComponents.GENE_READER_MODE.get(), (Object)DEFAULT_MODE))) == GeneReaderMode.CLEAR) {
            stack.method_57379(HumanDataComponents.GENE_READER_CONTENTS.get(), (Object)GeneReaderContents.EMPTY);
            player.method_7353((class_2561)class_2561.method_43470((String)"Gene data has been cleared."), true);
        }
        return super.method_7836(level, player, hand);
    }

    @NotNull
    public class_1269 method_7884(@NotNull class_1838 context) {
        class_1799 stack;
        GeneReaderMode mode;
        class_1657 player = context.method_8036();
        if (player == null) {
            return super.method_7884(context);
        }
        if (player.method_5715()) {
            if (!context.method_8045().method_8608()) {
                this.cycleGeneReaderMode(context.method_8041(), context.method_8036());
            }
            return class_1269.field_5812;
        }
        if (!context.method_8045().method_8608() && (mode = (GeneReaderMode)((Object)(stack = context.method_8041()).method_57825(HumanDataComponents.GENE_READER_MODE.get(), (Object)DEFAULT_MODE))) == GeneReaderMode.CLEAR) {
            stack.method_57379(HumanDataComponents.GENE_READER_CONTENTS.get(), (Object)GeneReaderContents.EMPTY);
            player.method_7353((class_2561)class_2561.method_43470((String)"Gene data has been cleared."), true);
        }
        return super.method_7884(context);
    }

    private void cycleGeneReaderMode(class_1799 stack, class_1657 player) {
        GeneReaderMode current = (GeneReaderMode)((Object)stack.method_57825(HumanDataComponents.GENE_READER_MODE.get(), (Object)DEFAULT_MODE));
        GeneReaderMode next = this.nextMode(current);
        stack.method_57379(HumanDataComponents.GENE_READER_MODE.get(), (Object)next);
        player.method_7353((class_2561)class_2561.method_43470((String)"Switched mode to ").method_10852((class_2561)class_2561.method_43470((String)next.toString()).method_27692(class_124.field_1054)), true);
    }

    private GeneReaderMode nextMode(GeneReaderMode current) {
        GeneReaderMode[] values = GeneReaderMode.values();
        int nextOrdinal = (current.ordinal() + 1) % values.length;
        return values[nextOrdinal];
    }

    public static void interact(@NotNull class_1799 stack, @NotNull class_1657 player, @NotNull class_1309 interactionTarget, @NotNull class_1268 usedHand) {
        GeneReaderMode geneReaderMode = (GeneReaderMode)((Object)stack.method_57825(HumanDataComponents.GENE_READER_MODE.get(), (Object)DEFAULT_MODE));
        if (geneReaderMode == GeneReaderMode.CLEAR) {
            return;
        }
        Map<GeneModifierKey, Double> geneBonusMapData = GeneBonusDataRegistry.getOrDefault(interactionTarget.method_5864());
        if (geneBonusMapData.isEmpty()) {
            return;
        }
        GeneContainer geneContainer = ((GeneCarrier)interactionTarget).getOrCreateGeneManager().getGeneContainer();
        EnumMap<GeneReaderMode, List<GeneBonusDataEntry>> geneReaderContents = new EnumMap<GeneReaderMode, List<GeneBonusDataEntry>>(GeneReaderMode.class);
        geneReaderContents.put(GeneReaderMode.ACTIVE_GENES, GeneDataUtil.toList(geneContainer.getActiveGeneMap().getBackingMap()));
        geneReaderContents.put(GeneReaderMode.DORMANT_GENES, GeneDataUtil.toList(geneContainer.getDormantGeneMap().getBackingMap()));
        geneReaderContents.put(GeneReaderMode.BONUS_GENES, GeneDataUtil.toList(geneBonusMapData));
        stack.method_57379(HumanDataComponents.GENE_READER_CONTENTS.get(), (Object)new GeneReaderContents(geneReaderContents));
        stack.method_7970(1, (class_1309)player, player.method_32326(stack));
        player.method_6122(usedHand, stack);
        interactionTarget.method_5643(interactionTarget.method_48923().method_48830(), 0.01f);
        player.method_7353((class_2561)class_2561.method_43470((String)"Processed gene data from target."), true);
    }

    public void method_7851(@NotNull class_1799 itemStack, @NotNull class_1792.class_9635 tooltipContext, @NotNull List<class_2561> list, @NotNull class_1836 tooltipFlag) {
        super.method_7851(itemStack, tooltipContext, list, tooltipFlag);
        list.add((class_2561)class_2561.method_43470((String)"Shift + Right Click to change mode.").method_27692(class_124.field_1080));
        list.add(class_5244.field_39003);
        GeneReaderMode geneReaderMode = (GeneReaderMode)((Object)itemStack.method_57825(HumanDataComponents.GENE_READER_MODE.get(), (Object)DEFAULT_MODE));
        list.add((class_2561)class_2561.method_43470((String)"Current Mode: ").method_10852((class_2561)class_2561.method_43470((String)geneReaderMode.toString()).method_27692(class_124.field_1054)));
        GeneReaderContents geneReaderContents = (GeneReaderContents)itemStack.method_57825(HumanDataComponents.GENE_READER_CONTENTS.get(), (Object)GeneReaderContents.EMPTY);
        if (geneReaderContents.equals(GeneReaderContents.EMPTY) || geneReaderMode == GeneReaderMode.CLEAR) {
            return;
        }
        List geneEntries = geneReaderContents.geneBonusDataEntriesByMode().getOrDefault((Object)geneReaderMode, List.of());
        list.add(class_5244.field_39003);
        list.add((class_2561)class_2561.method_43470((String)"Genes:").method_27692(class_124.field_1054));
        if (geneEntries.isEmpty()) {
            list.add((class_2561)class_2561.method_43470((String)"No gene data found.").method_27692(class_124.field_1080));
        } else {
            geneEntries.stream().filter(entry -> GeneRegistry.getValue(entry.id()).isSome()).forEach(entry -> list.add((class_2561)class_2561.method_43471((String)((Gene)GeneRegistry.getValue(entry.id()).unwrap()).getTranslationKey()).method_10852((class_2561)class_2561.method_43470((String)": ")).method_10852((class_2561)class_2561.method_43470((String)this.format(entry.operation(), entry.value())).method_27692(this.getColorForValue(entry.value())))));
        }
    }

    private String format(GeneOperationType operation, double value) {
        String suffix = operation == GeneOperationType.MULTIPLICATIVE ? "%" : "";
        String sign = value > 0.0 ? "+" : "";
        String formattedValue = String.format("%.2f", operation == GeneOperationType.MULTIPLICATIVE ? value * 100.0 : value);
        return sign + formattedValue + suffix;
    }

    private class_124 getColorForValue(double value) {
        if (value > 0.0) {
            return class_124.field_1060;
        }
        if (value < 0.0) {
            return class_124.field_1061;
        }
        return class_124.field_1080;
    }
}

