/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.item;

import com.compat.CommonItemTags;
import com.human.common.gameplay.item.gun.FireModeConfig;
import com.human.common.gameplay.item.gun.GunConfig;
import com.human.common.gameplay.item.gun.pipeline.GunShootContext;
import com.human.common.registry.init.HumanDataComponents;
import com.human.common.registry.init.item.HumanGunItems;
import com.lib.common.gameplay.util.TooltipUtil;
import java.util.List;
import java.util.function.Supplier;
import mod.azure.azurelib.common.animation.dispatch.command.AzCommand;
import mod.azure.azurelib.common.animation.play_behavior.AzPlayBehavior;
import mod.azure.azurelib.common.animation.play_behavior.AzPlayBehaviors;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import net.minecraft.class_5328;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import org.jetbrains.annotations.NotNull;

public class GunItem
extends class_1792 {
    protected static final int START_TICK_PROGRESS = Integer.MAX_VALUE;
    private final GunConfig gunConfig;
    public AzCommand idle;
    public AzCommand shoot;
    public static final AzCommand reload = AzCommand.create((String)"main", (String)"animation.reload", (AzPlayBehavior)AzPlayBehaviors.PLAY_ONCE);

    public GunItem(GunConfig gunConfig) {
        super(new class_1792.class_1793().method_7889(1).method_57349(HumanDataComponents.IS_FIRING.get(), (Object)false).method_7895(gunConfig.durability()).method_57348(GunItem.createAttributes()));
        this.gunConfig = gunConfig;
        this.idle = AzCommand.create((String)"main", (String)"animation.idle", (AzPlayBehavior)AzPlayBehaviors.LOOP);
        this.shoot = AzCommand.create((String)"main", (String)"animation.shoot", (AzPlayBehavior)AzPlayBehaviors.PLAY_ONCE);
    }

    private static class_9285 createAttributes() {
        return class_9285.method_57480().method_57487(class_5134.field_23723, new class_1322(field_8001, (double)-0.1f, class_1322.class_1323.field_6328), class_9274.field_49217).method_57486();
    }

    protected void playReleaseUsingAnimations(class_1297 shooter, class_1799 itemStack) {
        this.idle.sendForItem(shooter, itemStack);
    }

    protected void playUseAnimations(class_1297 shooter, class_1799 itemStack) {
        this.shoot.sendForItem(shooter, itemStack);
    }

    public boolean method_7878(@NotNull class_1799 toRepair, class_1799 repairIngredient) {
        return repairIngredient.method_31573(CommonItemTags.INGOTS_STEEL);
    }

    public int method_7837() {
        return 1;
    }

    public void method_7840(@NotNull class_1799 itemStack, @NotNull class_1937 level, @NotNull class_1309 livingEntity, int i) {
        FireModeConfig fireModeConfig = this.gunConfig.getDefaultFireMode();
        Supplier<class_3414> shootFinishSoundEvent = fireModeConfig.shootFinishSoundEvent();
        if (shootFinishSoundEvent != null) {
            level.method_45447(null, livingEntity.method_24515(), shootFinishSoundEvent.get(), class_3419.field_15248);
        }
        this.playReleaseUsingAnimations((class_1297)livingEntity, itemStack);
        super.method_7840(itemStack, level, livingEntity, i);
    }

    public void method_7852(@NotNull class_1937 level, @NotNull class_1309 livingEntity, @NotNull class_1799 itemStack, int tickCountdown) {
        if (!(livingEntity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)livingEntity;
        int tickProgress = Math.abs(Integer.MAX_VALUE - tickCountdown);
        GunShootContext.create((class_1309)player, itemStack, tickProgress).map(GunShootContext::shoot).ifSome(result -> {
            switch (result) {
                case COOLDOWN: 
                case DELAYED: 
                case FAILURE: 
                case RELOADING: {
                    break;
                }
                case SHOT: {
                    itemStack.method_57379(HumanDataComponents.IS_FIRING.get(), (Object)true);
                    this.playUseAnimations((class_1297)livingEntity, itemStack);
                }
            }
        });
    }

    public int method_7881(@NotNull class_1799 itemStack, @NotNull class_1309 livingEntity) {
        return Integer.MAX_VALUE;
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 level, @NotNull class_1657 player, @NotNull class_1268 interactionHand) {
        return class_5328.method_29282((class_1937)level, (class_1657)player, (class_1268)interactionHand);
    }

    public void method_7888(@NotNull class_1799 itemStack, @NotNull class_1937 level, @NotNull class_1297 entity, int i, boolean bl) {
        class_1309 livingEntity;
        Boolean isFiring = (Boolean)itemStack.method_57824(HumanDataComponents.IS_FIRING.get());
        if (Boolean.TRUE.equals(isFiring) && entity instanceof class_1309 && !(livingEntity = (class_1309)entity).method_6115()) {
            itemStack.method_57379(HumanDataComponents.IS_FIRING.get(), (Object)false);
            this.playReleaseUsingAnimations((class_1297)livingEntity, itemStack);
        }
        super.method_7888(itemStack, level, entity, i, bl);
    }

    public GunConfig getGunConfig() {
        return this.gunConfig;
    }

    public void method_7851(@NotNull class_1799 itemStack, @NotNull class_1792.class_9635 tooltipContext, @NotNull List<class_2561> list, @NotNull class_1836 tooltipFlag) {
        super.method_7851(itemStack, tooltipContext, list, tooltipFlag);
        int currentAmmunition = (Integer)itemStack.method_57825(HumanDataComponents.AMMUNITION.get(), (Object)0);
        FireModeConfig fireMode = this.gunConfig.getDefaultFireMode();
        Supplier<class_1935> itemSupplier = this.gunConfig.ammunitionItemSupplier();
        if (itemSupplier != null) {
            class_1935 item = itemSupplier.get();
            TooltipUtil.appendLabel(list, "tooltip.avp.ammunition_type", class_2561.method_43471((String)item.method_8389().method_7876()));
        }
        if (this != HumanGunItems.OLD_PAINLESS.get()) {
            TooltipUtil.appendLabel(list, "tooltip.avp.ammunition", class_2561.method_43470((String)(currentAmmunition + " / " + this.gunConfig.maximumAmmunition())));
        }
        TooltipUtil.appendLabel(list, "tooltip.avp.damage", class_2561.method_43470((String)class_9285.field_49329.format(fireMode.damage())));
        TooltipUtil.appendLabel(list, "tooltip.avp.knockback", class_2561.method_43470((String)class_9285.field_49329.format(fireMode.knockback())));
        TooltipUtil.appendLabel(list, "tooltip.avp.fire_rate", class_2561.method_43470((String)(class_9285.field_49329.format((double)fireMode.cooldownInTicks() / 20.0) + " / Sec")));
    }
}

