/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.item.gun.pipeline.step.impl;

import com.human.common.gameplay.item.GunItem;
import com.human.common.gameplay.item.gun.GunConfig;
import com.human.common.gameplay.item.gun.GunReloading;
import com.human.common.gameplay.item.gun.pipeline.GunShootContext;
import com.human.common.gameplay.item.gun.pipeline.GunShootResult;
import com.human.common.gameplay.item.gun.pipeline.step.GunShootStep;
import com.human.common.registry.init.item.HumanGunItems;
import java.util.function.Supplier;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1935;
import net.minecraft.class_1937;

public class CheckReloadingStep
implements GunShootStep {
    public static final CheckReloadingStep INSTANCE = new CheckReloadingStep();

    private CheckReloadingStep() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public GunShootResult apply(GunShootContext context) {
        int currentAmmunition = context.currentAmmunition();
        GunConfig gunConfig = context.gunConfig();
        GunItem gunItem = context.gunItem();
        boolean hasInfinity = context.hasInfinity();
        boolean isShooterImmortal = context.isShooterImmortal();
        class_1309 shooter = context.shooter();
        class_1937 level = shooter.method_37908();
        Supplier<class_1935> supplier = gunConfig.ammunitionItemSupplier();
        if (!(shooter instanceof class_1657)) return GunShootResult.CONTINUE;
        class_1657 player = (class_1657)shooter;
        if (isShooterImmortal || hasInfinity) {
            return GunShootResult.CONTINUE;
        }
        if (gunItem == HumanGunItems.OLD_PAINLESS.get() && supplier != null) {
            int amountToConsume;
            class_1935 ammunitionItem = supplier.get();
            GunReloading.ItemConsumptionResult itemConsumptionResult = GunReloading.consumeItemAmountFromInventory(player, ammunitionItem, amountToConsume = gunConfig.getDefaultFireMode().consumedAmmunitionPerShot(), false);
            if (itemConsumptionResult != GunReloading.ItemConsumptionResult.Full.INSTANCE) return GunShootResult.FAILURE;
            if (level.field_9236) return GunShootResult.CONTINUE;
            GunReloading.consumeItemAmountFromInventory(player, ammunitionItem, amountToConsume, true);
            return GunShootResult.CONTINUE;
        } else {
            if (currentAmmunition > 0) return GunShootResult.CONTINUE;
            if (level.field_9236) return GunShootResult.RELOADING;
            GunReloading.reload(player);
            return GunShootResult.RELOADING;
        }
    }
}

