/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.gameplay.entity.ai.action;

import com.just.core.functional.option.None;
import com.just.core.functional.option.Option;
import com.lib.common.gameplay.entity.ai.GOAPConstants;
import com.lib.common.gameplay.entity.ai.util.CombatResponse;
import com.lib.common.gameplay.entity.ai.util.ItemType;
import com.lib.common.gameplay.goap.GOAPAction;
import com.lib.common.gameplay.goap.condition.expression.GOAPExpression;
import com.lib.common.gameplay.goap.effect.GOAPEffect;
import com.lib.common.gameplay.goap.state.GOAPBlackboard;
import com.lib.common.gameplay.goap.state.GOAPWorldState;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;

public class AttackAction<T extends class_1308>
extends GOAPAction<T> {
    public AttackAction(CombatResponse.FightType fightType) {
        this.addPrecondition(GOAPConstants.COMBAT_RESPONSE, GOAPExpression.equalTo(new CombatResponse.Fight(fightType)));
        this.addPrecondition(GOAPConstants.MAIN_HAND_ITEM_TYPE, GOAPExpression.equalTo(fightType == CombatResponse.FightType.MELEE ? ItemType.meleeWeapon() : ItemType.rangedWeapon()));
        this.addPrecondition(GOAPConstants.NEAREST_ATTACK_TARGET_ENTITY, GOAPExpression.isSome());
        this.addPrecondition(GOAPConstants.IS_ATTACK_TARGET_ENTITY_IN_RANGE, GOAPExpression.equalTo(true));
        this.addEffect(new GOAPEffect.Value<None>(GOAPConstants.NEAREST_ATTACK_TARGET_ENTITY, Option.none()));
    }

    @Override
    public boolean perform(T context, GOAPWorldState worldState, GOAPBlackboard blackboard) {
        Option targetOption = (Option)worldState.getOrDefault(GOAPConstants.NEAREST_ATTACK_TARGET_ENTITY, Option.none());
        if (targetOption.isNone()) {
            return true;
        }
        class_1309 target = (class_1309)targetOption.unwrap();
        if (target.method_29504()) {
            return true;
        }
        this.performAttack(context, target, blackboard);
        return false;
    }

    protected void performAttack(T context, class_1309 target, GOAPBlackboard blackboard) {
        context.method_6121((class_1297)target);
    }
}

