/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.gameplay.entity.ai.action;

import com.avp.common.model.inventory.AVPInventoryBearer;
import com.lib.common.gameplay.entity.ai.GOAPConstants;
import com.lib.common.gameplay.entity.ai.util.CombatResponse;
import com.lib.common.gameplay.entity.ai.util.ItemType;
import com.lib.common.gameplay.goap.GOAPAction;
import com.lib.common.gameplay.goap.TypedIdentifier;
import com.lib.common.gameplay.goap.condition.expression.GOAPExpression;
import com.lib.common.gameplay.goap.effect.GOAPEffect;
import com.lib.common.gameplay.goap.state.GOAPBlackboard;
import com.lib.common.gameplay.goap.state.GOAPWorldState;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_3417;

public class EatFoodToHealAction<T extends class_1309>
extends GOAPAction<T> {
    private static final TypedIdentifier<Integer> EATING_TICK_DURATION = new TypedIdentifier("eatingTickDuration");
    private final float healAmount;

    public EatFoodToHealAction(float healAmount) {
        this.healAmount = healAmount;
        this.addPrecondition(GOAPConstants.COMBAT_RESPONSE, GOAPExpression.equalTo(CombatResponse.rest()));
        this.addPrecondition(GOAPConstants.IS_HEALTHY, GOAPExpression.isFalse());
        this.addPrecondition(GOAPConstants.OFF_HAND_ITEM_TYPE, GOAPExpression.equalTo(ItemType.food()));
        this.addEffect(new GOAPEffect.Value<Boolean>(GOAPConstants.IS_HEALTHY, true));
    }

    @Override
    public boolean perform(T context, GOAPWorldState worldState, GOAPBlackboard blackboard) {
        Integer eatingTickDuration = blackboard.getOrDefault(EATING_TICK_DURATION, 0);
        blackboard.set(EATING_TICK_DURATION, eatingTickDuration + 1);
        if (eatingTickDuration % 4 == 0) {
            context.method_43077(class_3417.field_20614);
        }
        if (eatingTickDuration > 32) {
            ((AVPInventoryBearer)context).getInventory().removeItemType(context.method_6079().method_7909(), 1);
            context.method_6122(class_1268.field_5810, class_1799.field_8037);
            context.method_6033(context.method_6032() + this.healAmount);
            return true;
        }
        return false;
    }

    @Override
    public float getCost(T context, GOAPWorldState worldState) {
        return context.method_6032() / context.method_6063();
    }
}

