/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.gameplay.entity.ai.action;

import com.avp.common.model.inventory.AVPInventoryBearer;
import com.lib.common.gameplay.entity.ai.GOAPConstants;
import com.lib.common.gameplay.entity.ai.util.ItemType;
import com.lib.common.gameplay.goap.GOAPAction;
import com.lib.common.gameplay.goap.TypedIdentifier;
import com.lib.common.gameplay.goap.condition.expression.GOAPExpression;
import com.lib.common.gameplay.goap.effect.GOAPEffect;
import com.lib.common.gameplay.goap.state.GOAPBlackboard;
import com.lib.common.gameplay.goap.state.GOAPWorldState;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1935;

public class EquipItemAction<T extends class_1309>
extends GOAPAction<T> {
    private final class_1268 interactionHand;
    private final ItemType itemType;

    public EquipItemAction(class_1268 interactionHand, ItemType itemType) {
        this.interactionHand = interactionHand;
        this.itemType = itemType;
        TypedIdentifier<ItemType> typedIdentifier = interactionHand == class_1268.field_5808 ? GOAPConstants.MAIN_HAND_ITEM_TYPE : GOAPConstants.OFF_HAND_ITEM_TYPE;
        this.addPrecondition(GOAPConstants.ITEM_TYPES_IN_INVENTORY, GOAPExpression.contains(itemType));
        this.addPrecondition(typedIdentifier, GOAPExpression.where(handItemType -> handItemType != itemType, typedIdentifier.identifier() + " is not " + String.valueOf(itemType)));
        this.addEffect(new GOAPEffect.Value<ItemType>(typedIdentifier, itemType));
    }

    @Override
    public boolean perform(T context, GOAPWorldState worldState, GOAPBlackboard blackboard) {
        Optional<class_1799> itemStackOption = ((AVPInventoryBearer)context).getInventory().stream().filter(item -> ItemType.getForItem(item) == this.itemType).findFirst();
        itemStackOption.ifPresent(itemStack -> context.method_6122(this.interactionHand, new class_1799((class_1935)itemStack.method_7909(), 1)));
        return ItemType.getForItem(context.method_5998(this.interactionHand)) == this.itemType;
    }
}

