/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.util;

import com.lib.common.gameplay.entity.manager.GeneContainer;
import com.lib.common.gameplay.gene.Genes;
import com.lib.common.model.GeneCarrier;
import com.lib.common.registry.GeneBonusDataRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import org.jetbrains.annotations.Nullable;

public class EmbryoUtil {
    public static List<class_1297> birthEmbryos(class_1309 parentEntity, GeneContainer parentGeneContainer, Function<class_1309, @Nullable class_1297> embryoFactory, int baseBirthCount) {
        class_1297 embryo;
        ArrayList<class_1297> embryoList = new ArrayList<class_1297>();
        double birthBonus = (double)baseBirthCount + parentGeneContainer.getActiveGeneMap().getValue(Genes.BONUS_EMBRYO_COUNT);
        int baseOffspring = (int)birthBonus;
        double fractionalChance = birthBonus - (double)baseOffspring;
        for (int i = 0; i < baseOffspring; ++i) {
            class_1297 embryo2 = embryoFactory.apply(parentEntity);
            if (embryo2 == null) continue;
            embryoList.add(embryo2);
        }
        if (parentEntity.method_59922().method_43058() < fractionalChance && (embryo = embryoFactory.apply(parentEntity)) != null) {
            embryoList.add(embryo);
        }
        return embryoList;
    }

    public static void applyGenesToEmbryo(class_1299<?> parentType, GeneContainer parentGeneContainer, GeneCarrier offspring, boolean addBonusGenes) {
        GeneContainer offspringGeneContainer = offspring.getOrCreateGeneManager().getGeneContainer();
        parentGeneContainer.transfer(offspringGeneContainer, true);
        if (addBonusGenes) {
            GeneBonusDataRegistry.getOrDefault(parentType).forEach(offspringGeneContainer.getActiveGeneMap()::add);
        }
    }
}

