/*
 * Decompiled with CFR 0.152.
 */
package tfcthermaldeposits;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistryRock;
import net.dries007.tfc.world.biome.TFCBiomes;
import net.dries007.tfc.world.biome.VolcanoNoise;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.resource.PathPackResources;
import org.jetbrains.annotations.NotNull;
import tfcthermaldeposits.TFCThermalDeposits;
import tfcthermaldeposits.client.TDSounds;
import tfcthermaldeposits.config.TDConfig;
import tfcthermaldeposits.util.TDHelpers;

public class TDForgeEventHandler {
    public static WorldGenLevel worldLevel;

    public static void init() {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        IEventBus loader = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(TDForgeEventHandler::playerLivingTick);
        bus.addListener(TDForgeEventHandler::onFluidPlaceBlock);
        bus.addListener(TDForgeEventHandler::onWorldTick);
        bus.addListener(TDForgeEventHandler::onPlayerTick);
    }

    public static void onPackFinder(AddPackFindersEvent event) {
        block8: {
            try {
                if (event.getPackType() != PackType.CLIENT_RESOURCES) break block8;
                IModFile modFile = ModList.get().getModFileById("tfcthermaldeposits").getFile();
                Path resourcePath = modFile.getFilePath();
                try (PathPackResources pack = new PathPackResources(modFile.getFileName() + ":overload", true, resourcePath){
                    private final IModFile file = ModList.get().getModFileById("tfcthermaldeposits").getFile();

                    @NotNull
                    protected Path resolve(String ... paths) {
                        return this.file.findResource(paths);
                    }
                };){
                    PackMetadataSection metadata = (PackMetadataSection)pack.m_5550_((MetadataSectionSerializer)PackMetadataSection.f_243696_);
                    if (metadata != null) {
                        TFCThermalDeposits.LOGGER.info("Injecting TFC Thermal Deposits override pack");
                        event.addRepositorySource(consumer -> consumer.accept(Pack.m_245429_((String)"tfcthermaldeposits_data", (Component)Component.m_237113_((String)"TFC Thermal Deposits Resources"), (boolean)true, id -> pack, (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_)));
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void playerLivingTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Player player = event.player;
            if (player.getPersistentData().m_128451_("shakeTime") > 0) {
                player.getPersistentData().m_128405_("shakeTime", player.getPersistentData().m_128451_("shakeTime") - 1);
            }
            if (player.getPersistentData().m_128451_("shakeCooldown") > 0) {
                player.getPersistentData().m_128405_("shakeCooldown", player.getPersistentData().m_128451_("shakeCooldown") - 1);
            }
        }
    }

    public static void onFluidPlaceBlock(BlockEvent.FluidPlaceBlockEvent event) {
        BlockState state = event.getNewState();
        RegistryRock rock = TDHelpers.rockTypeIgneous(event.getLevel(), event.getPos());
        if (Helpers.isBlock((BlockState)state, (Block)Blocks.f_50069_)) {
            event.setNewState(((Block)rock.getBlock(Rock.BlockType.HARDENED).get()).m_49966_());
        } else if (Helpers.isBlock((BlockState)state, (Block)Blocks.f_50652_)) {
            event.setNewState(((Block)rock.getBlock(Rock.BlockType.COBBLE).get()).m_49966_());
        } else if (Helpers.isBlock((BlockState)state, (Block)Blocks.f_50137_)) {
            event.setNewState(((Block)((RegistryObject)((Map)TFCBlocks.ROCK_BLOCKS.get(Rock.BASALT)).get(Rock.BlockType.HARDENED)).get()).m_49966_());
        }
    }

    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        Level level = event.level;
        if (level instanceof WorldGenLevel) {
            WorldGenLevel level2;
            worldLevel = level2 = (WorldGenLevel)level;
        }
    }

    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        Level level = player.m_9236_();
        if (player == null || level == null || worldLevel == null) {
            return;
        }
        if (player.getPersistentData().m_128457_("shakeCooldown") <= 0.0f) {
            double shouldShake;
            BlockPos pos = player.m_20183_();
            RandomSource random = TDHelpers.seededRandom(pos);
            double rockTypeFactor = TDHelpers.getIntensityFactor((LevelAccessor)level, pos);
            double timeNoise = TDHelpers.volcanicRumbleNoise(level, level.m_46472_() == Level.f_46429_ ? true : (Boolean)TDConfig.COMMON.highTremorFrequency.get());
            double d = shouldShake = (Boolean)TDConfig.COMMON.toggleVolcanoShake.get() != false ? 0.0 : (Double)Minecraft.m_91087_().f_91066_.m_231924_().m_231551_();
            if (level.m_46472_() == Level.f_46428_) {
                double volcanoNoise;
                Biome biome;
                if (timeNoise >= 90.0 + (double)random.m_188503_(8) * rockTypeFactor && random.m_188503_((int)Math.round(rockTypeFactor + 1.0)) == 0 && (biome = (Biome)level.m_204166_(pos).m_203334_()) != null && TFCBiomes.hasExtension((CommonLevelAccessor)level, (Biome)biome) && (volcanoNoise = (double)new VolcanoNoise(worldLevel.m_7328_()).calculateEasing(pos.m_123341_(), pos.m_123343_(), TFCBiomes.getExtension((CommonLevelAccessor)worldLevel, (Biome)biome).getVolcanoRarity())) > 0.0) {
                    long shakeTime = Math.round(Mth.m_14008_((double)(volcanoNoise * 2.5), (double)0.0, (double)1.5) * 400.0);
                    float shakeFactor = (float)(Mth.m_14008_((double)(volcanoNoise * 1.5), (double)0.0, (double)1.15f) * (timeNoise * (double)0.0066f));
                    player.getPersistentData().m_128405_("shakeTime", (int)((double)shakeTime * shouldShake));
                    player.getPersistentData().m_128350_("shakeFactor", (float)((double)shakeFactor * shouldShake));
                    float soundAmplifier = ((Double)TDConfig.COMMON.earthquakeSoundAmplifier.get()).floatValue();
                    if (player.m_5842_()) {
                        player.m_5496_((SoundEvent)TDSounds.TREMOR_UNDERWATER.get(), (soundAmplifier + random.m_188501_() * 2.0f) * shakeFactor, 1.0f + random.m_188501_() * 0.5f);
                        player.getPersistentData().m_128350_("shakeCooldown", 400.0f);
                    } else if (player.m_20183_().m_123342_() < level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos).m_123342_() - 10) {
                        player.m_5496_((SoundEvent)TDSounds.TREMOR.get(), (soundAmplifier + random.m_188501_() * 2.0f) * shakeFactor, 1.0f + random.m_188501_() * 0.5f);
                        player.getPersistentData().m_128350_("shakeCooldown", 280.0f);
                    } else {
                        player.m_5496_((SoundEvent)TDSounds.EARTHQUAKE.get(), (soundAmplifier + random.m_188501_() * 2.0f) * shakeFactor, 1.0f + random.m_188501_() * 0.5f);
                        player.getPersistentData().m_128350_("shakeCooldown", 480.0f);
                    }
                }
            } else if (level.m_46472_() == Level.f_46429_ && ((Boolean)TDConfig.COMMON.toggleNetherTremor.get()).booleanValue() && timeNoise >= 125.0 + (double)random.m_188503_(32)) {
                long shakeTime = Math.round(Math.pow(timeNoise * (double)0.01f, 1.3f) * 200.0);
                float shakeFactor = (float)Math.pow(timeNoise * (double)0.005f, 1.05f);
                player.getPersistentData().m_128405_("shakeTime", (int)((double)shakeTime * shouldShake));
                player.getPersistentData().m_128350_("shakeFactor", (float)((double)shakeFactor * shouldShake));
                boolean bool = random.m_188499_();
                SoundEvent sound = bool ? (SoundEvent)TDSounds.EARTHQUAKE.get() : (SoundEvent)TDSounds.TREMOR.get();
                int cooldown = bool ? 480 : 280;
                player.m_5496_(sound, (5.0f + random.m_188501_() * 2.0f) * shakeFactor, 1.0f + random.m_188501_() * 0.5f);
                player.getPersistentData().m_128350_("shakeCooldown", (float)cooldown);
            }
            if (((Boolean)TDConfig.COMMON.toggleDebug.get()).booleanValue()) {
                TFCThermalDeposits.LOGGER.info("Time noise is " + timeNoise);
            }
        }
    }
}

