/*
 * Decompiled with CFR 0.152.
 */
package tfcthermaldeposits.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import tfcthermaldeposits.client.particle.PyroclasticBombParticle;
import tfcthermaldeposits.client.particle.PyroclasticBombSeedParticle;
import tfcthermaldeposits.client.particle.TDParticles;
import tfcthermaldeposits.client.render.blockentity.MineralSheetBlockEntityRenderer;
import tfcthermaldeposits.client.render.entity.PyroclasticBombRenderer;
import tfcthermaldeposits.common.TDCreativeTabs;
import tfcthermaldeposits.common.blockentities.TDBlockEntities;
import tfcthermaldeposits.common.entities.TDEntities;
import tfcthermaldeposits.config.TDConfig;

public class ClientEventHandler {
    public static void init() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        bus.addListener(ClientEventHandler::clientSetup);
        bus.addListener(ClientEventHandler::registerEntityRenderers);
        bus.addListener(ClientEventHandler::registerParticleFactories);
        bus.addListener(TDCreativeTabs::onBuildCreativeTab);
        eventBus.addListener(ClientEventHandler::setupCameraAngles);
    }

    public static void setupCameraAngles(ViewportEvent.ComputeCameraAngles event) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        Level level = player.m_9236_();
        if (((Boolean)TDConfig.COMMON.toggleVolcanoShake.get()).booleanValue() && level.m_5776_() && player != null && player.getPersistentData().m_128451_("shakeTime") >= 1) {
            float shakeAmount = 1.0f * player.getPersistentData().m_128457_("shakeFactor");
            float pitchAmount = shakeAmount * 0.33f;
            event.setYaw(event.getYaw() + shakeAmount * (float)Math.cos((Math.random() * 5.0 + 1.0) * 3.0 * (double)player.getPersistentData().m_128451_("shakeTime") / 20.0));
            event.setPitch(event.getPitch() + pitchAmount * (float)Math.cos((Math.random() * 3.0 + 1.0) * 3.0 * (double)player.getPersistentData().m_128451_("shakeTime") / 20.0));
            event.setRoll(event.getRoll() + shakeAmount * (float)Math.cos((Math.random() * 4.0 + 1.0) * 3.0 * (double)player.getPersistentData().m_128451_("shakeTime") / 20.0));
        }
    }

    public static void clientSetup(FMLClientSetupEvent event) {
        RenderType cutout = RenderType.m_110463_();
    }

    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)TDEntities.PYROCLASTIC_BOMB.get(), PyroclasticBombRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TDBlockEntities.MINERAL_SHEET.get(), ctx -> new MineralSheetBlockEntityRenderer());
    }

    public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)TDParticles.PYROCLASTIC_BOMB.get(), PyroclasticBombParticle.Provider::new);
        event.registerSpecial((ParticleType)TDParticles.PYROCLASTIC_BOMB_EMITTER.get(), (ParticleProvider)new PyroclasticBombSeedParticle.Provider());
    }
}

