/*
 * Decompiled with CFR 0.152.
 */
package tfcthermaldeposits.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.model.SimpleStaticBlockEntityModel;
import net.dries007.tfc.common.blocks.DirectionPropertyBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import tfcthermaldeposits.common.blockentities.MineralSheetBlockEntity;
import tfcthermaldeposits.common.blockentities.TDBlockEntities;
import tfcthermaldeposits.common.blocks.rock.Mineral;
import tfcthermaldeposits.common.blocks.rock.MineralSheetBlock;
import tfcthermaldeposits.util.TDHelpers;

public enum MineralSheetBlockModel implements SimpleStaticBlockEntityModel<MineralSheetBlockModel, MineralSheetBlockEntity>
{
    INSTANCE;


    public TextureAtlasSprite render(MineralSheetBlockEntity pile, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay) {
        BlockState state = pile.m_58900_();
        TextureAtlasSprite sprite = null;
        Function textureAtlas = Minecraft.m_91087_().m_91258_(RenderHelpers.BLOCKS_ATLAS);
        for (Direction direction : Helpers.DIRECTIONS) {
            if (!((Boolean)state.m_61143_((Property)DirectionPropertyBlock.getProperty((Direction)direction))).booleanValue()) continue;
            RandomSource random = this.random(pile.m_58899_().m_123341_(), pile.m_58899_().m_123342_(), pile.m_58899_().m_123343_(), direction.ordinal());
            Mineral mineral = pile.getOrCacheMineral(direction);
            String mineralName = pile.mineralNameRandom(mineral, random);
            sprite = (TextureAtlasSprite)textureAtlas.apply(TDHelpers.identifier(mineralName));
            this.renderSheet(poseStack, sprite, buffer, direction, packedLight, packedOverlay);
        }
        if (sprite == null) {
            sprite = RenderHelpers.missingTexture();
        }
        return sprite;
    }

    public BlockEntityType<MineralSheetBlockEntity> type() {
        return (BlockEntityType)TDBlockEntities.MINERAL_SHEET.get();
    }

    public int faces(MineralSheetBlockEntity blockEntity) {
        return 36;
    }

    public void renderSheet(PoseStack poseStack, TextureAtlasSprite sprite, VertexConsumer buffer, Direction direction, int packedLight, int packedOverlay) {
        RenderHelpers.renderTexturedCuboid((PoseStack)poseStack, (VertexConsumer)buffer, (TextureAtlasSprite)sprite, (int)packedLight, (int)packedOverlay, (AABB)MineralSheetBlock.getShapeForSingleFace(direction).m_83215_());
    }

    public RandomSource random(int posX, int posY, int posZ, int direction) {
        long seed = (posX + direction) * (posY + direction) * (posZ + direction);
        return RandomSource.m_216335_((long)seed).m_188582_().m_213715_(posX + direction, posY + direction, posZ + direction);
    }
}

