/*
 * Decompiled with CFR 0.152.
 */
package tfcthermaldeposits.common.blockentities;

import java.util.Arrays;
import java.util.Locale;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import tfcthermaldeposits.common.blockentities.TDBlockEntities;
import tfcthermaldeposits.common.blocks.rock.Mineral;
import tfcthermaldeposits.common.blocks.rock.MineralSheetBlock;

public class MineralSheetBlockEntity
extends TFCBlockEntity {
    public final ItemStack[] stacks = new ItemStack[6];
    public final Mineral[] cachedMinerals = new Mineral[6];
    public static final DirectionProperty FACING = MineralSheetBlock.FACING;
    public static final BooleanProperty MIRROR = MineralSheetBlock.MIRROR;

    public int faceToIndex(Direction face) {
        BlockState state = this.m_58900_();
        if (face.m_122434_() == Direction.Axis.Y) {
            return face.ordinal();
        }
        Mirror mirror = (Boolean)state.m_61143_((Property)MIRROR) != false ? Mirror.FRONT_BACK : Mirror.NONE;
        Rotation rot = switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.SOUTH -> Rotation.CLOCKWISE_180;
            case Direction.EAST -> Rotation.COUNTERCLOCKWISE_90;
            case Direction.WEST -> Rotation.CLOCKWISE_90;
            default -> Rotation.NONE;
        };
        return mirror.m_54848_(rot.m_55954_(face)).ordinal();
    }

    public MineralSheetBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TDBlockEntities.MINERAL_SHEET.get(), pos, state);
        Arrays.fill(this.stacks, ItemStack.f_41583_);
    }

    public BlockEntityType<?> m_58903_() {
        return (BlockEntityType)TDBlockEntities.MINERAL_SHEET.get();
    }

    public void addSheet(Direction direction, ItemStack stack) {
        int index = this.faceToIndex(direction);
        this.stacks[index] = stack;
        this.cachedMinerals[index] = null;
        this.markForSync();
    }

    public ItemStack removeSheet(Direction direction) {
        int index = this.faceToIndex(direction);
        ItemStack stack = this.stacks[index];
        this.stacks[index] = ItemStack.f_41583_;
        this.cachedMinerals[index] = null;
        this.markForSync();
        return stack;
    }

    public ItemStack getSheet(Direction direction) {
        return this.stacks[this.faceToIndex(direction)].m_41777_();
    }

    public Mineral getOrCacheMineral(Direction direction) {
        int index = this.faceToIndex(direction);
        ItemStack stack = this.stacks[index];
        Mineral mineral = this.cachedMinerals[index];
        if (mineral == null) {
            mineral = Mineral.getMineral(stack);
            if (mineral == null) {
                mineral = Mineral.BRIMSTONE;
            }
            this.cachedMinerals[index] = mineral;
        }
        return mineral;
    }

    public void setAllMineralsFromOutsideWorld(Mineral mineral) {
        Arrays.fill((Object[])this.cachedMinerals, (Object)mineral);
    }

    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("stacks", (Tag)Helpers.writeItemStacksToNbt((ItemStack[])this.stacks));
        super.m_183515_(tag);
    }

    public void loadAdditional(CompoundTag tag) {
        Helpers.readItemStacksFromNbt((ItemStack[])this.stacks, (ListTag)tag.m_128437_("stacks", 10));
        Arrays.fill((Object[])this.cachedMinerals, null);
        super.loadAdditional(tag);
    }

    public String mineralNameRandom(Mineral mineral, RandomSource random) {
        String suffix = String.valueOf(random.m_188503_(4));
        return "block/mineral/" + mineral.name().toLowerCase(Locale.ROOT) + "_" + suffix;
    }

    public String mineralName(Mineral mineral) {
        return "block/mineral/" + mineral.name().toLowerCase(Locale.ROOT) + "_0";
    }
}

