/*
 * Decompiled with CFR 0.152.
 */
package tfcthermaldeposits.common.blocks;

import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.dries007.tfc.util.registry.RegistrationHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;
import tfcthermaldeposits.common.blockentities.TDBlockEntities;
import tfcthermaldeposits.common.blocks.rock.MineralSheetBlock;
import tfcthermaldeposits.common.items.TDItems;

public final class TDBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)Registries.f_256747_, (String)"tfcthermaldeposits");
    public static final RegistryObject<Block> MINERAL_SHEET = TDBlocks.register("mineral/mineral_sheet", () -> new MineralSheetBlock(ExtendedProperties.of().mapColor(MapColor.f_283942_).instrument(NoteBlockInstrument.BANJO).strength(0.5f, 4.0f).sound(SoundType.f_154662_).noCollission().noOcclusion().blockEntity(TDBlockEntities.MINERAL_SHEET)));
    public static final RegistryObject<Block> PYROCLASTIC_BOMB = TDBlocks.register("pyroclastic_bomb", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283820_).m_60978_(3.0f).m_60918_((SoundType)TFCSounds.CHARCOAL).m_280658_(NoteBlockInstrument.BANJO)));

    public static boolean always(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public static boolean never(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public static boolean never(BlockState state, BlockGetter world, BlockPos pos, EntityType<?> type) {
        return false;
    }

    public static ToIntFunction<BlockState> lavaLoggedBlockEmission() {
        return state -> ((FluidProperty.FluidKey)state.m_61143_((Property)TFCBlockStateProperties.WATER_AND_LAVA)).is(((IFluidLoggable)state.m_60734_()).getFluidProperty().keyFor((Fluid)Fluids.f_76195_)) ? 15 : 0;
    }

    public static ToIntFunction<BlockState> litBlockEmission(int lightValue) {
        return state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? lightValue : 0;
    }

    private static <T extends Block> RegistryObject<T> registerNoItem(String name, Supplier<T> blockSupplier) {
        return TDBlocks.register(name, blockSupplier, (Function)null);
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> blockSupplier) {
        return TDBlocks.register(name, blockSupplier, (T block) -> new BlockItem(block, new Item.Properties()));
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> blockSupplier, Item.Properties blockItemProperties) {
        return TDBlocks.register(name, blockSupplier, (T block) -> new BlockItem(block, blockItemProperties));
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> blockSupplier, @Nullable Function<T, ? extends BlockItem> blockItemFactory) {
        return RegistrationHelpers.registerBlock(BLOCKS, TDItems.ITEMS, (String)name, blockSupplier, blockItemFactory);
    }
}

