/*
 * Decompiled with CFR 0.152.
 */
package tfcthermaldeposits.common.blocks.rock;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.dries007.tfc.common.blocks.DirectionPropertyBlock;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import tfcthermaldeposits.common.blockentities.TDBlockEntities;

public class MineralSheetBlock
extends ExtendedBlock
implements EntityBlockExtension,
DirectionPropertyBlock,
IFluidLoggable {
    public static final FluidProperty ALL_WATER_AND_LAVA = FluidProperty.create((String)"fluid", Stream.of(Fluids.f_76191_, Fluids.f_76193_, TFCFluids.SALT_WATER, TFCFluids.SPRING_WATER, TFCFluids.RIVER_WATER, Fluids.f_76195_));
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty MIRROR = BooleanProperty.m_61465_((String)"mirror");
    public static final Map<BooleanProperty, VoxelShape> SHAPES = new ImmutableMap.Builder().put((Object)NORTH, (Object)MineralSheetBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0)).put((Object)SOUTH, (Object)MineralSheetBlock.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0)).put((Object)EAST, (Object)MineralSheetBlock.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).put((Object)WEST, (Object)MineralSheetBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0)).put((Object)UP, (Object)MineralSheetBlock.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).put((Object)DOWN, (Object)MineralSheetBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0)).build();
    public static final FluidProperty FLUID = ALL_WATER_AND_LAVA;
    private final Map<BlockState, VoxelShape> shapeCache;

    public MineralSheetBlock(ExtendedProperties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)DirectionPropertyBlock.setAllDirections((BlockState)((BlockState)this.m_49965_().m_61090_()), (boolean)false).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)MIRROR, (Comparable)Boolean.valueOf(false)));
        this.shapeCache = DirectionPropertyBlock.makeShapeCache((StateDefinition)this.m_49965_(), SHAPES::get);
    }

    public static void removeSheet(Level level, BlockPos pos, BlockState state, Direction face, @Nullable Player player, boolean doDrops) {
        BlockState newState = (BlockState)state.m_61124_((Property)DirectionPropertyBlock.getProperty((Direction)face), (Comparable)Boolean.valueOf(false));
        level.m_5594_(null, pos, SoundEvents.f_144091_, SoundSource.BLOCKS, 0.7f, 0.9f + 0.2f * level.m_213780_().m_188501_());
        if (doDrops && (player == null || !player.m_7500_())) {
            level.m_141902_(pos, (BlockEntityType)TDBlockEntities.MINERAL_SHEET.get()).ifPresent(pile -> {
                ItemStack stack = pile.removeSheet(face);
                MineralSheetBlock.m_152435_((Level)level, (BlockPos)pos, (Direction)face, (ItemStack)stack);
            });
        }
        if (MineralSheetBlock.isEmpty(newState)) {
            level.m_46961_(pos, false);
        } else {
            level.m_7731_(pos, newState, 2);
            level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        }
    }

    public static void addSheet(LevelAccessor level, BlockPos pos, BlockState state, Direction face, ItemStack stack) {
        BlockState newState = (BlockState)state.m_61124_((Property)DirectionPropertyBlock.getProperty((Direction)face), (Comparable)Boolean.valueOf(true));
        level.m_7731_(pos, newState, 2);
        level.m_141902_(pos, (BlockEntityType)TDBlockEntities.MINERAL_SHEET.get()).ifPresent(pile -> pile.addSheet(face, stack));
        SoundType placementSound = state.getSoundType((LevelReader)level, pos, null);
        level.m_5594_(null, pos, state.getSoundType((LevelReader)level, pos, null).m_56777_(), SoundSource.BLOCKS, (placementSound.m_56773_() + 1.0f) / 2.0f, placementSound.m_56774_() * 0.8f);
    }

    @Nullable
    public static Direction getTargetedFace(Level level, BlockState state, Player player) {
        BlockHitResult result = Helpers.rayTracePlayer((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            Vec3 hit = result.m_82450_();
            Direction firstDirection = null;
            for (Map.Entry<BooleanProperty, VoxelShape> entry : SHAPES.entrySet()) {
                BooleanProperty property = entry.getKey();
                if (!((Boolean)state.m_61143_((Property)property)).booleanValue()) continue;
                if (firstDirection == null) {
                    firstDirection = DirectionPropertyBlock.getDirection((BooleanProperty)property);
                }
                if (!entry.getValue().m_83215_().m_82338_(result.m_82425_()).m_82400_(0.01).m_82390_(hit)) continue;
                return DirectionPropertyBlock.getDirection((BooleanProperty)property);
            }
            return firstDirection;
        }
        return null;
    }

    public static VoxelShape getShapeForSingleFace(Direction direction) {
        return SHAPES.get(DirectionPropertyBlock.getProperty((Direction)direction));
    }

    public static int countSheets(BlockState state, Predicate<Direction> onlyTheseDirections) {
        int count = 0;
        for (Direction direction : Helpers.DIRECTIONS) {
            if (!onlyTheseDirections.test(direction) || !((Boolean)state.m_61143_((Property)DirectionPropertyBlock.getProperty((Direction)direction))).booleanValue()) continue;
            ++count;
        }
        return count;
    }

    public static boolean isEmpty(BlockState state) {
        for (BooleanProperty property : PROPERTIES) {
            if (!((Boolean)state.m_61143_((Property)property)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (!neighborState.m_60783_((BlockGetter)level, neighborPos, direction.m_122424_())) {
            level.m_186460_(currentPos, (Block)this, 0);
        }
        return state;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        for (Direction direction : Helpers.DIRECTIONS) {
            BlockPos adjacentPos;
            BlockState adjacentState;
            if (!((Boolean)state.m_61143_((Property)DirectionPropertyBlock.getProperty((Direction)direction))).booleanValue() || (adjacentState = level.m_8055_(adjacentPos = pos.m_121945_(direction))).m_60783_((BlockGetter)level, adjacentPos, direction.m_122424_())) continue;
            MineralSheetBlock.removeSheet((Level)level, pos, state, direction, null, true);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        for (Direction direction : Helpers.DIRECTIONS) {
            BlockPos adjacentPos;
            BlockState adjacentState;
            if (!((Boolean)state.m_61143_((Property)DirectionPropertyBlock.getProperty((Direction)direction))).booleanValue() || (adjacentState = level.m_8055_(adjacentPos = pos.m_121945_(direction))).m_60783_((BlockGetter)level, adjacentPos, direction.m_122424_())) continue;
            return false;
        }
        return true;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        Level realLevel;
        Direction targetFace;
        if (level instanceof Level && (targetFace = MineralSheetBlock.getTargetedFace(realLevel = (Level)level, state, player)) != null) {
            return level.m_141902_(pos, (BlockEntityType)TDBlockEntities.MINERAL_SHEET.get()).map(pile -> pile.getSheet(targetFace)).orElse(ItemStack.f_41583_);
        }
        return ItemStack.f_41583_;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        boolean canActuallyHarvest = state.canHarvestBlock((BlockGetter)level, pos, player);
        Direction targetFace = MineralSheetBlock.getTargetedFace(level, state, player);
        this.m_5707_(level, pos, state, player);
        if (targetFace == null) {
            level.m_46961_(pos, false);
        } else {
            MineralSheetBlock.removeSheet(level, pos, state, targetFace, player, canActuallyHarvest);
        }
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_((Property[])PROPERTIES).m_61104_(new Property[]{FACING}).m_61104_(new Property[]{MIRROR}).m_61104_(new Property[]{this.getFluidProperty()}));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapeCache.get(state);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)DirectionPropertyBlock.rotate((BlockState)state, (Rotation)rot).m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        return (BlockState)((BlockState)DirectionPropertyBlock.mirror((BlockState)state, (Mirror)mirror).m_61124_((Property)FACING, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)FACING)))).m_61122_((Property)MIRROR);
    }

    public static boolean canPlace(Level level, BlockPos pos, BlockState stateToPlace) {
        return stateToPlace.m_60710_((LevelReader)level, pos);
    }

    public FluidProperty getFluidProperty() {
        return FLUID;
    }

    public FluidState m_5888_(BlockState state) {
        return super.getFluidLoggedState(state);
    }

    public boolean m_6044_(BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        if (fluid instanceof FlowingFluid && !this.getFluidProperty().canContain(fluid)) {
            return true;
        }
        return super.m_6044_(level, pos, state, fluid);
    }

    public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (fluidStateIn.m_76152_() instanceof FlowingFluid && !this.getFluidProperty().canContain(fluidStateIn.m_76152_())) {
            for (Direction direction : Helpers.DIRECTIONS) {
                ItemStack item;
                if (direction == null || (item = level.m_141902_(pos, (BlockEntityType)TDBlockEntities.MINERAL_SHEET.get()).map(pile -> pile.getSheet(direction)).orElse(ItemStack.f_41583_)) == null || !(level instanceof Level)) continue;
                Level realLevel = (Level)level;
                realLevel.m_7967_((Entity)new ItemEntity(realLevel, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), item));
            }
            level.m_46961_(pos, false);
            level.m_7731_(pos, fluidStateIn.m_76188_(), 2);
            return true;
        }
        return super.m_7361_(level, pos, state, fluidStateIn);
    }
}

