/*
 * Decompiled with CFR 0.152.
 */
package tfcthermaldeposits.common.entities;

import java.util.Map;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rock.Ore;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.common.blocks.rock.RockCategory;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistryRock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;
import tfcthermaldeposits.client.particle.TDParticles;
import tfcthermaldeposits.common.entities.TDEntities;
import tfcthermaldeposits.config.TDConfig;
import tfcthermaldeposits.util.TDHelpers;

public class PyroclasticBomb
extends PrimedTnt {
    public static final BlockState DEFAULT_BLOCK = ((Block)((RegistryObject)((Map)TFCBlocks.ROCK_BLOCKS.get(Rock.BASALT)).get(Rock.BlockType.COBBLE)).get()).m_49966_();
    @Nullable
    private LivingEntity owner;
    public SimpleParticleType particleType;
    public SimpleParticleType particleTypeExplosion;
    public Level.ExplosionInteraction explosionInteraction;
    public double explosionRadius;
    public boolean shouldSpreadFire;
    public boolean shouldSpawnScoria;
    public boolean shouldSpawnVanillaExplosionParticles;
    public RegistryRock rock;

    public PyroclasticBomb(EntityType<? extends PrimedTnt> entityType, Level level) {
        this(entityType, level, ParticleTypes.f_123762_, (SimpleParticleType)TDParticles.PYROCLASTIC_BOMB_EMITTER.get(), 4.0, Level.ExplosionInteraction.NONE, true, false, true, (RegistryRock)Rock.BASALT);
    }

    public PyroclasticBomb(EntityType<? extends PrimedTnt> entityType, Level level, SimpleParticleType particleType, SimpleParticleType particleTypeExplosion, double explosionRadius, Level.ExplosionInteraction explosionInteraction, boolean shouldSpreadFire, boolean shouldSpawnScoria, boolean shouldSpawnVanillaExplosionParticles, RegistryRock rock) {
        super(entityType, level);
        this.particleType = particleType;
        this.particleTypeExplosion = particleTypeExplosion;
        this.explosionRadius = explosionRadius;
        this.explosionInteraction = explosionInteraction;
        this.shouldSpreadFire = shouldSpreadFire;
        this.shouldSpawnScoria = shouldSpawnScoria;
        this.shouldSpawnVanillaExplosionParticles = shouldSpawnVanillaExplosionParticles;
        this.rock = rock;
    }

    public PyroclasticBomb(Level level, double x, double y, double z, @Nullable LivingEntity owner) {
        this(level, x, y, z, owner, ParticleTypes.f_123755_, (SimpleParticleType)TDParticles.PYROCLASTIC_BOMB_EMITTER.get(), 4.0, Level.ExplosionInteraction.NONE, true, false, true, (RegistryRock)Rock.BASALT);
    }

    public PyroclasticBomb(Level level, double x, double y, double z, @Nullable LivingEntity owner, SimpleParticleType particleType, SimpleParticleType particleTypeExplosion, double explosionRadius, Level.ExplosionInteraction explosionInteraction, boolean shouldSpreadFire, boolean shouldSpawnScoria, boolean shouldSpawnVanillaExplosionParticles, RegistryRock rock) {
        this((EntityType<? extends PrimedTnt>)((EntityType)TDEntities.PYROCLASTIC_BOMB.get()), level, particleType, particleTypeExplosion, explosionRadius, explosionInteraction, shouldSpreadFire, shouldSpawnScoria, shouldSpawnVanillaExplosionParticles, rock);
        this.m_6034_(x, y, z);
        double d0 = level.f_46441_.m_188500_() * (Math.PI * 2);
        this.m_20334_(-Math.sin(d0) * 0.02, 0.2f, -Math.cos(d0) * 0.02);
        this.m_32085_(80);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
        this.owner = owner;
        this.particleType = particleType;
        this.particleTypeExplosion = particleTypeExplosion;
        this.explosionRadius = explosionRadius;
        this.explosionInteraction = explosionInteraction;
        this.shouldSpreadFire = shouldSpreadFire;
        this.shouldSpawnScoria = shouldSpawnScoria;
        this.shouldSpawnVanillaExplosionParticles = shouldSpawnVanillaExplosionParticles;
        this.rock = rock;
    }

    public SimpleParticleType getParticleType() {
        return this.particleType;
    }

    public SimpleParticleType getExplosionParticles() {
        return this.particleTypeExplosion;
    }

    public Level.ExplosionInteraction getExplosionInteraction() {
        return this.explosionInteraction;
    }

    public double getExplosionRadius() {
        return this.explosionRadius;
    }

    public boolean shouldSpreadFire() {
        return this.shouldSpreadFire;
    }

    public boolean shouldSpawnScoria() {
        return this.shouldSpawnScoria;
    }

    public boolean shouldSpawnVanillaExplosionParticles() {
        return this.shouldSpawnVanillaExplosionParticles;
    }

    public RegistryRock getRock() {
        return this.rock;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.ALL;
    }

    public void m_8119_() {
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82490_(0.98));
        if (this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.7, -0.5, 0.7));
        }
        int i = this.m_32100_() - 1;
        this.m_32085_(i);
        if (i <= 0 || this.m_20096_() || this.m_20039_(this.m_20183_(), this.m_9236_().m_8055_(this.m_20183_()))) {
            this.m_9236_().m_7785_(this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, SoundEvents.f_11892_, SoundSource.AMBIENT, 4.0f, (0.4f + (this.m_9236_().f_46441_.m_188501_() - this.m_9236_().f_46441_.m_188501_()) * 0.2f) * 0.7f, false);
            this.m_9236_().m_7106_((ParticleOptions)TDParticles.PYROCLASTIC_BOMB_EMITTER.get(), this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, 1.0, 0.0, 0.0);
            if (!this.m_9236_().f_46443_) {
                this.m_32103_();
                if (((Boolean)TDConfig.COMMON.togglePyroclasticBombScoria.get()).booleanValue() && this.shouldSpawnScoria() && this.m_9236_().m_8055_(this.m_20183_().m_7495_()).m_280296_()) {
                    this.placeBlocks(this.m_9236_(), this.m_20183_(), this.m_9236_().m_213780_());
                }
            }
            this.m_9236_().m_7785_(this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, SoundEvents.f_11892_, SoundSource.AMBIENT, 4.0f, (0.4f + (this.m_9236_().f_46441_.m_188501_() - this.m_9236_().f_46441_.m_188501_()) * 0.2f) * 0.7f, false);
            this.m_9236_().m_7106_((ParticleOptions)TDParticles.PYROCLASTIC_BOMB_EMITTER.get(), this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, 1.0, 0.0, 0.0);
            this.m_146870_();
        } else {
            if (this.m_9236_().m_8055_(this.m_20183_()).m_284242_((BlockGetter)this.m_9236_(), this.m_20183_()) == MapColor.f_283864_) {
                this.m_20073_();
            }
            for (int j = 0; j < 2 + this.f_19796_.m_188503_(10); ++j) {
                this.m_9236_().m_7106_((ParticleOptions)this.getParticleType(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void m_32103_() {
        boolean fire = this.shouldSpreadFire() && this.shouldSpawnScoria();
        this.m_9236_().m_255278_((Entity)this, null, null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)this.getExplosionRadius(), fire, this.getExplosionInteraction(), this.shouldSpawnVanillaExplosionParticles());
    }

    public void placeBlocks(Level level, BlockPos pos, RandomSource random) {
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        if (random.m_188501_() < 0.5f) {
            this.setBlockCheck(level, pos);
            for (Direction dir : Helpers.DIRECTIONS) {
                if (!(random.m_188501_() < 0.8f)) continue;
                cursor.m_122159_((Vec3i)pos, dir);
                this.setBlockCheck(level, (BlockPos)cursor);
            }
        } else if (random.m_188501_() < 0.5f) {
            int i;
            cursor.m_122154_((Vec3i)pos, 0, -2, 0);
            int height = 4 + random.m_188503_(3);
            for (i = 0; i < height; ++i) {
                this.setBlockCheck(level, (BlockPos)cursor);
                cursor.m_122184_(0, 1, 0);
            }
            cursor.m_122154_((Vec3i)pos, 0, -2, 0);
            cursor.m_122173_(Direction.Plane.HORIZONTAL.m_235690_(random));
            for (i = 0; i < height - 2; ++i) {
                this.setBlockCheck(level, (BlockPos)cursor);
                cursor.m_122184_(0, 1, 0);
            }
        } else {
            cursor.m_122190_((Vec3i)pos);
            this.setBlockCheck(level, (BlockPos)cursor);
            cursor.m_122184_(0, -1, 0);
            this.setBlockCheck(level, (BlockPos)cursor);
        }
    }

    public void setBlockCheck(Level level, BlockPos pos) {
        if (level.m_46859_(pos) || level.m_8055_(pos).m_247087_() && level.m_6425_(pos).m_76152_() != Fluids.f_76195_ && level.m_8055_(pos).m_60734_() != Blocks.f_49991_) {
            level.m_46597_(pos, this.getRandomRock());
        }
    }

    public BlockState getRandomRock() {
        RegistryRock rock = this.getRock();
        BlockState scoria = ((Block)((RegistryObject)((Map)TFCBlocks.ROCK_BLOCKS.get(rock)).get(Rock.BlockType.COBBLE)).get()).m_49966_();
        if (((Boolean)TDConfig.COMMON.togglePyroclasticBombOre.get()).booleanValue() && this.f_19796_.m_188503_(((Integer)TDConfig.COMMON.pyroclasticBombOreChance.get()).intValue()) == 0) {
            Ore[] ores = Ore.values();
            Ore.Grade[] grades = Ore.Grade.values();
            Ore ore = ores[this.f_19796_.m_188503_(ores.length)];
            Ore.Grade grade = grades[this.f_19796_.m_188503_(grades.length)];
            if (ore.isGraded()) {
                scoria = ((Block)((RegistryObject)((Map)((Map)TFCBlocks.GRADED_ORES.get(rock)).get(ore)).get(grade)).get()).m_49966_();
            }
            if (TDHelpers.isIgneous((LevelAccessor)this.m_9236_(), this.m_20183_()) && this.f_19796_.m_188503_(10) == 0) {
                scoria = Blocks.f_50080_.m_49966_();
                if (this.f_19796_.m_188503_(10) == 0) {
                    scoria = Blocks.f_50723_.m_49966_();
                }
            }
        }
        if (this.m_9236_().m_46472_() == Level.f_46429_ && this.f_19796_.m_188503_(10) == 0 && (rock.category() == RockCategory.IGNEOUS_EXTRUSIVE || rock.category() == RockCategory.IGNEOUS_INTRUSIVE)) {
            scoria = ((Block)((RegistryObject)TFCBlocks.MAGMA_BLOCKS.get(rock)).get()).m_49966_();
        }
        return scoria;
    }
}

