/*
 * Decompiled with CFR 0.152.
 */
package tfcthermaldeposits.config;

import net.dries007.tfc.config.ConfigBuilder;
import net.minecraftforge.common.ForgeConfigSpec;

public class TDCommonConfig {
    public final ForgeConfigSpec.BooleanValue shouldLavaDepositMinerals;
    public final ForgeConfigSpec.BooleanValue shouldHotSpringsDepositMinerals;
    public final ForgeConfigSpec.IntValue mineralGenFrequencyLava;
    public final ForgeConfigSpec.IntValue mineralGenFrequencyHotSpring;
    public final ForgeConfigSpec.BooleanValue shouldLavaSmoke;
    public final ForgeConfigSpec.BooleanValue toggleOtherDimensions;
    public final ForgeConfigSpec.BooleanValue naturalReplenishment;
    public final ForgeConfigSpec.BooleanValue toggleDepositsFromAllLavaOrSpringWater;
    public final ForgeConfigSpec.BooleanValue togglePyroclasticBombs;
    public final ForgeConfigSpec.BooleanValue togglePyroclasticBombsExplode;
    public final ForgeConfigSpec.DoubleValue pyroclasticBombExplosionRadius;
    public final ForgeConfigSpec.BooleanValue togglePyroclasticBombScoria;
    public final ForgeConfigSpec.BooleanValue togglePyroclasticBombOre;
    public final ForgeConfigSpec.IntValue pyroclasticBombOreChance;
    public final ForgeConfigSpec.BooleanValue toggleVolcanoShake;
    public final ForgeConfigSpec.BooleanValue toggleNetherTremor;
    public final ForgeConfigSpec.BooleanValue highTremorFrequency;
    public final ForgeConfigSpec.DoubleValue earthquakeSoundAmplifier;
    public final ForgeConfigSpec.DoubleValue replenishmentFactorMafic;
    public final ForgeConfigSpec.DoubleValue replenishmentFactorIntermediate;
    public final ForgeConfigSpec.DoubleValue replenishmentFactorFelsic;
    public final ForgeConfigSpec.DoubleValue replenishmentFactorMetamorphic;
    public final ForgeConfigSpec.DoubleValue replenishmentFactorSedimentary;
    public final ForgeConfigSpec.DoubleValue maficVolcanoIntensityFactor;
    public final ForgeConfigSpec.DoubleValue intermediateVolcanoIntensityFactor;
    public final ForgeConfigSpec.DoubleValue felsicVolcanoIntensityFactor;
    public final ForgeConfigSpec.DoubleValue metamorphicVolcanoIntensityFactor;
    public final ForgeConfigSpec.DoubleValue sedimentaryVolcanoIntensityFactor;
    public final ForgeConfigSpec.IntValue slopeDistanceFelsic;
    public final ForgeConfigSpec.IntValue slopeDistanceSedimentary;
    public final ForgeConfigSpec.IntValue slopeDistanceMetamorphic;
    public final ForgeConfigSpec.IntValue slopeDistanceIntermediate;
    public final ForgeConfigSpec.IntValue slopeDistanceMafic;
    public final ForgeConfigSpec.IntValue dropOffFelsic;
    public final ForgeConfigSpec.IntValue dropOffSedimentary;
    public final ForgeConfigSpec.IntValue dropOffMetamorphic;
    public final ForgeConfigSpec.IntValue dropOffIntermediate;
    public final ForgeConfigSpec.IntValue dropOffMafic;
    public final ForgeConfigSpec.IntValue tickDelayFelsic;
    public final ForgeConfigSpec.IntValue tickDelaySedimentary;
    public final ForgeConfigSpec.IntValue tickDelayMetamorphic;
    public final ForgeConfigSpec.IntValue tickDelayIntermediate;
    public final ForgeConfigSpec.IntValue tickDelayMafic;
    public final ForgeConfigSpec.BooleanValue toggleDebug;
    public final ForgeConfigSpec.BooleanValue toggleFiniteWater;

    TDCommonConfig(ConfigBuilder builder) {
        builder.push("General");
        this.shouldLavaDepositMinerals = builder.comment(new String[]{"Should lava deposit minerals onto the surrounding blocks?"}).define("shouldLavaDepositMinerals", true);
        this.shouldHotSpringsDepositMinerals = builder.comment(new String[]{"Should hot springs deposit minerals onto the surrounding blocks?"}).define("shouldHotSpringsDepositMinerals", true);
        this.mineralGenFrequencyLava = builder.comment(new String[]{"How often minerals can generate around lava. This also affects natural replenishment. Lower value => more often."}).define("mineralGenFrequencyLava", 128, 0, Integer.MAX_VALUE);
        this.mineralGenFrequencyHotSpring = builder.comment(new String[]{"How often minerals can generate around hot springs. This also affects natural replenishment. Lower value => more often."}).define("mineralGenFrequencyHotSpring", 64, 0, Integer.MAX_VALUE);
        this.shouldLavaSmoke = builder.comment(new String[]{"Toggle smoke particles released by lava? True = smokes."}).define("shouldLavaSmoke", true);
        this.toggleOtherDimensions = builder.comment(new String[]{"Toggle whether or not lava and hot springs should deposit minerals in other dimensions than the overworld? True = not limited to the overworld."}).define("toggleOtherDimensions", false);
        this.naturalReplenishment = builder.comment(new String[]{"Toggle whether or not lava and hot spring water should replenish their mineral \"storage\" naturally. True = replenishes."}).define("naturalReplenishment", true);
        this.toggleDepositsFromAllLavaOrSpringWater = builder.comment(new String[]{"Toggle whether or not lava and hot spring water should deposit minerals, regardless of them being natural or placed. True = all generated or placed deposits minerals."}).define("toggleDepositsFromAllLavaOrSpringWater", false);
        this.earthquakeSoundAmplifier = builder.comment(new String[]{"Sound amplifier level for earthquakes and tremors. Default = 4.0."}).define("earthquakeSoundAmplifier", 4.0, 0.0, Double.MAX_VALUE);
        this.togglePyroclasticBombs = builder.comment(new String[]{"Should volcanoes launch pyroclastic bombs?"}).define("togglePyroclasticBombs", true);
        this.togglePyroclasticBombsExplode = builder.comment(new String[]{"Should pyroclastic bombs destroy blocks?"}).define("togglePyroclasticBombsExplode", false);
        this.pyroclasticBombExplosionRadius = builder.comment(new String[]{"How big should the explosion radius of pyroclastic bombs be? Default = 4.0."}).define("pyroclasticBombExplosionRadius", 4.0, 0.0, Double.MAX_VALUE);
        this.togglePyroclasticBombScoria = builder.comment(new String[]{"Should pyroclastic bombs generate scoria around its zone of impact?"}).define("togglePyroclasticBombScoria", true);
        this.togglePyroclasticBombOre = builder.comment(new String[]{"Should pyroclastic bombs have a chance of spawning with ore?"}).define("togglePyroclasticBombOre", true);
        this.pyroclasticBombOreChance = builder.comment(new String[]{"How big of a chance should pyroclastic bombs have to contain a random ore? Higher value => lower chance."}).define("pyroclasticBombOreChance", 30, 1, Integer.MAX_VALUE);
        this.toggleVolcanoShake = builder.comment(new String[]{"Should volcanos shake the camera during high activity events?"}).define("toggleVolcanoShake", true);
        this.toggleNetherTremor = builder.comment(new String[]{"Should Nether have the occasional tremors and earthquakes?"}).define("toggleNetherTremor", true);
        this.highTremorFrequency = builder.comment(new String[]{"Should tremors happen more frequent? True => more frequent."}).define("highTremorFrequency", false);
        this.replenishmentFactorMafic = builder.comment(new String[]{"How fast shall minerals replenish for the lava or hot spring water in mafic rock environment? Lower = faster."}).define("replenishmentFactorMafic", 0.25, Double.MIN_VALUE, Double.MAX_VALUE);
        this.replenishmentFactorIntermediate = builder.comment(new String[]{"How fast shall minerals replenish for the lava or hot spring water in intermediate rock environment? Lower = faster."}).define("replenishmentFactorIntermediate", 0.42, Double.MIN_VALUE, Double.MAX_VALUE);
        this.replenishmentFactorFelsic = builder.comment(new String[]{"How fast shall minerals replenish for the lava or hot spring water in felsic rock environment? Lower = faster."}).define("replenishmentFactorFelsic", 0.66, Double.MIN_VALUE, Double.MAX_VALUE);
        this.replenishmentFactorMetamorphic = builder.comment(new String[]{"How fast shall minerals replenish for the lava or hot spring water in metamorphic rock environment? Lower = faster."}).define("replenishmentFactorMetamorphic", 0.5, Double.MIN_VALUE, Double.MAX_VALUE);
        this.replenishmentFactorSedimentary = builder.comment(new String[]{"How fast shall minerals replenish for the lava or hot spring water in sedimentary rock environment? Lower = faster."}).define("replenishmentFactorSedimentary", 1.0, Double.MIN_VALUE, Double.MAX_VALUE);
        this.maficVolcanoIntensityFactor = builder.comment(new String[]{"Factor for how rare pyroclastic bombs will happen in rocks of the mafic type. Lower = greater intensity."}).define("maficVolcanoIntensityFactor", 2.0, 0.0, 2000.0);
        this.intermediateVolcanoIntensityFactor = builder.comment(new String[]{"Factor for how rare pyroclastic bombs will happen in rocks of the intermediate type. Lower = greater intensity."}).define("intermediateVolcanoIntensityFactor", 1.5, 0.0, 2000.0);
        this.felsicVolcanoIntensityFactor = builder.comment(new String[]{"Factor for how rare pyroclastic bombs will happen in rocks of the felsic type. Lower = greater intensity."}).define("felsicVolcanoIntensityFactor", 0.6, 0.0, 2000.0);
        this.metamorphicVolcanoIntensityFactor = builder.comment(new String[]{"Factor for how rare pyroclastic bombs will happen in rocks of the metamorphic type. Lower = greater intensity."}).define("metamorphicVolcanoIntensityFactor", 1.0, 0.0, 2000.0);
        this.sedimentaryVolcanoIntensityFactor = builder.comment(new String[]{"Factor for how rare pyroclastic bombs will happen in rocks of the sedimentary type. Lower = greater intensity."}).define("sedimentaryVolcanoIntensityFactor", 0.9, 0.0, 2000.0);
        builder.comment(new String[]{"Felsic rocks contain more silica compounds than mafic, thus \"felsic lava\" has a higher viscosity, flow speed and distance -- like honey.", ""});
        builder.comment(new String[]{"Standard slope distance for lava is 2, whilst 4 in the Nether."});
        this.slopeDistanceFelsic = builder.comment(new String[]{"Slope distance for lava in felsic rocks."}).define("slopeDistanceFelsic", 4, 0, Integer.MAX_VALUE);
        this.slopeDistanceSedimentary = builder.comment(new String[]{"Slope distance for lava in sedimentary rocks."}).define("slopeDistanceSedimentary", 5, 0, Integer.MAX_VALUE);
        this.slopeDistanceMetamorphic = builder.comment(new String[]{"Slope distance for lava in metamorphic rocks."}).define("slopeDistanceMetamorphic", 5, 0, Integer.MAX_VALUE);
        this.slopeDistanceIntermediate = builder.comment(new String[]{"Slope distance for lava in intermediate rocks."}).define("slopeDistanceIntermediate", 6, 0, Integer.MAX_VALUE);
        this.slopeDistanceMafic = builder.comment(new String[]{"Slope distance for lava in mafic rocks."}).define("slopeDistanceMafic", 7, 0, Integer.MAX_VALUE);
        builder.comment(new String[]{"Standard drop off for lava is 2, whilst 1 in the Nether."});
        this.dropOffFelsic = builder.comment(new String[]{"Drop off for lava in felsic rocks."}).define("dropOffFelsic", 3, 0, Integer.MAX_VALUE);
        this.dropOffSedimentary = builder.comment(new String[]{"Drop off for lava in sedimentary rocks."}).define("dropOffSedimentary", 2, 0, Integer.MAX_VALUE);
        this.dropOffMetamorphic = builder.comment(new String[]{"Drop off for lava in metamorphic rocks."}).define("dropOffMetamorphic", 2, 0, Integer.MAX_VALUE);
        this.dropOffIntermediate = builder.comment(new String[]{"Drop off for lava in intermediate rocks."}).define("dropOffIntermediate", 1, 0, Integer.MAX_VALUE);
        this.dropOffMafic = builder.comment(new String[]{"Drop off for lava in mafic rocks."}).define("dropOffMafic", 1, 0, Integer.MAX_VALUE);
        builder.comment(new String[]{"Standard tick delay for lava is 30, whilst 10 in the Nether."});
        this.tickDelayFelsic = builder.comment(new String[]{"Tick delay for lava in felsic rocks."}).define("tickDelayFelsic", 40, 0, Integer.MAX_VALUE);
        this.tickDelaySedimentary = builder.comment(new String[]{"Tick delay for lava in sedimentary rocks."}).define("tickDelaySedimentary", 25, 0, Integer.MAX_VALUE);
        this.tickDelayMetamorphic = builder.comment(new String[]{"Tick delay for lava in metamorphic rocks."}).define("tickDelayMetamorphic", 25, 0, Integer.MAX_VALUE);
        this.tickDelayIntermediate = builder.comment(new String[]{"Tick delay for lava in intermediate rocks."}).define("tickDelayIntermediate", 10, 0, Integer.MAX_VALUE);
        this.tickDelayMafic = builder.comment(new String[]{"Tick delay for lava in mafic rocks."}).define("tickDelayMafic", 5, 0, Integer.MAX_VALUE);
        this.toggleDebug = builder.comment(new String[]{"Enable debug messaging in the log?"}).define("toggleDebug", false);
        this.toggleFiniteWater = builder.comment(new String[]{"Toggle finite water for salt-, fresh-, river- and spring water? Setting this to true will prevent water from creating source blocks when spreading."}).define("toggleFiniteWater", false);
        builder.pop();
    }
}

