/*
 * Decompiled with CFR 0.152.
 */
package tfcthermaldeposits.mixin;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.shorts.Short2BooleanMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import java.util.Map;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.event.ForgeEventFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tfcthermaldeposits.common.TDTags;
import tfcthermaldeposits.config.TDConfig;
import tfcthermaldeposits.util.TDHelpers;

@Mixin(value={FlowingFluid.class}, priority=1000)
public abstract class FlowingFluidMixin
extends Fluid {
    @Inject(method={"getSlopeDistance"}, at={@At(value="HEAD")}, cancellable=true)
    protected void inject$getSlopeDistance(LevelReader level, BlockPos spreadPos, int distance, Direction sourceDirection, BlockState currentSpreadState, BlockPos sourcePos, Short2ObjectMap<Pair<BlockState, FluidState>> stateCache, Short2BooleanMap waterHoleCache, CallbackInfoReturnable<Integer> cir) {
        if (this.getFluidType().equals(Fluids.f_76195_.getFluidType())) {
            int i = 1000;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                int j;
                Level actualLevel;
                if (direction == sourceDirection) continue;
                BlockPos blockpos = spreadPos.m_121945_(direction);
                short short1 = FlowingFluidMixin.m_76058_(sourcePos, blockpos);
                Pair pair = (Pair)stateCache.computeIfAbsent(short1, map -> {
                    BlockState blockstate1 = level.m_8055_(blockpos);
                    return Pair.of((Object)blockstate1, (Object)blockstate1.m_60819_());
                });
                BlockState blockstate = (BlockState)pair.getFirst();
                FluidState fluidstate = (FluidState)pair.getSecond();
                if (!this.m_75963_((BlockGetter)level, this.m_5615_(), spreadPos, currentSpreadState, direction, blockpos, blockstate, fluidstate)) continue;
                boolean flag = waterHoleCache.computeIfAbsent(short1, map -> {
                    BlockPos blockpos1 = blockpos.m_7495_();
                    BlockState blockstate1 = level.m_8055_(blockpos1);
                    return this.m_75956_((BlockGetter)level, this.m_5615_(), blockpos, blockstate, blockpos1, blockstate1);
                });
                if (flag) {
                    cir.setReturnValue((Object)distance);
                }
                if (!(level instanceof Level) || distance >= TDHelpers.getSlopeFindDistance((LevelAccessor)(actualLevel = (Level)level), sourcePos) || (j = this.m_76026_(level, blockpos, distance + 1, direction.m_122424_(), blockstate, sourcePos, stateCache, waterHoleCache)) >= i) continue;
                i = j;
            }
            cir.setReturnValue((Object)i);
        }
        cir.getReturnValue();
    }

    @Inject(method={"spreadToSides"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject$spreadToSides(Level level, BlockPos pos, FluidState fluidState, BlockState blockState, CallbackInfo ci) {
        if (this.getFluidType().equals(Fluids.f_76195_.getFluidType())) {
            int i = fluidState.m_76186_() - TDHelpers.getDropOff((LevelAccessor)level, pos);
            if (((Boolean)fluidState.m_61143_((Property)FlowingFluid.f_75947_)).booleanValue()) {
                i = 7;
            }
            if (i > 0) {
                Map<Direction, FluidState> map = this.m_76079_(level, pos, blockState);
                for (Map.Entry<Direction, FluidState> entry : map.entrySet()) {
                    BlockState blockstate;
                    Direction direction = entry.getKey();
                    FluidState fluidstate = entry.getValue();
                    BlockPos blockpos = pos.m_121945_(direction);
                    if (!this.m_75977_((BlockGetter)level, pos, blockState, direction, blockpos, blockstate = level.m_8055_(blockpos), level.m_6425_(blockpos), fluidstate.m_76152_())) continue;
                    this.m_6364_((LevelAccessor)level, blockpos, blockstate, direction, fluidstate);
                    ci.cancel();
                }
            }
        }
    }

    @Inject(method={"getNewLiquid"}, at={@At(value="HEAD")}, cancellable=true)
    protected void inject$getNewLiquid(Level level, BlockPos pos, BlockState blockState, CallbackInfoReturnable<FluidState> cir) {
        boolean isLava = this.getFluidType().equals(Fluids.f_76195_.getFluidType());
        if (isLava || Helpers.isFluid((Fluid)this, TDTags.Fluids.FINITE_FLUIDS) && ((Boolean)TDConfig.COMMON.toggleFiniteWater.get()).booleanValue()) {
            BlockPos blockpos1;
            BlockState blockstate2;
            FluidState fluidstate2;
            int i = 0;
            int j = 0;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos blockpos = pos.m_121945_(direction);
                BlockState blockstate = level.m_8055_(blockpos);
                FluidState fluidstate = blockstate.m_60819_();
                if (!fluidstate.m_76152_().m_6212_((Fluid)this) || !this.m_76061_(direction, (BlockGetter)level, pos, blockState, blockpos, blockstate)) continue;
                if (fluidstate.m_76170_() && ForgeEventFactory.canCreateFluidSource((Level)level, (BlockPos)blockpos, (BlockState)blockstate, (boolean)fluidstate.canConvertToSource(level, blockpos))) {
                    ++j;
                }
                i = Math.max(i, fluidstate.m_76186_());
            }
            if (j >= 2) {
                BlockState blockstate1 = level.m_8055_(pos.m_7495_());
                FluidState fluidstate1 = blockstate1.m_60819_();
                if (blockstate1.m_280296_() || this.m_76096_(fluidstate1)) {
                    cir.setReturnValue((Object)((FlowingFluid)this).m_76068_(false));
                }
            }
            if (!(fluidstate2 = (blockstate2 = level.m_8055_(blockpos1 = pos.m_7494_())).m_60819_()).m_76178_() && fluidstate2.m_76152_().m_6212_((Fluid)this) && this.m_76061_(Direction.UP, (BlockGetter)level, pos, blockState, blockpos1, blockstate2)) {
                cir.setReturnValue((Object)((FlowingFluid)this).m_75953_(8, true));
            } else {
                int k = i - (isLava ? TDHelpers.getDropOff((LevelAccessor)level, pos) : this.m_6713_((LevelReader)level));
                cir.setReturnValue((Object)(k <= 0 ? Fluids.f_76191_.m_76145_() : ((FlowingFluid)this).m_75953_(k, false)));
            }
            cir.cancel();
        }
        cir.getReturnValue();
    }

    @Shadow
    protected int m_76026_(LevelReader level, BlockPos spreadPos, int distance, Direction sourceDirection, BlockState currentSpreadState, BlockPos sourcePos, Short2ObjectMap<Pair<BlockState, FluidState>> stateCache, Short2BooleanMap waterHoleCache) {
        return 1000;
    }

    @Shadow
    private static short m_76058_(BlockPos sourcePos, BlockPos spreadPos) {
        return 1;
    }

    @Shadow
    private boolean m_75963_(BlockGetter level, Fluid pFluid, BlockPos pos, BlockState pState, Direction direction, BlockPos spreadPos, BlockState pSpreadState, FluidState fluidState) {
        return true;
    }

    @Shadow
    private boolean m_75956_(BlockGetter level, Fluid pFluid, BlockPos pos, BlockState pState, BlockPos spreadPos, BlockState pSpreadState) {
        return false;
    }

    @Shadow
    private boolean m_76096_(FluidState state) {
        return false;
    }

    @Shadow
    private boolean m_76061_(Direction direction, BlockGetter level, BlockPos pos, BlockState state, BlockPos spreadPos, BlockState spreadState) {
        return false;
    }

    @Shadow
    public abstract Fluid m_5613_();

    @Shadow
    public FluidState m_76068_(boolean falling) {
        return this.m_5613_().m_76145_();
    }

    @Shadow
    public abstract Fluid m_5615_();

    @Shadow
    public FluidState m_75953_(int level, boolean falling) {
        return this.m_5615_().m_76145_();
    }

    @Shadow
    protected abstract int m_6719_(LevelReader var1);

    @Shadow
    protected Map<Direction, FluidState> m_76079_(Level level, BlockPos pos, BlockState state) {
        return Maps.newEnumMap(Direction.class);
    }

    @Shadow
    protected void m_6364_(LevelAccessor level, BlockPos pos, BlockState blockState, Direction direction, FluidState fluidState) {
    }

    @Shadow
    protected abstract int m_6713_(LevelReader var1);

    @Shadow
    protected boolean m_75977_(BlockGetter level, BlockPos pFromPos, BlockState pFromBlockState, Direction pDirection, BlockPos pToPos, BlockState pToBlockState, FluidState pToFluidState, Fluid pFluid) {
        return false;
    }
}

