/*
 * Decompiled with CFR 0.152.
 */
package tfcthermaldeposits.mixin;

import net.dries007.tfc.common.blocks.DirectionPropertyBlock;
import net.dries007.tfc.common.blocks.HotWaterBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tfcthermaldeposits.common.TDTags;
import tfcthermaldeposits.common.blocks.InverseBooleanProperty;
import tfcthermaldeposits.common.blocks.TDBlockStateProperties;
import tfcthermaldeposits.common.blocks.TDBlocks;
import tfcthermaldeposits.common.blocks.rock.Mineral;
import tfcthermaldeposits.common.blocks.rock.MineralSheetBlock;
import tfcthermaldeposits.common.items.TDItems;
import tfcthermaldeposits.config.TDConfig;
import tfcthermaldeposits.util.TDHelpers;

@Mixin(value={HotWaterBlock.class}, priority=1000)
public abstract class HotWaterBlockMixin
extends LiquidBlock {
    @Unique
    private static final IntegerProperty MINERAL_AMOUNT = TDBlockStateProperties.MINERAL_AMOUNT;
    @Unique
    private static final BooleanProperty NATURAL = TDBlockStateProperties.NATURAL;
    @Unique
    private static final InverseBooleanProperty NATURAL_INVERSE = TDBlockStateProperties.NATURAL_INVERSE;

    public HotWaterBlockMixin(FlowingFluid fluid, BlockBehaviour.Properties properties) {
        super(fluid, properties);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void inject$init(CallbackInfo ci) {
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)MINERAL_AMOUNT, (Comparable)Integer.valueOf(0))).m_61124_((Property)NATURAL, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean notPlayer = context.m_43723_() == null;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)NATURAL, (Comparable)Boolean.valueOf(notPlayer))).m_61124_((Property)MINERAL_AMOUNT, (Comparable)Integer.valueOf(notPlayer ? Mth.m_14045_((int)context.m_43725_().m_213780_().m_188503_(10), (int)5, (int)10) : 0));
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (state.m_61138_((Property)NATURAL_INVERSE) && state.m_61138_((Property)NATURAL) && state.m_61138_((Property)MINERAL_AMOUNT)) {
            if (((Boolean)state.m_61143_((Property)NATURAL_INVERSE)).booleanValue()) {
                state.m_61124_((Property)NATURAL, (Comparable)Boolean.valueOf(true));
            }
            if ((Integer)state.m_61143_((Property)MINERAL_AMOUNT) > 0) {
                state.m_61124_((Property)MINERAL_AMOUNT, (Comparable)((Integer)state.m_61143_((Property)MINERAL_AMOUNT)));
            }
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        boolean hasProperties;
        if (state.m_61138_((Property)NATURAL_INVERSE) && ((Boolean)state.m_61143_((Property)NATURAL_INVERSE)).booleanValue()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)NATURAL, (Comparable)Boolean.valueOf(true)));
        }
        boolean bl = hasProperties = state.m_61138_((Property)NATURAL) && state.m_61138_((Property)MINERAL_AMOUNT);
        if (hasProperties) {
            boolean isNatural;
            boolean validDimension = level.m_46472_() == Level.f_46428_ || (Boolean)TDConfig.COMMON.toggleOtherDimensions.get() != false;
            FluidState fluidState = level.m_6425_(pos);
            boolean bl2 = isNatural = hasProperties && (Boolean)state.m_61143_((Property)NATURAL) != false || (Boolean)TDConfig.COMMON.toggleDepositsFromAllLavaOrSpringWater.get() != false;
            if (validDimension && hasProperties && isNatural && fluidState.m_76170_()) {
                Mineral mineral;
                if (((Boolean)TDConfig.COMMON.shouldHotSpringsDepositMinerals.get()).booleanValue() && (Integer)state.m_61143_((Property)MINERAL_AMOUNT) > 0 && random.m_188503_(((Integer)TDConfig.COMMON.mineralGenFrequencyHotSpring.get()).intValue()) == 0 && (mineral = TDHelpers.waterMineral(level, pos, random, TDHelpers.rockTypeMantle(level, pos).displayCategory())) != null) {
                    ItemStack itemMineral = new ItemStack((ItemLike)((Item)TDItems.MINERALS.get((Object)mineral).get()).m_5456_());
                    BlockPos genPos = pos.m_7918_(random.m_188503_(7) - 3, random.m_188503_(7) - 3, random.m_188503_(7) - 3);
                    BlockState stateAt = level.m_8055_(genPos);
                    Direction face = Direction.m_235672_((RandomSource)random);
                    Direction sheetFace = face.m_122424_();
                    BooleanProperty directionProperty = DirectionPropertyBlock.getProperty((Direction)face);
                    BlockPos adjacentPos = genPos.m_121945_(face);
                    BlockState adjacentState = level.m_8055_(adjacentPos);
                    if (Helpers.isBlock((BlockState)stateAt, (Block)((Block)TDBlocks.MINERAL_SHEET.get()))) {
                        if (!((Boolean)stateAt.m_61143_((Property)directionProperty)).booleanValue() && adjacentState.m_60783_((BlockGetter)level, adjacentPos, sheetFace)) {
                            MineralSheetBlock.addSheet((LevelAccessor)level, genPos, stateAt, face, itemMineral);
                            TDHelpers.changeMineralContent(level, state, pos, -1);
                        }
                    } else if (stateAt.m_247087_() && !stateAt.m_278721_() && stateAt.m_284242_((BlockGetter)level, pos) != MapColor.f_283816_ && stateAt.m_284242_((BlockGetter)level, pos) != MapColor.f_283864_ && adjacentState.m_60783_((BlockGetter)level, adjacentPos, sheetFace)) {
                        BlockState placingState = (BlockState)((Block)TDBlocks.MINERAL_SHEET.get()).m_49966_().m_61124_((Property)directionProperty, (Comparable)Boolean.valueOf(true));
                        MineralSheetBlock.addSheet((LevelAccessor)level, genPos, placingState, face, itemMineral);
                        TDHelpers.changeMineralContent(level, state, pos, -1);
                    }
                }
                if (((Boolean)TDConfig.COMMON.naturalReplenishment.get()).booleanValue() && (Integer)state.m_61143_((Property)MINERAL_AMOUNT) < 10 && random.m_188503_((int)Math.ceil((double)Mth.m_14040_((int)((Integer)TDConfig.COMMON.mineralGenFrequencyHotSpring.get() * 6)) * TDHelpers.replenishmentFactor(level, pos))) == 0) {
                    TDHelpers.changeMineralContent(level, state, pos, level.m_213780_().m_188503_(3));
                }
            }
        }
    }

    @Inject(method={"entityInside"}, at={@At(value="TAIL")})
    private void inject$entityInside(BlockState state, Level level, BlockPos pos, Entity entity, CallbackInfo ci) {
        if (state.m_61138_((Property)NATURAL) && state.m_61138_((Property)MINERAL_AMOUNT)) {
            if (entity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)entity;
                if (Helpers.isItem((ItemStack)itemEntity.m_32055_(), TDTags.Items.REPLENISHES_LAVA)) {
                    itemEntity.m_20331_(true);
                    if (level.m_46859_(pos.m_7494_())) {
                        RandomSource random = level.m_213780_();
                        for (int j = 0; j < 1 + itemEntity.m_32055_().m_41613_() + Math.round((float)((Integer)state.m_61143_((Property)MINERAL_AMOUNT)).intValue() * 0.25f); ++j) {
                            double d0 = (double)pos.m_123341_() + 0.5 + random.m_188583_() * 0.15;
                            double d1 = (double)pos.m_123342_() + 1.0;
                            double d2 = (double)pos.m_123343_() + 0.5 + random.m_188583_() * 0.15;
                            SimpleParticleType particle = random.m_188502_() == 0 ? ParticleTypes.f_123772_ : ParticleTypes.f_123769_;
                            level.m_7107_((ParticleOptions)particle, d0, d1, d2, 0.0, 0.01 + random.m_188500_() * 0.01, 0.0);
                        }
                        level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, SoundEvents.f_11773_, SoundSource.BLOCKS, 0.2f + random.m_188501_() * 0.2f, 0.6f + random.m_188501_() * 0.2f, false);
                    }
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        int mineralAmount = (Integer)state.m_61143_((Property)MINERAL_AMOUNT);
                        if (mineralAmount < 10) {
                            int neededAmount;
                            int stackSize = itemEntity.m_32055_().m_41613_();
                            int amountToConsume = stackSize <= (neededAmount = 10 - mineralAmount) ? stackSize : neededAmount;
                            TDHelpers.changeMineralContent(serverLevel, state, pos, amountToConsume);
                            itemEntity.m_32055_().m_41774_(amountToConsume);
                        }
                        serverLevel.m_46597_(pos, (BlockState)state.m_61124_((Property)NATURAL, (Comparable)Boolean.valueOf(true)));
                    }
                    itemEntity.m_20331_(false);
                }
            } else if (entity instanceof ThrowableItemProjectile) {
                ThrowableItemProjectile throwableObject = (ThrowableItemProjectile)entity;
                if (level.m_46859_(pos.m_7494_())) {
                    RandomSource random = level.m_213780_();
                    for (int j = 0; j < 6 + Math.round((float)((Integer)state.m_61143_((Property)MINERAL_AMOUNT)).intValue() * 0.25f); ++j) {
                        double d0 = (double)pos.m_123341_() + 0.5 + random.m_188583_() * 0.15;
                        double d1 = (double)pos.m_123342_() + 1.0;
                        double d2 = (double)pos.m_123343_() + 0.5 + random.m_188583_() * 0.15;
                        SimpleParticleType particle = random.m_188502_() == 0 ? ParticleTypes.f_123772_ : ParticleTypes.f_123769_;
                        level.m_7107_((ParticleOptions)particle, d0, d1, d2, 0.0, 0.01 + random.m_188500_() * 0.05, 0.0);
                    }
                    level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, SoundEvents.f_11773_, SoundSource.BLOCKS, 0.3f + random.m_188501_() * 0.3f, 0.6f + random.m_188501_() * 0.2f, false);
                }
                if (Helpers.isItem((ItemStack)throwableObject.m_7846_(), TDTags.Items.REPLENISHES_LAVA) && level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    int mineralAmount = (Integer)state.m_61143_((Property)MINERAL_AMOUNT);
                    if (mineralAmount < 10) {
                        int neededAmount = 10 - mineralAmount;
                        int amountToConsume = 1 <= neededAmount ? 1 : neededAmount;
                        TDHelpers.changeMineralContent(serverLevel, state, pos, amountToConsume);
                        throwableObject.m_7846_().m_41774_(amountToConsume);
                    }
                    serverLevel.m_46597_(pos, (BlockState)state.m_61124_((Property)NATURAL, (Comparable)Boolean.valueOf(true)));
                }
            }
        }
    }
}

