/*
 * Decompiled with CFR 0.152.
 */
package tfcthermaldeposits.mixin;

import net.dries007.tfc.common.blocks.rock.RockDisplayCategory;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.world.biome.TFCBiomes;
import net.dries007.tfc.world.biome.VolcanoNoise;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.LavaFluid;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tfcthermaldeposits.client.particle.TDParticles;
import tfcthermaldeposits.common.blocks.TDBlockStateProperties;
import tfcthermaldeposits.config.TDConfig;
import tfcthermaldeposits.util.TDHelpers;

@Mixin(value={LavaFluid.class}, priority=1000)
public abstract class LavaFluidMixin
extends FlowingFluid {
    @Inject(method={"animateTick"}, at={@At(value="TAIL")})
    private void inject$animateTick(Level level, BlockPos pos, FluidState state, RandomSource random, CallbackInfo ci) {
        if (((Boolean)TDConfig.COMMON.shouldLavaSmoke.get()).booleanValue()) {
            RandomSource seededRandom = TDHelpers.seededRandom(pos);
            BlockState blockState = level.m_8055_(pos);
            double timeNoise = TDHelpers.volcanicRumbleNoise(level, level.m_46472_() == Level.f_46429_ ? true : (Boolean)TDConfig.COMMON.highTremorFrequency.get());
            if (level.m_46859_(pos.m_7494_()) && blockState.m_61138_((Property)TDBlockStateProperties.MINERAL_AMOUNT) && ((Integer)blockState.m_61143_((Property)TDBlockStateProperties.MINERAL_AMOUNT) > 0 || ((Boolean)TDConfig.COMMON.toggleDepositsFromAllLavaOrSpringWater.get()).booleanValue()) && (double)random.m_188503_(Mth.m_14045_((int)((Integer)TDConfig.COMMON.mineralGenFrequencyLava.get() * 2), (int)16, (int)48)) <= timeNoise * (double)0.05f) {
                double volcanoNoise = 1.0;
                RockDisplayCategory category = RockDisplayCategory.METAMORPHIC;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    category = TDHelpers.rockTypeMantle(serverLevel, pos).displayCategory();
                    if (TFCBiomes.hasExtension((CommonLevelAccessor)serverLevel, (Biome)((Biome)serverLevel.m_204166_(pos).m_203334_()))) {
                        volcanoNoise = new VolcanoNoise(serverLevel.m_7328_()).calculateEasing(pos.m_123341_(), pos.m_123343_(), TFCBiomes.getExtension((CommonLevelAccessor)serverLevel, (Biome)((Biome)serverLevel.m_204166_(pos).m_203334_())).getVolcanoRarity());
                    }
                }
                TDHelpers.spawnSmoke(level, pos, state, random, category);
                int j = 0;
                while ((double)j < Math.floor(timeNoise * (double)0.1f)) {
                    double d0 = (double)pos.m_123341_() + 0.5 + random.m_188583_() * 0.15;
                    double d1 = (double)pos.m_123342_() + 1.0;
                    double d2 = (double)pos.m_123343_() + 0.5 + random.m_188583_() * 0.15;
                    level.m_7107_((ParticleOptions)ParticleTypes.f_123756_, d0, d1, d2, 0.0, 0.001 + random.m_188500_() * 0.001, 0.0);
                    ++j;
                }
                level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, SoundEvents.f_12032_, SoundSource.BLOCKS, 0.2f + random.m_188501_() * 0.2f, 0.6f + random.m_188501_() * 0.2f, false);
                double rockTypeFactor = TDHelpers.getIntensityFactor((LevelAccessor)level, pos);
                double extraFactor = TDHelpers.replenishmentFactor(level, pos) * 3.5;
                if (volcanoNoise > 0.9 && timeNoise >= 155.0 + (double)seededRandom.m_188503_(8) * rockTypeFactor && seededRandom.m_188500_() * (timeNoise * (double)0.015f) * extraFactor >= rockTypeFactor && random.m_188503_(10) == 0) {
                    level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11892_, SoundSource.AMBIENT, 4.0f, (0.4f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.2f) * 0.7f, false);
                    level.m_7106_((ParticleOptions)TDParticles.PYROCLASTIC_BOMB_EMITTER.get(), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 1.0, 0.0, 0.0);
                }
            }
            if (level.m_46472_() == Level.f_46429_ && state.m_76170_() && ((Boolean)TDConfig.COMMON.togglePyroclasticBombs.get()).booleanValue() && ((Boolean)TDConfig.COMMON.toggleNetherTremor.get()).booleanValue() && timeNoise >= 170.0 + (double)seededRandom.m_188503_(50) && TDHelpers.wideNise(Calendars.get((LevelReader)level).getTotalYears(), 63, 160).noise((double)pos.m_123341_(), (double)pos.m_123343_()) > 120.0) {
                boolean acceptableLocation = false;
                boolean primaryBombSpawned = false;
                boolean extraBombsSpawned = false;
                if (seededRandom.m_188503_(400) == 0) {
                    for (int i = 0; i < 1 + seededRandom.m_188503_(3); ++i) {
                        if (!((double)seededRandom.m_188503_(500) <= timeNoise * 0.5)) continue;
                        for (Direction direction : Direction.Plane.HORIZONTAL) {
                            for (int distance = 0; distance <= 6; ++distance) {
                                acceptableLocation = (level.m_6425_(pos.m_5484_(direction, distance)).m_76152_() instanceof LavaFluid || level.m_8055_(pos.m_5484_(direction, distance)).m_60734_() == Blocks.f_49991_) && level.m_46859_(pos.m_5484_(direction, distance).m_7494_());
                            }
                        }
                        if (!acceptableLocation) continue;
                        if (!primaryBombSpawned) {
                            level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11895_, SoundSource.AMBIENT, 1.0f + random.m_188501_(), 0.8f + random.m_188501_() * 0.3f, true);
                            level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11892_, SoundSource.AMBIENT, 1.0f + random.m_188501_(), 1.0f + random.m_188501_() * 0.3f, true);
                            primaryBombSpawned = true;
                        }
                        if (extraBombsSpawned) continue;
                        for (int j = 0; j < 9 + seededRandom.m_188503_(16); ++j) {
                            double x = (double)pos.m_123341_() - 0.5 + random.m_188583_() * 2.0;
                            double y = (double)pos.m_123342_() - 0.9 + random.m_188583_() * 0.2;
                            double z = (double)pos.m_123343_() - 0.5 + random.m_188583_() * 2.0;
                            level.m_7785_(x, y, z, SoundEvents.f_11892_, SoundSource.AMBIENT, 4.0f, (0.4f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.2f) * 0.7f, false);
                            level.m_7106_((ParticleOptions)TDParticles.PYROCLASTIC_BOMB_EMITTER.get(), x, y, z, 1.0, 0.0, 0.0);
                        }
                    }
                }
            }
        }
    }

    @Inject(method={"getSpreadDelay"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject$getSpreadDelay(Level level, BlockPos pos, FluidState currentState, FluidState newState, CallbackInfoReturnable<Integer> cir) {
        int i = TDHelpers.getTickDelay((LevelAccessor)level, pos);
        if (!(currentState.m_76178_() || newState.m_76178_() || ((Boolean)currentState.m_61143_((Property)f_75947_)).booleanValue() || ((Boolean)newState.m_61143_((Property)f_75947_)).booleanValue() || !(newState.m_76155_((BlockGetter)level, pos) > currentState.m_76155_((BlockGetter)level, pos)) || level.m_213780_().m_188503_(4) == 0)) {
            i *= 4;
        }
        cir.setReturnValue((Object)i);
    }
}

