/*
 * Decompiled with CFR 0.152.
 */
package tfcthermaldeposits.util;

import java.util.Map;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.common.blocks.rock.RockDisplayCategory;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendar;
import net.dries007.tfc.util.registry.RegistryRock;
import net.dries007.tfc.world.TFCChunkGenerator;
import net.dries007.tfc.world.chunkdata.ChunkDataProvider;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.noise.OpenSimplex2D;
import net.dries007.tfc.world.settings.RockSettings;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import tfcthermaldeposits.common.blocks.TDBlockStateProperties;
import tfcthermaldeposits.common.blocks.rock.Mineral;
import tfcthermaldeposits.config.TDConfig;

public class TDHelpers {
    public static final IntegerProperty MINERAL_AMOUNT = TDBlockStateProperties.MINERAL_AMOUNT;
    public static final RegistryRock DEFAULT_ROCK = Rock.ANDESITE;

    public static ResourceLocation identifier(String name) {
        return new ResourceLocation("tfcthermaldeposits", name);
    }

    public static ModelLayerLocation modelIdentifier(String name, String part) {
        return new ModelLayerLocation(TDHelpers.identifier(name), part);
    }

    public static ModelLayerLocation modelIdentifier(String name) {
        return TDHelpers.modelIdentifier(name, "main");
    }

    public static boolean isBiome(Biome biome, TagKey<Biome> tag) {
        return Helpers.checkTag((IForgeRegistry)ForgeRegistries.BIOMES, (Object)biome, tag);
    }

    public static RegistryRock rockTypeIgneous(ServerLevel level, BlockPos pos) {
        ChunkGenerator chunkGenerator = level.m_7726_().m_8481_();
        if (chunkGenerator instanceof TFCChunkGenerator) {
            TFCChunkGenerator chunkGen = (TFCChunkGenerator)chunkGenerator;
            chunkGen.chunkDataProvider();
            RockSettings localRock = ChunkDataProvider.get((WorldGenLevel)level).get((WorldGenLevel)level, pos).getRockData().getRock(pos);
            Block block = localRock.raw();
            if (block instanceof RegistryRock) {
                RegistryRock rock = (RegistryRock)block;
                if (localRock.raw().equals(rock.getBlock(Rock.BlockType.RAW).get())) {
                    return TDHelpers.convertToIgneous(rock);
                }
            }
            return TDHelpers.convertToIgneous(TDHelpers.rockLoopCheck(localRock));
        }
        return DEFAULT_ROCK;
    }

    public static RegistryRock rockTypeIgneous(LevelAccessor reader, BlockPos pos) {
        ServerLevel level;
        ChunkGenerator chunkGenerator;
        if (reader instanceof ServerLevel && (chunkGenerator = (level = (ServerLevel)reader).m_7726_().m_8481_()) instanceof TFCChunkGenerator) {
            TFCChunkGenerator chunkGen = (TFCChunkGenerator)chunkGenerator;
            chunkGen.chunkDataProvider();
            RockSettings localRock = ChunkDataProvider.get((WorldGenLevel)level).get((WorldGenLevel)level, pos).getRockData().getRock(pos);
            Block block = localRock.raw();
            if (block instanceof RegistryRock) {
                RegistryRock rock = (RegistryRock)block;
                if (localRock.raw().equals(rock.getBlock(Rock.BlockType.RAW).get())) {
                    return TDHelpers.convertToIgneous(rock);
                }
            }
            return TDHelpers.convertToIgneous(TDHelpers.rockLoopCheck(localRock));
        }
        return DEFAULT_ROCK;
    }

    public static RegistryRock rockType(ServerLevel level, BlockPos pos) {
        ChunkGenerator chunkGenerator = level.m_7726_().m_8481_();
        if (chunkGenerator instanceof TFCChunkGenerator) {
            TFCChunkGenerator chunkGen = (TFCChunkGenerator)chunkGenerator;
            chunkGen.chunkDataProvider();
            RockSettings localRock = ChunkDataProvider.get((WorldGenLevel)level).get((WorldGenLevel)level, pos).getRockData().getRock(pos);
            Block block = localRock.raw();
            if (block instanceof RegistryRock) {
                RegistryRock rock = (RegistryRock)block;
                if (localRock.raw().equals(rock.getBlock(Rock.BlockType.RAW).get())) {
                    return rock;
                }
            }
            return TDHelpers.rockLoopCheck(localRock);
        }
        return DEFAULT_ROCK;
    }

    public static RegistryRock rockType(LevelAccessor reader, BlockPos pos) {
        ServerLevel level;
        ChunkGenerator chunkGenerator;
        if (reader instanceof ServerLevel && (chunkGenerator = (level = (ServerLevel)reader).m_7726_().m_8481_()) instanceof TFCChunkGenerator) {
            TFCChunkGenerator chunkGen = (TFCChunkGenerator)chunkGenerator;
            chunkGen.chunkDataProvider();
            RockSettings localRock = ChunkDataProvider.get((WorldGenLevel)level).get((WorldGenLevel)level, pos).getRockData().getRock(pos);
            Block block = localRock.raw();
            if (block instanceof RegistryRock) {
                RegistryRock rock = (RegistryRock)block;
                if (localRock.raw().equals(rock.getBlock(Rock.BlockType.RAW).get())) {
                    return rock;
                }
            }
            return TDHelpers.rockLoopCheck(localRock);
        }
        return DEFAULT_ROCK;
    }

    public static RegistryRock rockTypeMantle(ServerLevel level, BlockPos pos) {
        ChunkGenerator chunkGenerator = level.m_7726_().m_8481_();
        if (chunkGenerator instanceof TFCChunkGenerator) {
            TFCChunkGenerator chunkGen = (TFCChunkGenerator)chunkGenerator;
            int minY = level.m_141937_() + 8;
            BlockPos lowestPos = new BlockPos(pos.m_123341_(), minY, pos.m_123343_());
            chunkGen.chunkDataProvider();
            RockSettings localRock = ChunkDataProvider.get((WorldGenLevel)level).get((WorldGenLevel)level, lowestPos).getRockData().getRock(lowestPos);
            Block block = localRock.raw();
            if (block instanceof RegistryRock) {
                RegistryRock rock = (RegistryRock)block;
                if (localRock.raw().equals(rock.getBlock(Rock.BlockType.RAW).get())) {
                    return rock;
                }
            }
            return TDHelpers.rockLoopCheck(localRock);
        }
        return DEFAULT_ROCK;
    }

    public static RegistryRock rockTypeMantle(LevelAccessor reader, BlockPos pos) {
        ServerLevel level;
        ChunkGenerator chunkGenerator;
        if (reader instanceof ServerLevel && (chunkGenerator = (level = (ServerLevel)reader).m_7726_().m_8481_()) instanceof TFCChunkGenerator) {
            TFCChunkGenerator chunkGen = (TFCChunkGenerator)chunkGenerator;
            int minY = level.m_141937_() + 8;
            BlockPos lowestPos = new BlockPos(pos.m_123341_(), minY, pos.m_123343_());
            chunkGen.chunkDataProvider();
            RockSettings localRock = ChunkDataProvider.get((WorldGenLevel)level).get((WorldGenLevel)level, lowestPos).getRockData().getRock(lowestPos);
            Block block = localRock.raw();
            if (block instanceof RegistryRock) {
                RegistryRock rock = (RegistryRock)block;
                if (localRock.raw().equals(rock.getBlock(Rock.BlockType.RAW).get())) {
                    return rock;
                }
            }
            return TDHelpers.rockLoopCheck(localRock);
        }
        return DEFAULT_ROCK;
    }

    public static RegistryRock rockLoopCheck(RockSettings localRock) {
        for (Rock rock : Rock.values()) {
            if (localRock.raw() != ((RegistryObject)((Map)TFCBlocks.ROCK_BLOCKS.get(rock)).get(Rock.BlockType.RAW)).get()) continue;
            return rock;
        }
        return DEFAULT_ROCK;
    }

    public static double replenishmentFactor(Level level, BlockPos pos) {
        switch (TDHelpers.rockTypeMantle((LevelAccessor)level, pos).displayCategory()) {
            case FELSIC_IGNEOUS_EXTRUSIVE: 
            case FELSIC_IGNEOUS_INTRUSIVE: {
                return (Double)TDConfig.COMMON.replenishmentFactorFelsic.get();
            }
            case INTERMEDIATE_IGNEOUS_EXTRUSIVE: 
            case INTERMEDIATE_IGNEOUS_INTRUSIVE: {
                return (Double)TDConfig.COMMON.replenishmentFactorIntermediate.get();
            }
            case MAFIC_IGNEOUS_EXTRUSIVE: 
            case MAFIC_IGNEOUS_INTRUSIVE: {
                return (Double)TDConfig.COMMON.replenishmentFactorMafic.get();
            }
            case METAMORPHIC: {
                return (Double)TDConfig.COMMON.replenishmentFactorMetamorphic.get();
            }
            case SEDIMENTARY: {
                return (Double)TDConfig.COMMON.replenishmentFactorSedimentary.get();
            }
        }
        return 1.0;
    }

    public static double replenishmentFactor(ServerLevel level, BlockPos pos) {
        switch (TDHelpers.rockTypeMantle(level, pos).displayCategory()) {
            case FELSIC_IGNEOUS_EXTRUSIVE: 
            case FELSIC_IGNEOUS_INTRUSIVE: {
                return (Double)TDConfig.COMMON.replenishmentFactorFelsic.get();
            }
            case INTERMEDIATE_IGNEOUS_EXTRUSIVE: 
            case INTERMEDIATE_IGNEOUS_INTRUSIVE: {
                return (Double)TDConfig.COMMON.replenishmentFactorIntermediate.get();
            }
            case MAFIC_IGNEOUS_EXTRUSIVE: 
            case MAFIC_IGNEOUS_INTRUSIVE: {
                return (Double)TDConfig.COMMON.replenishmentFactorMafic.get();
            }
            case METAMORPHIC: {
                return (Double)TDConfig.COMMON.replenishmentFactorMetamorphic.get();
            }
            case SEDIMENTARY: {
                return (Double)TDConfig.COMMON.replenishmentFactorSedimentary.get();
            }
        }
        return 1.0;
    }

    public static void changeMineralContent(ServerLevel level, BlockState state, BlockPos pos, int amount) {
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)MINERAL_AMOUNT, (Comparable)Integer.valueOf(Mth.m_14045_((int)((Integer)state.m_61143_((Property)MINERAL_AMOUNT) + amount), (int)0, (int)10))));
    }

    public static Noise2D wideNise(long seed, int minHeight, int maxHeight) {
        return new OpenSimplex2D(seed).octaves(2).spread((double)0.05f).scaled((double)(63 + minHeight), (double)(63 + maxHeight));
    }

    public static Mineral waterMineral(ServerLevel level, BlockPos pos, RandomSource random, RockDisplayCategory category) {
        if (TDHelpers.wideNise(level.m_7328_() + 10L, 63, 140).noise((double)pos.m_123341_(), (double)pos.m_123343_()) > 100.0) {
            switch (category) {
                case MAFIC_IGNEOUS_EXTRUSIVE: 
                case MAFIC_IGNEOUS_INTRUSIVE: {
                    return Mineral.SALMIAK;
                }
                case INTERMEDIATE_IGNEOUS_EXTRUSIVE: 
                case INTERMEDIATE_IGNEOUS_INTRUSIVE: {
                    return Mineral.SALTPETER;
                }
                case FELSIC_IGNEOUS_EXTRUSIVE: 
                case FELSIC_IGNEOUS_INTRUSIVE: {
                    return Mineral.CALCITE;
                }
            }
            return Mineral.SALT;
        }
        return null;
    }

    public static Mineral lavaMineral(ServerLevel level, BlockPos pos, RandomSource random, RockDisplayCategory category) {
        double variantNoiseValue = TDHelpers.wideNise(level.m_7328_() + 10L, 63, 140).noise((double)pos.m_123341_(), (double)pos.m_123343_());
        if (variantNoiseValue >= 110.0) {
            switch (category) {
                case FELSIC_IGNEOUS_EXTRUSIVE: 
                case FELSIC_IGNEOUS_INTRUSIVE: {
                    return Mineral.SMITHSONITE;
                }
                case INTERMEDIATE_IGNEOUS_EXTRUSIVE: 
                case INTERMEDIATE_IGNEOUS_INTRUSIVE: {
                    return Mineral.GREIGITE;
                }
                case MAFIC_IGNEOUS_EXTRUSIVE: 
                case MAFIC_IGNEOUS_INTRUSIVE: {
                    return Mineral.MAGNESITE;
                }
                case METAMORPHIC: {
                    return Mineral.BASTNASITE;
                }
            }
            return Mineral.BRIMSTONE;
        }
        if (variantNoiseValue <= 90.0) {
            switch (category) {
                case FELSIC_IGNEOUS_INTRUSIVE: 
                case INTERMEDIATE_IGNEOUS_INTRUSIVE: {
                    return Mineral.ALABANDITE;
                }
                case MAFIC_IGNEOUS_INTRUSIVE: 
                case METAMORPHIC: {
                    return Mineral.GREIGITE;
                }
                case MAFIC_IGNEOUS_EXTRUSIVE: {
                    return Mineral.ZABUYELITE;
                }
                case FELSIC_IGNEOUS_EXTRUSIVE: 
                case INTERMEDIATE_IGNEOUS_EXTRUSIVE: {
                    return Mineral.SPHEROCOBALTITE;
                }
            }
            return Mineral.BRIMSTONE;
        }
        switch (category) {
            case FELSIC_IGNEOUS_INTRUSIVE: 
            case INTERMEDIATE_IGNEOUS_INTRUSIVE: 
            case MAFIC_IGNEOUS_INTRUSIVE: {
                return Mineral.APATITE;
            }
        }
        return Mineral.BRIMSTONE;
    }

    public static void spawnSmoke(Level level, BlockPos pos, FluidState state, RandomSource random, RockDisplayCategory category) {
        int i;
        int smokeLevel = 3;
        switch (category) {
            case FELSIC_IGNEOUS_EXTRUSIVE: 
            case FELSIC_IGNEOUS_INTRUSIVE: {
                smokeLevel = 4;
            }
            case INTERMEDIATE_IGNEOUS_EXTRUSIVE: 
            case INTERMEDIATE_IGNEOUS_INTRUSIVE: {
                smokeLevel = 3;
            }
            case MAFIC_IGNEOUS_EXTRUSIVE: 
            case MAFIC_IGNEOUS_INTRUSIVE: {
                smokeLevel = 0;
            }
        }
        smokeLevel = 2;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.0;
        double z = (double)pos.m_123343_() + 0.5;
        int smoke = level.m_45527_(pos) ? smokeLevel + 1 : smokeLevel + 0;
        level.m_7785_(x, y, z, SoundEvents.f_12032_, SoundSource.BLOCKS, 0.5f + random.m_188501_(), random.m_188501_() * 0.7f + 0.6f, false);
        for (i = 0; i < 1 + random.m_188503_(3); ++i) {
            level.m_7107_((ParticleOptions)((RegistryObject)TFCParticles.SMOKES.get(Mth.m_14045_((int)smoke, (int)0, (int)4))).get(), x + (double)(Helpers.triangle((RandomSource)random) * 0.5f), y + random.m_188500_(), z + (double)(Helpers.triangle((RandomSource)random) * 0.5f), 0.0, 0.07, 0.0);
        }
        for (i = 0; i < random.m_188503_(4 + smoke); ++i) {
            level.m_7107_((ParticleOptions)ParticleTypes.f_123762_, x + (double)(Helpers.triangle((RandomSource)random) * 0.5f), y + random.m_188500_(), z + (double)(Helpers.triangle((RandomSource)random) * 0.5f), 0.0, 0.005, 0.0);
        }
        if (random.m_188503_(6 - smoke) <= 1) {
            level.m_7107_((ParticleOptions)ParticleTypes.f_123755_, x + (double)(Helpers.triangle((RandomSource)random) * 0.5f), y + random.m_188500_(), z + (double)(Helpers.triangle((RandomSource)random) * 0.5f), 0.0, 0.005, 0.0);
        }
    }

    public static int getSlopeFindDistance(LevelAccessor level, BlockPos pos) {
        if (!level.m_6042_().f_63857_() && pos != null) {
            switch (TDHelpers.rockTypeMantle(level, pos).displayCategory()) {
                case FELSIC_IGNEOUS_EXTRUSIVE: 
                case FELSIC_IGNEOUS_INTRUSIVE: {
                    return (Integer)TDConfig.COMMON.slopeDistanceFelsic.get();
                }
                case METAMORPHIC: {
                    return (Integer)TDConfig.COMMON.slopeDistanceMetamorphic.get();
                }
                case SEDIMENTARY: {
                    return (Integer)TDConfig.COMMON.slopeDistanceSedimentary.get();
                }
                case INTERMEDIATE_IGNEOUS_EXTRUSIVE: 
                case INTERMEDIATE_IGNEOUS_INTRUSIVE: {
                    return (Integer)TDConfig.COMMON.slopeDistanceIntermediate.get();
                }
                case MAFIC_IGNEOUS_EXTRUSIVE: 
                case MAFIC_IGNEOUS_INTRUSIVE: {
                    return (Integer)TDConfig.COMMON.slopeDistanceMafic.get();
                }
            }
            return 2;
        }
        return level.m_6042_().f_63857_() ? 4 : 2;
    }

    public static int getDropOff(LevelAccessor level, BlockPos pos) {
        if (!level.m_6042_().f_63857_() && pos != null) {
            switch (TDHelpers.rockTypeMantle(level, pos).displayCategory()) {
                case FELSIC_IGNEOUS_EXTRUSIVE: 
                case FELSIC_IGNEOUS_INTRUSIVE: {
                    return (Integer)TDConfig.COMMON.dropOffFelsic.get();
                }
                case METAMORPHIC: {
                    return (Integer)TDConfig.COMMON.dropOffMetamorphic.get();
                }
                case SEDIMENTARY: {
                    return (Integer)TDConfig.COMMON.dropOffSedimentary.get();
                }
                case INTERMEDIATE_IGNEOUS_EXTRUSIVE: 
                case INTERMEDIATE_IGNEOUS_INTRUSIVE: {
                    return (Integer)TDConfig.COMMON.dropOffIntermediate.get();
                }
                case MAFIC_IGNEOUS_EXTRUSIVE: 
                case MAFIC_IGNEOUS_INTRUSIVE: {
                    return (Integer)TDConfig.COMMON.dropOffMafic.get();
                }
            }
            return 2;
        }
        return level.m_6042_().f_63857_() ? 1 : 2;
    }

    public static int getTickDelay(LevelAccessor level, BlockPos pos) {
        if (!level.m_6042_().f_63857_() && pos != null) {
            switch (TDHelpers.rockTypeMantle(level, pos).displayCategory()) {
                case FELSIC_IGNEOUS_EXTRUSIVE: 
                case FELSIC_IGNEOUS_INTRUSIVE: {
                    return (Integer)TDConfig.COMMON.tickDelayFelsic.get();
                }
                case METAMORPHIC: {
                    return (Integer)TDConfig.COMMON.tickDelayMetamorphic.get();
                }
                case SEDIMENTARY: {
                    return (Integer)TDConfig.COMMON.tickDelaySedimentary.get();
                }
                case INTERMEDIATE_IGNEOUS_EXTRUSIVE: 
                case INTERMEDIATE_IGNEOUS_INTRUSIVE: {
                    return (Integer)TDConfig.COMMON.tickDelayIntermediate.get();
                }
                case MAFIC_IGNEOUS_EXTRUSIVE: 
                case MAFIC_IGNEOUS_INTRUSIVE: {
                    return (Integer)TDConfig.COMMON.tickDelayMafic.get();
                }
            }
            return 30;
        }
        return level.m_6042_().f_63857_() ? 10 : 30;
    }

    public static RegistryRock convertToIgneous(RegistryRock rock) {
        if (rock.displayCategory() == RockDisplayCategory.SEDIMENTARY) {
            if (rock == Rock.SHALE || rock == Rock.CLAYSTONE) {
                return Rock.SLATE;
            }
            if (rock == Rock.LIMESTONE || rock == Rock.DOLOMITE || rock == Rock.CHALK) {
                return Rock.MARBLE;
            }
            if (rock == Rock.CONGLOMERATE) {
                return Rock.GNEISS;
            }
            return Rock.QUARTZITE;
        }
        return rock;
    }

    public static double getIntensityFactor(LevelAccessor level, BlockPos pos) {
        switch (TDHelpers.rockTypeMantle(level, pos).displayCategory()) {
            case MAFIC_IGNEOUS_EXTRUSIVE: 
            case MAFIC_IGNEOUS_INTRUSIVE: {
                return (Double)TDConfig.COMMON.maficVolcanoIntensityFactor.get();
            }
            case INTERMEDIATE_IGNEOUS_EXTRUSIVE: 
            case INTERMEDIATE_IGNEOUS_INTRUSIVE: {
                return (Double)TDConfig.COMMON.intermediateVolcanoIntensityFactor.get();
            }
            case FELSIC_IGNEOUS_EXTRUSIVE: 
            case FELSIC_IGNEOUS_INTRUSIVE: {
                return (Double)TDConfig.COMMON.felsicVolcanoIntensityFactor.get();
            }
            case METAMORPHIC: {
                return (Double)TDConfig.COMMON.metamorphicVolcanoIntensityFactor.get();
            }
            case SEDIMENTARY: {
                return (Double)TDConfig.COMMON.sedimentaryVolcanoIntensityFactor.get();
            }
        }
        return 1.0;
    }

    public static double volcanicRumbleNoise(Level level, boolean frequency) {
        ICalendar calendar = Calendars.get((LevelReader)level);
        float spread = frequency ? 1.0E-5f : 1.0E-6f;
        double noiseValue = new OpenSimplex2D(calendar.getTotalYears()).add(new OpenSimplex2D(calendar.getTotalYears() + 1L).octaves(1).spread((double)spread).ridged().map(x -> 2.0 * -(x >= 0.0 ? x * x * x : Math.pow(x, 50.0))).scaled(-1.0, 0.0, -1.0, 2.0).terraces(15).scaled(63.0, -63.0)).map(x -> x < 63.0 ? 63.0 - (double)0.3f * (63.0 - x) : x).noise((double)calendar.getCalendarDayOfMonth(), (double)calendar.getCalendarTicks());
        return TDHelpers.convertExponential(noiseValue, frequency);
    }

    public static double convertExponential(double value, boolean frequency) {
        if (frequency) {
            return Mth.m_14036_((float)((float)(Math.pow(1.022f, value + 4.0) - 3.0)), (float)0.0f, (float)250.0f);
        }
        return Mth.m_14036_((float)((float)(Math.pow(1.2f, value - 220.0) - 0.25)), (float)0.0f, (float)250.0f);
    }

    public static RandomSource seededRandom(Level level) {
        return RandomSource.m_216335_((long)Calendars.get((LevelReader)level).getCalendarDayTime());
    }

    public static RandomSource seededRandom(BlockPos pos) {
        return RandomSource.m_216335_((long)(pos.m_123341_() * pos.m_123343_()));
    }

    public static boolean isIgneous(LevelAccessor level, BlockPos pos) {
        switch (TDHelpers.rockTypeMantle(level, pos).displayCategory()) {
            case FELSIC_IGNEOUS_EXTRUSIVE: 
            case FELSIC_IGNEOUS_INTRUSIVE: 
            case INTERMEDIATE_IGNEOUS_EXTRUSIVE: 
            case INTERMEDIATE_IGNEOUS_INTRUSIVE: 
            case MAFIC_IGNEOUS_EXTRUSIVE: 
            case MAFIC_IGNEOUS_INTRUSIVE: {
                return true;
            }
        }
        return false;
    }
}

