/*
 * Decompiled with CFR 0.152.
 */
package com.imjustdoom.doomsmarkers.mixin;

import com.imjustdoom.doomsmarkers.DoomsMarkers;
import com.imjustdoom.doomsmarkers.Marker;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapBanner;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerGamePacketListenerImpl.class})
public abstract class ServerPacketListenerMixin {
    @Shadow
    public abstract ServerPlayer m_142253_();

    @Inject(method={"handleCustomPayload"}, at={@At(value="HEAD")}, cancellable=true)
    public void handleMyPackets(ServerboundCustomPayloadPacket packet, CallbackInfo ci) {
        ResourceLocation location = packet.m_179589_();
        if (!location.m_135827_().equals("doomsmarkers")) {
            return;
        }
        if (!DoomsMarkers.MARKERS.containsKey(this.m_142253_())) {
            DoomsMarkers.MARKERS.put(this.m_142253_(), new ArrayList());
        }
        block6 : switch (location.m_135815_()) {
            case "add": {
                if (DoomsMarkers.MARKERS.get(this.m_142253_()).size() >= 50) {
                    this.m_142253_().m_213846_((Component)Component.m_237113_((String)"You are at the max of 50 markers :(").m_130940_(ChatFormatting.RED));
                    break;
                }
                CompoundTag wrapper = packet.m_179590_().m_130260_();
                if (wrapper == null || !wrapper.m_128425_("data", 10)) break;
                CompoundTag compoundTag = wrapper.m_128469_("data");
                Marker loaded = (Marker)Marker.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)compoundTag).getOrThrow(false, err -> System.err.println("Failed to parse markers: " + err));
                DoomsMarkers.MARKERS.get(this.m_142253_()).add(loaded);
                DoomsMarkers.sendMarkerToPlayer(this.m_142253_(), loaded);
                break;
            }
            case "calculate_map": {
                ArrayList<Float> colour;
                ItemStack itemStack = this.m_142253_().m_21120_(this.m_142253_().m_7655_());
                if (itemStack.m_41720_() != Items.f_42573_) {
                    this.m_142253_().m_213846_((Component)Component.m_237113_((String)"Unable to detect map item").m_130940_(ChatFormatting.RED));
                    break;
                }
                MapItemSavedData data = MapItem.m_42853_((ItemStack)itemStack, (Level)this.m_142253_().m_9236_());
                if (data == null) {
                    System.out.println("No data to fetch");
                    return;
                }
                for (MapBanner banner : data.m_164809_()) {
                    if (DoomsMarkers.MARKERS.get(this.m_142253_()).size() >= 50) {
                        this.m_142253_().m_213846_((Component)Component.m_237113_((String)"You are at the max of 50 markers :(").m_130940_(ChatFormatting.RED));
                        break block6;
                    }
                    colour = new ArrayList<Float>();
                    for (float value : DoomsMarkers.argbIntToFloatArray(banner.m_164759_().m_41071_())) {
                        colour.add(Float.valueOf(value));
                    }
                    Marker marker = new Marker(new Vec3((double)banner.m_77773_().m_123341_(), (double)((float)banner.m_77773_().m_123342_() + 0.75f), (double)banner.m_77773_().m_123343_()), colour, 2);
                    DoomsMarkers.MARKERS.get(this.m_142253_()).add(marker);
                    DoomsMarkers.sendMarkerToPlayer(this.m_142253_(), marker);
                }
                for (MapDecoration decoration : data.m_164811_()) {
                    if (DoomsMarkers.MARKERS.get(this.m_142253_()).size() >= 50) {
                        this.m_142253_().m_213846_((Component)Component.m_237113_((String)"You are at the max of 50 markers :(").m_130940_(ChatFormatting.RED));
                        break block6;
                    }
                    if (decoration.m_77803_() != MapDecoration.Type.RED_X && decoration.m_77803_() != MapDecoration.Type.MONUMENT && decoration.m_77803_() != MapDecoration.Type.MANSION && decoration.m_77803_() != MapDecoration.Type.TARGET_POINT && decoration.m_77803_() != MapDecoration.Type.TARGET_X && decoration.m_77803_() != MapDecoration.Type.BLUE_MARKER && decoration.m_77803_() != MapDecoration.Type.RED_MARKER && decoration.m_77803_() != MapDecoration.Type.PLAYER) continue;
                    if (decoration.m_77803_().m_77857_()) {
                        colour = new ArrayList();
                        for (float value : DoomsMarkers.argbIntToFloatArray(decoration.m_77803_().m_77858_())) {
                            colour.add(Float.valueOf(value));
                        }
                    } else {
                        colour = List.of(Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f));
                    }
                    Marker marker = new Marker(DoomsMarkers.getWorldPosFromDecoration(data, decoration), colour, 2);
                    DoomsMarkers.MARKERS.get(this.m_142253_()).add(marker);
                    DoomsMarkers.sendMarkerToPlayer(this.m_142253_(), marker);
                }
                break;
            }
            case "delete": {
                CompoundTag wrapper = packet.m_179590_().m_130260_();
                if (wrapper == null || !wrapper.m_128425_("uuid", 8)) break;
                UUID uuid = UUID.fromString(wrapper.m_128461_("uuid"));
                for (Marker marker : DoomsMarkers.MARKERS.get(this.m_142253_())) {
                    if (!marker.getUuid().equals(uuid)) continue;
                    DoomsMarkers.MARKERS.get(this.m_142253_()).remove(marker);
                    break block6;
                }
                break;
            }
            case "update": {
                CompoundTag wrapper = packet.m_179590_().m_130260_();
                if (wrapper == null || !wrapper.m_128425_("data", 10)) break;
                CompoundTag compoundTag = wrapper.m_128469_("data");
                Marker loaded = (Marker)Marker.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)compoundTag).getOrThrow(false, err -> System.err.println("Failed to parse markers: " + err));
                for (Marker marker : DoomsMarkers.MARKERS.get(this.m_142253_())) {
                    if (!marker.getUuid().equals(loaded.getUuid())) continue;
                    DoomsMarkers.MARKERS.get(this.m_142253_()).remove(marker);
                    DoomsMarkers.MARKERS.get(this.m_142253_()).add(loaded);
                    break block6;
                }
                break;
            }
        }
        ci.cancel();
    }
}

