/*
 * Decompiled with CFR 0.152.
 */
package de.tom.potionrestock.client.config;

import de.tom.potionrestock.client.config.PotionRestockConfig;
import java.util.Locale;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5676;

@Environment(value=EnvType.CLIENT)
public final class ConfigScreen
extends class_437 {
    private static final NamedColor[] PRESET_COLORS = new NamedColor[]{new NamedColor("Black", -16777216), new NamedColor("Red", -43691), new NamedColor("Blue", -11184641), new NamedColor("Cyan", -16711681), new NamedColor("Green", -11141291), new NamedColor("Yellow", -171), new NamedColor("White", -1)};
    private final class_437 parent;
    private final PotionRestockConfig config;
    private class_5676<Boolean> automationToggle;
    private class_5676<Boolean> hudToggle;
    private class_342 colorField;
    private int previewColor;

    public ConfigScreen(class_437 parent, PotionRestockConfig config) {
        super((class_2561)class_2561.method_43471((String)"screen.potionrestock.config.title"));
        this.parent = parent;
        this.config = config;
        this.previewColor = config.hudTextColor;
    }

    protected void method_25426() {
        int centerX = this.field_22789 / 2;
        int y = this.field_22790 / 4;
        this.automationToggle = (class_5676)this.method_37063((class_364)class_5676.method_32613((boolean)this.config.automationEnabled).method_32617(centerX - 100, y, 200, 20, (class_2561)class_2561.method_43471((String)"screen.potionrestock.config.automation"), (button, value) -> {
            this.config.automationEnabled = value;
            this.updateToggleLabels();
        }));
        this.hudToggle = (class_5676)this.method_37063((class_364)class_5676.method_32613((boolean)this.config.hudEnabled).method_32617(centerX - 100, y += 28, 200, 20, (class_2561)class_2561.method_43471((String)"screen.potionrestock.config.hud"), (button, value) -> {
            this.config.hudEnabled = value;
            this.updateToggleLabels();
        }));
        this.updateToggleLabels();
        this.colorField = new class_342(this.field_22793, centerX - 100, y += 32, 200, 20, (class_2561)class_2561.method_43471((String)"screen.potionrestock.config.color"));
        this.colorField.method_1852(String.format(Locale.ROOT, "%08X", this.config.hudTextColor));
        this.colorField.method_1863(text -> this.updateColorPreview());
        this.method_25429((class_364)this.colorField);
        y += 40;
        y = this.addColorButtons(centerX, y) + 12;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"screen.potionrestock.config.save"), button -> this.saveAndClose()).method_46434(centerX - 100, y, 95, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.cancel"), button -> Objects.requireNonNull(this.field_22787).method_1507(this.parent)).method_46434(centerX + 5, y, 95, 20).method_46431());
        this.method_48265((class_364)this.colorField);
    }

    private int addColorButtons(int centerX, int topY) {
        int startX;
        int buttonWidth = 60;
        int buttonHeight = 20;
        int spacing = 5;
        int x = startX = centerX - (buttonWidth * 3 + spacing * 2) / 2;
        int y = topY;
        for (int i = 0; i < PRESET_COLORS.length; ++i) {
            NamedColor preset = PRESET_COLORS[i];
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)preset.label), button -> {
                this.config.hudTextColor = preset.argb;
                this.colorField.method_1852(String.format(Locale.ROOT, "%08X", preset.argb));
                this.previewColor = preset.argb;
            }).method_46434(x, y, buttonWidth, buttonHeight).method_46431());
            x += buttonWidth + spacing;
            if ((i + 1) % 3 != 0) continue;
            x = startX;
            y += buttonHeight + spacing;
        }
        if (PRESET_COLORS.length % 3 != 0) {
            y += buttonHeight + spacing;
        }
        return y;
    }

    private void updateToggleLabels() {
        this.automationToggle.method_25355(this.statusLabel("automation", this.config.automationEnabled));
        this.hudToggle.method_25355(this.statusLabel("hud", this.config.hudEnabled));
    }

    private class_2561 statusLabel(String key, boolean value) {
        return class_2561.method_43471((String)("screen.potionrestock.config." + key)).method_27693(": ").method_10852((class_2561)class_2561.method_43471((String)(value ? "options.on" : "options.off")).method_27692(value ? class_124.field_1060 : class_124.field_1061));
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25296(0, 0, this.field_22789, this.field_22790, -1341124592, -1341124592);
        super.method_25394(context, mouseX, mouseY, delta);
        int labelX = this.field_22789 / 2 - 100;
        int labelY = this.colorField.method_46427() - 12;
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"screen.potionrestock.config.color_label"), labelX, labelY, 0xFFFFFF, false);
        int previewTop = this.colorField.method_46427() + this.colorField.method_25364() + 4;
        context.method_25294(this.colorField.method_46426(), previewTop, this.colorField.method_46426() + this.colorField.method_25368(), previewTop + 10, this.previewColor | 0xFF000000);
    }

    private void updateColorPreview() {
        Integer parsed = this.tryParseColor(this.colorField.method_1882());
        if (parsed != null) {
            this.previewColor = parsed;
        }
    }

    private Integer tryParseColor(String input) {
        Object text = input.trim().replace("#", "");
        try {
            if (((String)text).length() == 6) {
                text = "FF" + (String)text;
            }
            return (int)Long.parseLong((String)text, 16);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    public void method_25419() {
        this.saveAndClose();
    }

    private void saveAndClose() {
        Integer value = this.tryParseColor(this.colorField.method_1882());
        if (value != null) {
            this.config.hudTextColor = value;
        }
        this.config.save();
        Objects.requireNonNull(this.field_22787).method_1507(this.parent);
    }

    @Environment(value=EnvType.CLIENT)
    private record NamedColor(String label, int argb) {
    }
}

