/*
 * Decompiled with CFR 0.152.
 */
package de.tom.potionrestock.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public final class PotionRestockConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("potionrestock.json");
    public boolean automationEnabled = true;
    public boolean hudEnabled = true;
    public int hudTextColor = -16711766;

    public static PotionRestockConfig load() {
        PotionRestockConfig potionRestockConfig;
        block9: {
            if (Files.notExists(CONFIG_PATH, new LinkOption[0])) {
                PotionRestockConfig config = new PotionRestockConfig();
                config.save();
                return config;
            }
            BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);
            try {
                PotionRestockConfig config = (PotionRestockConfig)GSON.fromJson((Reader)reader, PotionRestockConfig.class);
                PotionRestockConfig potionRestockConfig2 = potionRestockConfig = config != null ? config : new PotionRestockConfig();
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonSyntaxException | IOException e) {
                    e.printStackTrace();
                    return new PotionRestockConfig();
                }
            }
            ((Reader)reader).close();
        }
        return potionRestockConfig;
    }

    public void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

