/*
 * Decompiled with CFR 0.152.
 */
package de.tom.potionrestock.client.hud;

import de.tom.potionrestock.client.PotionRestockClient;
import de.tom.potionrestock.client.logic.PotionDescriptor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1812;
import net.minecraft.class_1844;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public final class PotionHudOverlay {
    private boolean visible = true;

    public void toggle() {
        this.visible = !this.visible;
    }

    public void render(class_332 drawContext) {
        if (!this.visible) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1690.field_1842 || client.field_1724 == null) {
            return;
        }
        if (!PotionRestockClient.getConfig().hudEnabled) {
            return;
        }
        List<HudEntry> entries = this.collectEntries(client.field_1724);
        if (entries.isEmpty()) {
            return;
        }
        int iconSize = 16;
        int entryHeight = iconSize + 4;
        int padding = 6;
        int iconX = 6;
        int labelOffset = iconSize + 6;
        int y = drawContext.method_51443() - entryHeight * entries.size() - padding;
        boolean showDetails = client.field_1690.field_1907.method_1434();
        for (HudEntry entry : entries) {
            class_1799 sample = entry.sample().method_7972();
            drawContext.method_51427(sample, iconX, y);
            class_5250 label = class_2561.method_43470((String)(entry.count() + "x"));
            Objects.requireNonNull(client.field_1772);
            int textY = y + (iconSize - 9) / 2;
            this.drawTextOverlay(drawContext, client, (class_2561)label, iconX + labelOffset, textY, PotionRestockClient.getConfig().hudTextColor);
            if (showDetails) {
                int infoX = iconX + labelOffset + 40;
                int infoY = y;
                for (class_2561 line : this.buildEffectText(sample)) {
                    this.drawTextOverlay(drawContext, client, line, infoX, infoY, -1);
                    Objects.requireNonNull(client.field_1772);
                    infoY += 9 + 1;
                }
            }
            y += entryHeight;
        }
    }

    private List<HudEntry> collectEntries(class_746 player) {
        class_1661 inventory = player.method_31548();
        LinkedHashMap<PotionDescriptor, HudEntry> aggregates = new LinkedHashMap<PotionDescriptor, HudEntry>();
        for (int slot = 0; slot < 36; ++slot) {
            class_1799 stack = inventory.method_5438(slot);
            if (!(stack.method_7909() instanceof class_1812)) continue;
            PotionDescriptor descriptor = PotionDescriptor.from(stack);
            int amount = stack.method_7947();
            aggregates.compute(descriptor, (key, entry) -> {
                if (entry == null) {
                    return new HudEntry(stack.method_7972(), amount);
                }
                return entry.incremented(amount);
            });
        }
        ArrayList<HudEntry> sorted = new ArrayList<HudEntry>(aggregates.values());
        sorted.sort(Comparator.comparing(entry -> entry.sample().method_7964().getString()));
        return sorted;
    }

    private List<class_2561> buildEffectText(class_1799 stack) {
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        class_1844 contents = (class_1844)stack.method_58695(class_9334.field_49651, (Object)class_1844.field_49274);
        Iterable effects = contents.method_57397();
        if (!effects.iterator().hasNext()) {
            lines.add((class_2561)class_2561.method_43471((String)"effect.none").method_27692(class_124.field_1080));
            return lines;
        }
        for (class_1293 effect : effects) {
            class_5250 name = class_2561.method_43471((String)effect.method_5586());
            if (effect.method_5578() > 0) {
                name = name.method_27661().method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)("potion.potency." + effect.method_5578())));
            }
            lines.add((class_2561)name.method_27692(class_124.field_1068));
            lines.add((class_2561)class_2561.method_43470((String)this.formatDuration(effect.method_5584())).method_27692(class_124.field_1063));
        }
        return lines;
    }

    private String formatDuration(int durationTicks) {
        if (durationTicks <= 0) {
            return "\u221e";
        }
        int totalSeconds = durationTicks / 20;
        int minutes = totalSeconds / 60;
        int seconds = totalSeconds % 60;
        return String.format(Locale.ROOT, "%d:%02d", minutes, seconds);
    }

    private void drawTextOverlay(class_332 drawContext, class_310 client, class_2561 text, int x, int y, int color) {
        drawContext.method_27535(client.field_1772, text, x, y, color);
    }

    @Environment(value=EnvType.CLIENT)
    private record HudEntry(class_1799 sample, int count) {
        HudEntry incremented(int delta) {
            return new HudEntry(this.sample, this.count + delta);
        }
    }
}

