/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.datagen;

import com.voxelutopia.ultramarine.datagen.ModBlockModelProvider;
import com.voxelutopia.ultramarine.datagen.ModBlockTagsProvider;
import com.voxelutopia.ultramarine.datagen.ModDataMapProvider;
import com.voxelutopia.ultramarine.datagen.ModGlobalLootModifiersProvider;
import com.voxelutopia.ultramarine.datagen.ModItemModelProvider;
import com.voxelutopia.ultramarine.datagen.ModItemTagsProvider;
import com.voxelutopia.ultramarine.datagen.ModLootProvider;
import com.voxelutopia.ultramarine.datagen.ModPoiTypeTagsProvider;
import com.voxelutopia.ultramarine.datagen.ModRecipeProvider;
import com.voxelutopia.ultramarine.datagen.ModWorldGenProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="ultramarine")
public class DataGenerators {
    public static final String MOD_ID = "ultramarine";

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper fh = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockModelProvider(output, fh));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(output, fh));
        ModBlockTagsProvider blockTags = (ModBlockTagsProvider)generator.addProvider(event.includeServer(), (DataProvider)new ModBlockTagsProvider(output, lookupProvider, fh));
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagsProvider(output, lookupProvider, blockTags.contentsGetter(), fh));
        generator.addProvider(event.includeServer(), (DataProvider)new ModPoiTypeTagsProvider(output, lookupProvider, fh));
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ModDataMapProvider(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)ModLootProvider.create(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ModGlobalLootModifiersProvider(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ModWorldGenProvider(output, lookupProvider));
    }
}

