/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.datagen;

import com.google.common.collect.ImmutableSet;
import com.voxelutopia.ultramarine.Ultramarine;
import com.voxelutopia.ultramarine.data.registry.BlockRegistry;
import com.voxelutopia.ultramarine.data.registry.ItemRegistry;
import com.voxelutopia.ultramarine.world.block.BaseBlockProperty;
import com.voxelutopia.ultramarine.world.block.BaseBlockPropertyHolder;
import com.voxelutopia.ultramarine.world.block.BaseSlab;
import com.voxelutopia.ultramarine.world.block.ConsumableDecorativeBlock;
import com.voxelutopia.ultramarine.world.block.StackableHalfBlock;
import com.voxelutopia.ultramarine.world.block.state.ModBlockStateProperties;
import com.voxelutopia.ultramarine.world.block.state.StackableBlockType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ModBlockLootProvider
extends BlockLootSubProvider {
    static final Logger LOGGER = Ultramarine.getLogger();
    static final LootItemCondition.Builder HAS_SHEARS = MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{Items.SHEARS}));
    static final Set<Item> EXPLOSION_RESISTANT = (Set)Stream.of(Blocks.BEDROCK).map(ItemLike::asItem).collect(ImmutableSet.toImmutableSet());
    protected final Map<Block, LootTable.Builder> lootTables = new HashMap<Block, LootTable.Builder>();
    protected final HolderLookup.Provider registries;
    private static final List<DeferredHolder<Block, Block>> NON_SIMPLE_BLOCKS = new ArrayList<DeferredHolder<Block, Block>>();
    private static final List<Class<? extends Block>> NON_SIMPLE_BLOCK_CLASSES = List.of(DropExperienceBlock.class, SlabBlock.class, ConsumableDecorativeBlock.class, StackableHalfBlock.class);

    public ModBlockLootProvider(HolderLookup.Provider provider) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
        this.registries = provider;
    }

    protected void generate() {
        BlockRegistry.BLOCKS.getEntries().stream().filter(blockRegistryObject -> !NON_SIMPLE_BLOCKS.contains(blockRegistryObject)).forEach(this::simple);
        BlockRegistry.BLOCKS.getEntries().stream().filter(blockRegistryObject -> blockRegistryObject.get() instanceof BaseSlab).forEach(blockRegistryObject -> this.slab((Block)blockRegistryObject.get(), ((Block)blockRegistryObject.get()).asItem()));
        BlockRegistry.BLOCKS.getEntries().stream().filter(blockRegistryObject -> blockRegistryObject.get() instanceof StackableHalfBlock).forEach(blockRegistryObject -> this.stackableHalf((Block)blockRegistryObject.get(), ((Block)blockRegistryObject.get()).asItem()));
        this.ore(BlockRegistry.JADE_ORE, ItemRegistry.JADE);
        this.ore(BlockRegistry.DEEPSLATE_JADE_ORE, ItemRegistry.JADE);
        this.ore(BlockRegistry.HEMATITE_ORE, ItemRegistry.RAW_HEMATITE);
        this.ore(BlockRegistry.DEEPSLATE_HEMATITE_ORE, ItemRegistry.RAW_HEMATITE);
        this.abundantOre(BlockRegistry.MAGNESITE_ORE, ItemRegistry.MAGNESITE);
        this.abundantOre(BlockRegistry.DEEPSLATE_MAGNESITE_ORE, ItemRegistry.MAGNESITE);
        this.ore(BlockRegistry.NETHER_COBALT_ORE, ItemRegistry.RAW_COBALT);
        this.porcelainWithShards(BlockRegistry.BLUE_AND_WHITE_PORCELAIN_VASE, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_SHARDS);
        this.porcelainWithShards(BlockRegistry.LARGE_BLUE_AND_WHITE_PORCELAIN_VASE, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_SHARDS);
        this.porcelainWithShards(BlockRegistry.SHORT_BLUE_AND_WHITE_PORCELAIN_POT, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_SHARDS);
        this.porcelainWithShards(BlockRegistry.TALL_BLUE_AND_WHITE_PORCELAIN_POT, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_SHARDS);
        this.porcelainWithShards(BlockRegistry.BLUE_AND_WHITE_PORCELAIN_BOWL, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_SHARDS);
        this.porcelain(BlockRegistry.PORCELAIN_TEAPOT, ItemRegistry.PORCELAIN_PIECE);
        this.porcelainWithShards(BlockRegistry.BLUE_AND_WHITE_PORCELAIN_FLOWERPOT, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_SHARDS);
        this.porcelain(BlockRegistry.BLUE_PORCELAIN_FLOWERPOT, ItemRegistry.PORCELAIN_PIECE);
        this.porcelainWithShards(BlockRegistry.WINE_POT, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_SHARDS);
        this.porcelainPlateWithShards(BlockRegistry.PLATED_MOONCAKES, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_SHARDS);
        this.porcelainPlate(BlockRegistry.PLATED_MUNG_BEAN_CAKES, ItemRegistry.PORCELAIN_PIECE);
        this.plateDrop(BlockRegistry.PLATED_HAM);
        this.plateDrop(BlockRegistry.PLATED_FISH);
        this.plateDrop(BlockRegistry.SCATTERED_CARROTS);
        this.plateDrop(BlockRegistry.XIAOLONGBAO);
        this.porcelain(BlockRegistry.SMALL_WHITE_PORCELAIN_VASE_BONSAI, ItemRegistry.PORCELAIN_PIECE);
        this.porcelain(BlockRegistry.MEDIUM_WHITE_PORCELAIN_VASE_BONSAI, ItemRegistry.PORCELAIN_PIECE);
        this.porcelain(BlockRegistry.LARGE_WHITE_PORCELAIN_VASE_BONSAI, ItemRegistry.PORCELAIN_PIECE);
        this.porcelain(BlockRegistry.SMALL_GREEN_PORCELAIN_VASE_BONSAI, ItemRegistry.PORCELAIN_PIECE);
        this.porcelain(BlockRegistry.GREEN_PORCELAIN_VASE_BONSAI, ItemRegistry.PORCELAIN_PIECE);
        this.porcelain(BlockRegistry.TALL_BLUE_VASE_BONSAI, ItemRegistry.PORCELAIN_PIECE);
        this.porcelainWithShards(BlockRegistry.TALL_BLUE_AND_WHITE_PORCELAIN_BONSAI, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_SHARDS);
        this.addLootTable((Block)BlockRegistry.PAINTING_SCROLL.get(), LootTable.lootTable().withPool(LootPool.lootPool().name("painting_scroll").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.PAINTING_SCROLL.get())).when(HAS_SHEARS.invert())).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DIAMOND).append((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.LONG_HANGING_PAINTING.get()))).append((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.WHITE_LANDSCAPE_PAINTING.get()))).append((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.HORIZONTAL_OLD_LANDSCAPE_PAINTING.get()))).append((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.HORIZONTAL_CALLIGRAPHY.get()))).append((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.HORIZONTAL_LANDSCAPE_PAINTING.get()))).append((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.LONG_YELLOW_HANGING_PAINTING.get()))).append((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.PORTRAIT.get()))).append((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.HANGING_PAINTING_FAN.get()))).append((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.SINCERE_CALLIGRAPHY.get())))))));
    }

    void simple(DeferredHolder<Block, ? extends Block> block) {
        this.addLootTable((Block)block.get(), this.createSimpleTable(block.getId().getPath(), (ItemLike)block.get()));
    }

    void ore(DeferredHolder<Block, ? extends Block> block, DeferredHolder<Item, ? extends Item> item) {
        this.addLootTable((Block)block.get(), this.createOreDrop(block.getId().getPath(), (Block)block.get(), (Item)item.get()));
    }

    void abundantOre(DeferredHolder<Block, ? extends Block> block, DeferredHolder<Item, ? extends Item> item) {
        this.addLootTable((Block)block.get(), this.createAbundantOreDrop(block.getId().getPath(), (Block)block.get(), (Item)item.get(), 1.0f, 3.0f));
    }

    void porcelain(DeferredHolder<Block, ? extends Block> block, DeferredHolder<Item, ? extends Item> piece) {
        this.addLootTable((Block)block.get(), this.createPorcelainDrop(block.getId().getPath(), (ItemLike)block.get(), (ItemLike)piece.get()));
    }

    void porcelainWithShards(DeferredHolder<Block, ? extends Block> block, DeferredHolder<Item, ? extends Item> piece, DeferredHolder<Item, ? extends Item> shards) {
        this.addLootTable((Block)block.get(), this.createPorcelainDropWithShard(block.getId().getPath(), (ItemLike)block.get(), (ItemLike)piece.get(), (ItemLike)shards.get()));
    }

    void porcelainPlate(DeferredHolder<Block, ? extends Block> block, DeferredHolder<Item, ? extends Item> piece) {
        Object object = block.get();
        if (object instanceof ConsumableDecorativeBlock) {
            ConsumableDecorativeBlock consumable = (ConsumableDecorativeBlock)object;
            this.addLootTable((Block)block.get(), this.createPorcelainDrop(block.getId().getPath(), (ItemLike)consumable.getPlate().getItem(), (ItemLike)piece.get()));
        } else {
            LOGGER.warn("Porcelain plate loot table was not added for block {}", (Object)((Block)block.get()).getDescriptionId());
        }
    }

    void porcelainPlateWithShards(DeferredHolder<Block, ? extends Block> block, DeferredHolder<Item, ? extends Item> piece, DeferredHolder<Item, ? extends Item> shards) {
        Object object = block.get();
        if (object instanceof ConsumableDecorativeBlock) {
            ConsumableDecorativeBlock consumable = (ConsumableDecorativeBlock)object;
            this.addLootTable((Block)block.get(), this.createPorcelainDropWithShard(block.getId().getPath(), (ItemLike)consumable.getPlate().getItem(), (ItemLike)piece.get(), (ItemLike)shards.get()));
        } else {
            LOGGER.warn("Porcelain plate loot table was not added for block {}", (Object)((Block)block.get()).getDescriptionId());
        }
    }

    void slab(Block block, Item item) {
        if (block instanceof SlabBlock) {
            SlabBlock slab = (SlabBlock)block;
            this.addLootTable(block, this.createSlabDrop(ModBlockLootProvider.name(block), slab, item));
        } else {
            LOGGER.warn("Slab loot table was not added for block {}", (Object)block.getDescriptionId());
        }
    }

    void stackableHalf(Block block, Item item) {
        if (block instanceof StackableHalfBlock) {
            StackableHalfBlock stackable = (StackableHalfBlock)block;
            this.addLootTable(block, this.createStackableHalfDrop(ModBlockLootProvider.name(block), stackable, item));
        } else {
            LOGGER.warn("Stackable loot table was not added for block {}", (Object)block.getDescriptionId());
        }
    }

    void plateDrop(DeferredHolder<Block, ? extends Block> block) {
        Object object = block.get();
        if (object instanceof ConsumableDecorativeBlock) {
            ConsumableDecorativeBlock consumable = (ConsumableDecorativeBlock)object;
            this.addLootTable((Block)block.get(), this.createSimpleTable(block.getId().getPath(), (ItemLike)consumable.getPlate().getItem()));
        } else {
            LOGGER.warn("Plate drop loot table was not added for block {}", (Object)((Block)block.get()).getDescriptionId());
        }
    }

    protected LootTable.Builder createSimpleTable(String name, ItemLike block) {
        LootPool.Builder builder = LootPool.lootPool().name(name).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block));
        return LootTable.lootTable().withPool(builder);
    }

    protected LootTable.Builder createSingleItemTable(String name, Block block, Item drops) {
        LootPool.Builder builder = LootPool.lootPool().name(name).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)drops));
        return LootTable.lootTable().withPool(builder);
    }

    protected LootTable.Builder createSlabDrop(String name, SlabBlock block, Item item) {
        LootPool.Builder builder = LootPool.lootPool().name(name).add(LootItem.lootTableItem((ItemLike)item).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)SlabBlock.TYPE, (Comparable)SlabType.TOP)))).add(LootItem.lootTableItem((ItemLike)item).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)SlabBlock.TYPE, (Comparable)SlabType.BOTTOM)))).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)item).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)SlabBlock.TYPE, (Comparable)SlabType.DOUBLE)))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f))));
        return LootTable.lootTable().withPool(builder);
    }

    protected LootTable.Builder createStackableHalfDrop(String name, StackableHalfBlock block, Item item) {
        LootPool.Builder builder = LootPool.lootPool().name(name).add(LootItem.lootTableItem((ItemLike)item).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(ModBlockStateProperties.STACKABLE_BLOCK_TYPE, (Comparable)((Object)StackableBlockType.SINGLE))))).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)item).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(ModBlockStateProperties.STACKABLE_BLOCK_TYPE, (Comparable)((Object)StackableBlockType.DOUBLE))))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f))));
        return LootTable.lootTable().withPool(builder);
    }

    protected LootTable.Builder createAbundantOreDrop(String name, Block block, Item drop, float min, float max) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchDispatchTable(block, name, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)drop).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)min, (float)max))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE)))));
    }

    protected LootTable.Builder createOreDrop(String name, Block block, Item drop) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchDispatchTable(block, name, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)drop).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE)))));
    }

    protected LootTable.Builder createPorcelainDropWithShard(String name, ItemLike block, ItemLike piece, ItemLike shard) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return LootTable.lootTable().withPool(LootPool.lootPool().name(name).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(this.hasSilkTouch())).otherwise((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)piece).when(LootItemRandomChanceCondition.randomChance((float)0.01f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (int)2))).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)shard).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)BinomialDistributionGenerator.binomial((int)3, (float)0.5f))))));
    }

    protected LootTable.Builder createPorcelainDrop(String name, ItemLike block, ItemLike piece) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return LootTable.lootTable().withPool(LootPool.lootPool().name(name).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(this.hasSilkTouch())).otherwise((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)piece).when(LootItemRandomChanceCondition.randomChance((float)0.2f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (int)2)))));
    }

    protected LootTable.Builder createSelfDropDispatchTable(Block pBlock, String name, LootItemCondition.Builder pConditionBuilder, LootPoolEntryContainer.Builder<?> pAlternativeEntryBuilder) {
        return LootTable.lootTable().withPool(LootPool.lootPool().name(name).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)pBlock).when(pConditionBuilder)).otherwise(pAlternativeEntryBuilder)));
    }

    protected LootTable.Builder createSilkTouchDispatchTable(Block pBlock, String name, LootPoolEntryContainer.Builder<?> pAlternativeEntryBuilder) {
        return this.createSelfDropDispatchTable(pBlock, name, this.hasSilkTouch(), pAlternativeEntryBuilder);
    }

    void addLootTable(Block block, LootTable.Builder builder) {
        if (this.lootTables.containsKey(block)) {
            LOGGER.warn("Added duplicate loot table for block {}", (Object)block.getDescriptionId());
        }
        this.lootTables.put(block, builder);
        this.add(block, builder);
    }

    private static String name(Block block) {
        return Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)block)).getPath();
    }

    @NotNull
    protected Iterable<Block> getKnownBlocks() {
        return BlockRegistry.BLOCKS.getEntries().stream().map(x -> (Block)x.get())::iterator;
    }

    static {
        BlockRegistry.BLOCKS.getEntries().stream().filter(blockRegistryObject -> {
            Block block = (Block)blockRegistryObject.get();
            for (Class<? extends Block> clazz : NON_SIMPLE_BLOCK_CLASSES) {
                if (!clazz.isInstance(block)) continue;
                return true;
            }
            if (block instanceof BaseBlockPropertyHolder) {
                BaseBlockPropertyHolder baseBlock = (BaseBlockPropertyHolder)block;
                return baseBlock.getProperty().getMaterial() == BaseBlockProperty.BlockMaterial.PORCELAIN;
            }
            return false;
        }).forEach(x -> NON_SIMPLE_BLOCKS.add((DeferredHolder<Block, Block>)x));
        NON_SIMPLE_BLOCKS.add(BlockRegistry.PAINTING_SCROLL);
    }
}

