/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.voxelutopia.ultramarine.world.block.BaseBlockProperty;
import com.voxelutopia.ultramarine.world.block.DecorativeBlock;
import com.voxelutopia.ultramarine.world.block.state.ModBlockStateProperties;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class ConsumableDecorativeBlock
extends DecorativeBlock {
    public static final IntegerProperty BITES = ModBlockStateProperties.BITES;
    private final int bites;
    private final ConsumeAction finishedAction;
    private final ConsumeAction eatAction;
    private final Supplier<ItemStack> plate;
    private final FoodProperties food;
    public static ConsumeAction DEFAULT_FINISH_ACTION = (pState, pLevel, pPos, pPlayer) -> {
        ItemStack itemStack;
        pLevel.setBlock(pPos, Blocks.AIR.defaultBlockState(), 3);
        Block patt0$temp = pState.getBlock();
        if (patt0$temp instanceof ConsumableDecorativeBlock) {
            ConsumableDecorativeBlock consumable = (ConsumableDecorativeBlock)patt0$temp;
            itemStack = consumable.getPlate();
        } else {
            itemStack = ItemStack.EMPTY;
        }
        ItemHandlerHelper.giveItemToPlayer((Player)pPlayer, (ItemStack)itemStack);
        pLevel.gameEvent((Entity)pPlayer, (Holder)GameEvent.BLOCK_DESTROY, pPos);
    };
    public static ConsumeAction DEFAULT_EAT_ACTION = (pState, pLevel, pPos, pPlayer) -> {
        Block patt0$temp = pState.getBlock();
        if (patt0$temp instanceof ConsumableDecorativeBlock) {
            ConsumableDecorativeBlock consumable = (ConsumableDecorativeBlock)patt0$temp;
            FoodProperties food = consumable.getFood();
            pPlayer.getFoodData().eat(food.nutrition(), food.saturation());
            for (FoodProperties.PossibleEffect pair : food.effects()) {
                if (pLevel.isClientSide || !(pLevel.random.nextFloat() < pair.probability())) continue;
                pPlayer.addEffect((MobEffectInstance)pair.effectSupplier().get());
            }
            pLevel.playSound(pPlayer, pPos, SoundEvents.GENERIC_EAT, SoundSource.PLAYERS, 1.0f, 0.75f);
            pLevel.gameEvent((Entity)pPlayer, (Holder)GameEvent.EAT, pPos);
        }
    };

    public ConsumableDecorativeBlock(Builder builder) {
        super(builder);
        this.bites = builder.bites;
        this.finishedAction = builder.finishedAction;
        this.eatAction = builder.eatAction;
        this.plate = builder.plate;
        this.food = builder.food;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BITES, (Comparable)Integer.valueOf(this.bites)));
    }

    public static Builder with(BaseBlockProperty property) {
        return new Builder(property);
    }

    @Override
    @NotNull
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState state = super.getStateForPlacement(pContext);
        return state.hasProperty((Property)BITES) ? (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(this.getMaxBites())) : state;
    }

    public InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHit) {
        int bitesRemaining;
        int n = bitesRemaining = pState.hasProperty((Property)BITES) ? (Integer)pState.getValue((Property)BITES) : 0;
        if (!pPlayer.canEat(false)) {
            return InteractionResult.PASS;
        }
        if (bitesRemaining > 0) {
            this.eatAction.consume(pState, pLevel, pPos, pPlayer);
            --bitesRemaining;
        }
        if (bitesRemaining <= 0) {
            this.finishedAction.consume(pState, pLevel, pPos, pPlayer);
        } else {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)BITES, (Comparable)Integer.valueOf(bitesRemaining)), 3);
        }
        return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide());
    }

    public int getMaxBites() {
        return this.bites;
    }

    public ItemStack getPlate() {
        return this.plate.get();
    }

    public FoodProperties getFood() {
        return this.food;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{BITES});
    }

    public static class Builder
    extends DecorativeBlock.Builder {
        private static final FoodProperties DEFAULT_FOOD = new FoodProperties.Builder().nutrition(2).saturationModifier(0.2f).build();
        private int bites = 4;
        private Supplier<ItemStack> plate = () -> new ItemStack((ItemLike)Blocks.STONE_SLAB);
        private ConsumeAction eatAction = DEFAULT_EAT_ACTION;
        private ConsumeAction finishedAction = DEFAULT_FINISH_ACTION;
        private FoodProperties food = DEFAULT_FOOD;

        public Builder(BaseBlockProperty property) {
            super(property);
        }

        public Builder bites(int bites) {
            this.bites = bites;
            return this;
        }

        public Builder whenFinished(ConsumeAction action) {
            this.finishedAction = action;
            return this;
        }

        public Builder onEat(ConsumeAction action) {
            this.eatAction = action;
            return this;
        }

        public Builder platedWith(ItemStack plate) {
            this.plate = () -> plate;
            return this;
        }

        public Builder platedWith(Block plate) {
            this.plate = () -> new ItemStack((ItemLike)plate);
            return this;
        }

        public Builder platedWith(Supplier<Item> plate) {
            this.plate = () -> new ItemStack((ItemLike)plate.get());
            return this;
        }

        public Builder food(FoodProperties food) {
            this.food = food;
            return this;
        }

        @Override
        public ConsumableDecorativeBlock build() {
            return new ConsumableDecorativeBlock(this);
        }
    }

    @FunctionalInterface
    public static interface ConsumeAction {
        public void consume(BlockState var1, Level var2, BlockPos var3, Player var4);
    }
}

