/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.voxelutopia.ultramarine.data.ContainerType;
import com.voxelutopia.ultramarine.world.block.BaseBlockProperty;
import com.voxelutopia.ultramarine.world.block.DecorativeBlock;
import com.voxelutopia.ultramarine.world.block.entity.ContainerDecorativeBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;

public class ContainerDecorativeBlock
extends DecorativeBlock
implements EntityBlock {
    protected final ContainerType containerType;
    protected final int rowCount;

    public ContainerDecorativeBlock(Builder builder) {
        super(builder);
        this.containerType = builder.containerType;
        this.rowCount = builder.rowCount;
    }

    public static Builder with(BaseBlockProperty property) {
        return new Builder(property);
    }

    public void setPlacedBy(Level worldIn, BlockPos posIn, BlockState stateIn, @Nullable LivingEntity entityIn, ItemStack stackIn) {
        BlockEntity blockEntity = worldIn.getBlockEntity(posIn);
        if (blockEntity instanceof ContainerDecorativeBlockEntity) {
            ContainerDecorativeBlockEntity containerBlockEntity = (ContainerDecorativeBlockEntity)blockEntity;
            containerBlockEntity.applyComponentsFromItemStack(stackIn);
        }
    }

    public PushReaction getPistonPushReaction(BlockState pState) {
        return PushReaction.BLOCK;
    }

    public boolean hasAnalogOutputSignal(BlockState stateIn) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)pLevel.getBlockEntity(pPos));
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState state) {
        return new ContainerDecorativeBlockEntity(pPos, state, this.rowCount);
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult rayIn) {
        if (worldIn.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof ContainerDecorativeBlockEntity) {
            ContainerDecorativeBlockEntity container = (ContainerDecorativeBlockEntity)blockEntity;
            player.openMenu((MenuProvider)container);
        }
        return InteractionResult.CONSUME;
    }

    public void onRemove(BlockState pState, Level levelIn, BlockPos pos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.is(pNewState.getBlock())) {
            BlockEntity blockEntity = levelIn.getBlockEntity(pos);
            if (blockEntity instanceof Container) {
                Containers.dropContents((Level)levelIn, (BlockPos)pos, (Container)((Container)blockEntity));
                levelIn.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(pState, levelIn, pos, pNewState, pIsMoving);
        }
    }

    public ContainerType getContainerType() {
        return this.containerType;
    }

    public static class Builder
    extends DecorativeBlock.Builder {
        private ContainerType containerType = ContainerType.COMMON_REGULAR;
        private int rowCount = 3;

        public Builder(BaseBlockProperty property) {
            super(property);
        }

        public Builder content(ContainerType type) {
            this.containerType = type;
            this.rowCount = type.getRows();
            return this;
        }

        @Override
        public ContainerDecorativeBlock build() {
            return new ContainerDecorativeBlock(this);
        }
    }
}

