/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.voxelutopia.ultramarine.world.block.DecorativeBlock;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class OpeningBlock
extends DecorativeBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.DOOR_HINGE;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public OpeningBlock(DecorativeBlock.Builder builder) {
        super(builder);
    }

    public InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHit) {
        pState = (BlockState)pState.cycle((Property)OPEN);
        pLevel.setBlock(pPos, pState, 10);
        this.playSound((Entity)pPlayer, pLevel, pPos, (Boolean)pState.getValue((Property)OPEN));
        pLevel.levelEvent(pPlayer, (Boolean)pState.getValue((Property)OPEN) != false ? 1006 : 1012, pPos, 0);
        pLevel.gameEvent((Entity)pPlayer, (Holder)(this.isOpen(pState) ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pPos);
        return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
    }

    public boolean isOpen(BlockState pState) {
        return (Boolean)pState.getValue((Property)OPEN);
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        boolean signal = pLevel.hasNeighborSignal(pPos);
        if (!this.defaultBlockState().is(pBlock) && signal != (Boolean)pState.getValue((Property)POWERED)) {
            if (signal != (Boolean)pState.getValue((Property)OPEN)) {
                this.playSound(null, pLevel, pPos, signal);
                pLevel.gameEvent((Holder)(signal ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pPos, GameEvent.Context.of((BlockState)pState));
            }
            pLevel.setBlock(pPos, (BlockState)((BlockState)pState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(signal))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(signal)), 2);
        }
    }

    private void playSound(@Nullable Entity pSource, Level pLevel, BlockPos pPos, boolean pIsOpening) {
        pLevel.playSound(pSource, pPos, pIsOpening ? SoundEvents.WOODEN_DOOR_OPEN : SoundEvents.WOODEN_DOOR_CLOSE, SoundSource.BLOCKS, 1.0f, pLevel.getRandom().nextFloat() * 0.1f + 0.9f);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockPos blockpos = pContext.getClickedPos();
        Level level = pContext.getLevel();
        boolean signal = level.hasNeighborSignal(blockpos);
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection())).setValue(HINGE, (Comparable)this.getHinge(pContext))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(signal))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(signal));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{OPEN, HINGE, POWERED});
    }

    @Override
    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return (Boolean)pState.getValue((Property)OPEN) != false ? Shapes.empty() : this.getShape(pState, pLevel, pPos, pContext);
    }

    private DoorHingeSide getHinge(BlockPlaceContext pContext) {
        Level level = pContext.getLevel();
        BlockPos clickedPos = pContext.getClickedPos();
        Direction horizontalDirection = pContext.getHorizontalDirection();
        BlockPos above = clickedPos.above();
        Direction counterClockWise = horizontalDirection.getCounterClockWise();
        BlockPos relativeCCW = clickedPos.relative(counterClockWise);
        BlockState blockstateCCW = level.getBlockState(relativeCCW);
        BlockPos aboveCCW = above.relative(counterClockWise);
        BlockState blockstateAboveCCW = level.getBlockState(aboveCCW);
        Direction horizontalDirectionCW = horizontalDirection.getClockWise();
        BlockPos posHorizontalCW = clickedPos.relative(horizontalDirectionCW);
        BlockState blockstateHorizontalCW = level.getBlockState(posHorizontalCW);
        BlockPos aboveCW = above.relative(horizontalDirectionCW);
        BlockState blockstateAboveCW = level.getBlockState(aboveCW);
        int i = (blockstateCCW.isCollisionShapeFullBlock((BlockGetter)level, relativeCCW) ? -1 : 0) + (blockstateAboveCCW.isCollisionShapeFullBlock((BlockGetter)level, aboveCCW) ? -1 : 0) + (blockstateHorizontalCW.isCollisionShapeFullBlock((BlockGetter)level, posHorizontalCW) ? 1 : 0) + (blockstateAboveCW.isCollisionShapeFullBlock((BlockGetter)level, aboveCW) ? 1 : 0);
        boolean CCW = blockstateCCW.is((Block)this);
        boolean CW = blockstateHorizontalCW.is((Block)this);
        if ((!CCW || CW) && i <= 0) {
            if ((!CW || CCW) && i == 0) {
                int j = horizontalDirection.getStepX();
                int k = horizontalDirection.getStepZ();
                Vec3 vec3 = pContext.getClickLocation();
                double d0 = vec3.x - (double)clickedPos.getX();
                double d1 = vec3.z - (double)clickedPos.getZ();
                return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    @Override
    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    @Override
    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pMirror == Mirror.NONE ? pState : (BlockState)pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING))).cycle(HINGE);
    }

    @Override
    public boolean isDiagonallyPlaceable() {
        return false;
    }
}

