/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.voxelutopia.ultramarine.data.shape.RawVoxelShape;
import com.voxelutopia.ultramarine.world.block.ShiftableBlock;
import com.voxelutopia.ultramarine.world.block.ShiftedTileType;
import com.voxelutopia.ultramarine.world.block.state.ModBlockStateProperties;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Pair;

public class RoofTiles
extends ShiftableBlock {
    public static final BlockBehaviour.Properties PROPERTIES = BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(1.5f, 4.0f).sound(SoundType.DEEPSLATE_TILES);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final IntegerProperty SNOW_LAYERS = ModBlockStateProperties.SNOW_LAYERS;
    public static final EnumProperty<SnowSide> SNOW_SIDE = ModBlockStateProperties.SNOW_SIDE;
    private static final VoxelShape BOTTOM_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape BOTTOM_AABB_SHIFTED = Block.box((double)0.0, (double)-8.0, (double)0.0, (double)16.0, (double)0.0, (double)16.0);
    private static final RawVoxelShape NORTH_UPPER_RAW = new RawVoxelShape(0.0, 8.0, 0.0, 16.0, 16.0, 8.0);
    private static final VoxelShape NORTH_SHAPE = Shapes.or((VoxelShape)BOTTOM_AABB, (VoxelShape)NORTH_UPPER_RAW.copy().toVoxelShape());
    private static final VoxelShape WEST_SHAPE = Shapes.or((VoxelShape)BOTTOM_AABB, (VoxelShape)NORTH_UPPER_RAW.copy().rotateY(90.0f).toVoxelShape());
    private static final VoxelShape SOUTH_SHAPE = Shapes.or((VoxelShape)BOTTOM_AABB, (VoxelShape)NORTH_UPPER_RAW.copy().rotateY(180.0f).toVoxelShape());
    private static final VoxelShape EAST_SHAPE = Shapes.or((VoxelShape)BOTTOM_AABB, (VoxelShape)NORTH_UPPER_RAW.copy().rotateY(270.0f).toVoxelShape());
    private static final VoxelShape EAST_SHAPE_SHIFTED = Shapes.or((VoxelShape)BOTTOM_AABB_SHIFTED, (VoxelShape)Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0));
    private static final VoxelShape NORTH_SHAPE_SHIFTED = Shapes.or((VoxelShape)BOTTOM_AABB_SHIFTED, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0));
    private static final VoxelShape SOUTH_SHAPE_SHIFTED = Shapes.or((VoxelShape)BOTTOM_AABB_SHIFTED, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0));
    private static final VoxelShape WEST_SHAPE_SHIFTED = Shapes.or((VoxelShape)BOTTOM_AABB_SHIFTED, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0));
    private final DyeColor color;
    private final RoofTileType type;

    public RoofTiles(DyeColor color, RoofTileType type) {
        super(PROPERTIES);
        this.color = color;
        this.type = type;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)SHIFTED, (Comparable)Boolean.FALSE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue((Property)SNOW_LAYERS, (Comparable)Integer.valueOf(0))).setValue(SNOW_SIDE, (Comparable)((Object)SnowSide.BOTH)));
    }

    public void handlePrecipitation(BlockState pState, Level pLevel, BlockPos pPos, Biome.Precipitation pPrecipitation) {
        if (pPrecipitation == Biome.Precipitation.SNOW) {
            this.tryPushSnow(pState, pLevel, pPos);
        }
    }

    private void tryPushSnow(BlockState pState, Level pLevel, BlockPos pPos) {
        RandomSource random = pLevel.getRandom();
        SlopeAngle forwardAngle = this.checkForwardSlopeAngle(pLevel, pState, pPos);
        if (forwardAngle == SlopeAngle.HIGHER) {
            this.handleSnow(pState, pLevel, pPos);
            return;
        }
        BlockState blockForward = pLevel.getBlockState(pPos.relative(((Direction)pState.getValue((Property)FACING)).getOpposite()));
        BlockState blockForwardBelow = pLevel.getBlockState(pPos.relative(((Direction)pState.getValue((Property)FACING)).getOpposite()).below());
        if (forwardAngle == SlopeAngle.LEVEL && random.nextFloat() < 0.5f && blockForward.getBlock() instanceof RoofTiles && (Integer)blockForward.getValue((Property)SNOW_LAYERS) == 15 && random.nextFloat() > 0.9f) {
            this.tryPushSnow(blockForward, pLevel, pPos.relative(((Direction)pState.getValue((Property)FACING)).getOpposite()));
            return;
        }
        if (forwardAngle == SlopeAngle.LOWER && random.nextFloat() < 0.8f) {
            if (blockForward.getBlock() instanceof RoofTiles) {
                if ((Integer)blockForward.getValue((Property)SNOW_LAYERS) == 15 && random.nextFloat() > 0.9f) {
                    this.tryPushSnow(blockForward, pLevel, pPos.relative(((Direction)pState.getValue((Property)FACING)).getOpposite()));
                    return;
                }
            } else if (blockForwardBelow.getBlock() instanceof RoofTiles && (Integer)blockForwardBelow.getValue((Property)SNOW_LAYERS) == 15 && random.nextFloat() > 0.9f) {
                this.tryPushSnow(blockForwardBelow, pLevel, pPos.relative(((Direction)pState.getValue((Property)FACING)).getOpposite()));
                return;
            }
        }
        this.handleSnow(pState, pLevel, pPos);
    }

    private void handleSnow(BlockState pState, Level pLevel, BlockPos pPos) {
        if (!pLevel.isClientSide()) {
            int snow = (Integer)pState.getValue((Property)SNOW_LAYERS);
            BlockState newState = (BlockState)pState.setValue((Property)SNOW_LAYERS, (Comparable)Integer.valueOf(Math.min(15, ++snow)));
            pLevel.setBlockAndUpdate(pPos, newState);
            this.updateSideSnow(newState, pLevel, pPos);
        }
    }

    private void removeSnow(BlockState pState, Level pLevel, BlockPos pPos) {
        if (!pLevel.isClientSide()) {
            int snow = (Integer)pState.getValue((Property)SNOW_LAYERS);
            BlockState newState = (BlockState)pState.setValue((Property)SNOW_LAYERS, (Comparable)Integer.valueOf(Math.max(0, --snow)));
            pLevel.setBlockAndUpdate(pPos, newState);
            this.updateSideSnow(newState, pLevel, pPos);
        }
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack item = pPlayer.getItemInHand(pHand);
        if (item.is(Items.SNOWBALL)) {
            this.handleSnow(pState, pLevel, pPos);
            if (!pPlayer.isCreative()) {
                item.shrink(1);
            }
            return ItemInteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
        }
        if (item.getItem() instanceof ShovelItem) {
            this.removeSnow(pState, pLevel, pPos);
            if (!pPlayer.isCreative()) {
                item.hurtAndBreak(1, (LivingEntity)pPlayer, LivingEntity.getSlotForHand((InteractionHand)pHand));
            }
            return ItemInteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        this.updateSideSnow(pState, pLevel, pPos);
        super.neighborChanged(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        this.updateSideSnow(pState, pLevel, pPos);
        this.updateNeighborSideSnow(pState, pLevel, pPos);
        super.onPlace(pState, pLevel, pPos, pOldState, pIsMoving);
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        this.updateNeighborSideSnow(pState, pLevel, pPos);
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    private void updateNeighborSideSnow(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockPos[] posToUpdate;
        Direction direction = (Direction)pState.getValue((Property)FACING);
        for (BlockPos pos : posToUpdate = this.getSideUpdatePosArray(pPos, direction)) {
            Block block = pLevel.getBlockState(pos).getBlock();
            if (!(block instanceof RoofTiles)) continue;
            this.updateSideSnow(pLevel.getBlockState(pos), pLevel, pos);
        }
    }

    private BlockPos[] getSideUpdatePosArray(BlockPos pPos, Direction direction) {
        return new BlockPos[]{pPos.relative(direction.getClockWise()), pPos.relative(direction.getCounterClockWise()), pPos.relative(direction.getClockWise()).above(), pPos.relative(direction.getCounterClockWise()).above(), pPos.relative(direction.getClockWise()).below(), pPos.relative(direction.getCounterClockWise()).below()};
    }

    private void updateSideSnow(BlockState pState, Level pLevel, BlockPos pPos) {
        SnowSide currentSnowSide = (SnowSide)((Object)pState.getValue(SNOW_SIDE));
        Direction direction = (Direction)pState.getValue((Property)FACING);
        BlockPos blockPosLeft = pPos.relative(direction.getCounterClockWise());
        BlockPos blockPosRight = pPos.relative(direction.getClockWise());
        SlopeAngle slopeLeft = this.checkSideSlopeAngle(pLevel, pState, pPos, pLevel.getBlockState(blockPosLeft), blockPosLeft);
        SlopeAngle slopeRight = this.checkSideSlopeAngle(pLevel, pState, pPos, pLevel.getBlockState(blockPosRight), blockPosRight);
        currentSnowSide = slopeLeft == SlopeAngle.LOWER ? SnowSide.add(currentSnowSide, SnowSide.LEFT) : SnowSide.remove(currentSnowSide, SnowSide.LEFT);
        currentSnowSide = slopeRight == SlopeAngle.LOWER ? SnowSide.add(currentSnowSide, SnowSide.RIGHT) : SnowSide.remove(currentSnowSide, SnowSide.RIGHT);
        BlockState newState = (BlockState)pState.setValue(SNOW_SIDE, (Comparable)((Object)currentSnowSide));
        pLevel.setBlockAndUpdate(pPos, newState);
    }

    private SlopeAngle checkSideSlopeAngle(Level level, BlockState self, BlockPos selfPos, BlockState other, BlockPos otherPos) {
        Boolean selfShifted = (Boolean)self.getValue((Property)SHIFTED);
        RoofTileType type = ((RoofTiles)self.getBlock()).getType();
        if (type != RoofTileType.STAIRS) {
            if (selfShifted.booleanValue()) {
                Block blockAbove = level.getBlockState(otherPos.above()).getBlock();
                if (blockAbove instanceof RoofTiles) {
                    return SlopeAngle.HIGHER;
                }
                Block blockLevel = other.getBlock();
                if (blockLevel instanceof RoofTiles) {
                    RoofTiles tileLevel = (RoofTiles)blockLevel;
                    if (!((Boolean)other.getValue((Property)SHIFTED)).booleanValue()) {
                        return SlopeAngle.HIGHER;
                    }
                    return tileLevel.getType() == RoofTileType.STAIRS ? SlopeAngle.HIGHER : SlopeAngle.LEVEL;
                }
                if (!other.isAir()) {
                    return SlopeAngle.LEVEL;
                }
            } else {
                BlockState blockAbove = level.getBlockState(otherPos.above());
                if (blockAbove.getBlock() instanceof RoofTiles && ((Boolean)blockAbove.getValue((Property)SHIFTED)).booleanValue()) {
                    return SlopeAngle.HIGHER;
                }
                Block blockLevel = other.getBlock();
                if (blockLevel instanceof RoofTiles) {
                    RoofTiles tileLevel = (RoofTiles)blockLevel;
                    if (((Boolean)other.getValue((Property)SHIFTED)).booleanValue()) {
                        return SlopeAngle.LOWER;
                    }
                    return tileLevel.getType() == RoofTileType.STAIRS ? SlopeAngle.HIGHER : SlopeAngle.LEVEL;
                }
                if (!other.isAir()) {
                    return SlopeAngle.HIGHER;
                }
            }
            return SlopeAngle.LOWER;
        }
        if (selfShifted.booleanValue()) {
            BlockState blockAbove = level.getBlockState(otherPos.above());
            if (!blockAbove.isAir()) {
                return SlopeAngle.HIGHER;
            }
            Block blockLevel = other.getBlock();
            if (blockLevel instanceof RoofTiles) {
                RoofTiles tileLevel = (RoofTiles)blockLevel;
                if (tileLevel.getType() != RoofTileType.STAIRS) {
                    return SlopeAngle.LOWER;
                }
                return (Boolean)other.getValue((Property)SHIFTED) != false ? SlopeAngle.LOWER : SlopeAngle.LEVEL;
            }
            if (!other.isAir()) {
                return SlopeAngle.LEVEL;
            }
            return SlopeAngle.LOWER;
        }
        Block blockLevel = other.getBlock();
        if (blockLevel instanceof RoofTiles) {
            RoofTiles tileLevel = (RoofTiles)blockLevel;
            if (!((Boolean)other.getValue((Property)SHIFTED)).booleanValue()) {
                return SlopeAngle.HIGHER;
            }
            return tileLevel.getType() == RoofTileType.STAIRS ? SlopeAngle.LEVEL : SlopeAngle.LOWER;
        }
        if (!other.isAir()) {
            return SlopeAngle.HIGHER;
        }
        return SlopeAngle.LEVEL;
    }

    private SlopeAngle checkForwardSlopeAngle(Level level, BlockState self, BlockPos selfPos) {
        Boolean selfShifted = (Boolean)self.getValue((Property)SHIFTED);
        Direction direction = (Direction)self.getValue((Property)FACING);
        RoofTileType type = ((RoofTiles)self.getBlock()).getType();
        BlockState blockForward = level.getBlockState(selfPos.relative(direction.getOpposite()));
        if (type != RoofTileType.STAIRS) {
            if (selfShifted.booleanValue()) {
                Block block = blockForward.getBlock();
                if (block instanceof RoofTiles) {
                    RoofTiles tileForward = (RoofTiles)block;
                    if (!((Boolean)blockForward.getValue((Property)SHIFTED)).booleanValue()) {
                        return SlopeAngle.HIGHER;
                    }
                    return tileForward.getType() == RoofTileType.STAIRS ? SlopeAngle.HIGHER : SlopeAngle.LEVEL;
                }
                BlockState blockForwardBelow = level.getBlockState(selfPos.relative(direction.getOpposite()).above());
                if (blockForwardBelow.getBlock() instanceof RoofTiles && !((Boolean)blockForwardBelow.getValue((Property)SHIFTED)).booleanValue()) {
                    return SlopeAngle.LOWER;
                }
            } else {
                BlockState blockForwardAbove = level.getBlockState(selfPos.relative(direction.getOpposite()).above());
                if (blockForwardAbove.getBlock() instanceof RoofTiles && ((Boolean)blockForwardAbove.getValue((Property)SHIFTED)).booleanValue()) {
                    return SlopeAngle.HIGHER;
                }
                Block block = blockForward.getBlock();
                if (block instanceof RoofTiles) {
                    RoofTiles tileForward2 = (RoofTiles)block;
                    if (tileForward2.getType() == RoofTileType.STAIRS) {
                        return (Boolean)blockForward.getValue((Property)SHIFTED) != false ? SlopeAngle.LOWER : SlopeAngle.HIGHER;
                    }
                    return (Boolean)blockForward.getValue((Property)SHIFTED) != false ? SlopeAngle.LOWER : SlopeAngle.LEVEL;
                }
            }
        } else if (selfShifted.booleanValue()) {
            RoofTiles tileForward;
            Block tileForward2 = blockForward.getBlock();
            if (tileForward2 instanceof RoofTiles && (tileForward = (RoofTiles)tileForward2).getType() != RoofTileType.STAIRS) {
                return SlopeAngle.LOWER;
            }
            if (!blockForward.isAir()) {
                return SlopeAngle.HIGHER;
            }
            BlockState blockForwardBelow = level.getBlockState(selfPos.relative(direction.getOpposite()).above());
            Block block = blockForwardBelow.getBlock();
            if (block instanceof RoofTiles) {
                RoofTiles tilesForwardBelow = (RoofTiles)block;
                if (((Boolean)blockForwardBelow.getValue((Property)SHIFTED)).booleanValue()) {
                    return tilesForwardBelow.getType() == RoofTileType.STAIRS ? SlopeAngle.LOWER : SlopeAngle.HIGHER;
                }
                return SlopeAngle.LOWER;
            }
        } else {
            BlockState blockForwardAbove = level.getBlockState(selfPos.relative(direction.getOpposite()).above());
            if (blockForwardAbove.getBlock() instanceof RoofTiles && ((Boolean)blockForwardAbove.getValue((Property)SHIFTED)).booleanValue()) {
                return SlopeAngle.HIGHER;
            }
            Block block = blockForward.getBlock();
            if (block instanceof RoofTiles) {
                RoofTiles tileForward = (RoofTiles)block;
                if (((Boolean)blockForward.getValue((Property)SHIFTED)).booleanValue()) {
                    return tileForward.getType() == RoofTileType.STAIRS ? SlopeAngle.HIGHER : SlopeAngle.LOWER;
                }
                return SlopeAngle.LOWER;
            }
        }
        return SlopeAngle.HIGHER;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public RoofTileType getType() {
        return this.type;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{FACING});
        pBuilder.add(new Property[]{SNOW_LAYERS});
        pBuilder.add(new Property[]{SNOW_SIDE});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)super.getStateForPlacement(pContext).setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection());
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRot.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Boolean shifted = (Boolean)pState.getValue((Property)SHIFTED);
        if (this.type != RoofTileType.STAIRS) {
            return shifted != false ? Block.box((double)0.0, (double)-8.0, (double)0.0, (double)16.0, (double)0.0, (double)16.0) : Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
        }
        return switch ((Direction)pState.getValue((Property)FACING)) {
            case Direction.NORTH -> {
                if (shifted.booleanValue()) {
                    yield NORTH_SHAPE_SHIFTED;
                }
                yield NORTH_SHAPE;
            }
            case Direction.SOUTH -> {
                if (shifted.booleanValue()) {
                    yield SOUTH_SHAPE_SHIFTED;
                }
                yield SOUTH_SHAPE;
            }
            case Direction.WEST -> {
                if (shifted.booleanValue()) {
                    yield WEST_SHAPE_SHIFTED;
                }
                yield WEST_SHAPE;
            }
            case Direction.EAST -> {
                if (shifted.booleanValue()) {
                    yield EAST_SHAPE_SHIFTED;
                }
                yield EAST_SHAPE;
            }
            default -> Shapes.empty();
        };
    }

    public static enum RoofTileType implements ShiftedTileType
    {
        NORMAL("roof_tiles", Map.ofEntries(Map.entry(0, Pair.of((Object)0, (Object)false)), Map.entry(1, Pair.of((Object)1, (Object)false)), Map.entry(2, Pair.of((Object)2, (Object)false)), Map.entry(3, Pair.of((Object)2, (Object)false)), Map.entry(4, Pair.of((Object)3, (Object)true)), Map.entry(5, Pair.of((Object)4, (Object)true)), Map.entry(6, Pair.of((Object)4, (Object)true)), Map.entry(7, Pair.of((Object)5, (Object)true)), Map.entry(8, Pair.of((Object)6, (Object)true)), Map.entry(9, Pair.of((Object)7, (Object)true)), Map.entry(10, Pair.of((Object)7, (Object)true)), Map.entry(11, Pair.of((Object)8, (Object)true)), Map.entry(12, Pair.of((Object)9, (Object)true)), Map.entry(13, Pair.of((Object)10, (Object)true)), Map.entry(14, Pair.of((Object)11, (Object)true)), Map.entry(15, Pair.of((Object)11, (Object)true))), 11),
        STAIRS("roof_tile_stairs", Map.ofEntries(Map.entry(0, Pair.of((Object)0, (Object)false)), Map.entry(1, Pair.of((Object)1, (Object)false)), Map.entry(2, Pair.of((Object)1, (Object)false)), Map.entry(3, Pair.of((Object)1, (Object)false)), Map.entry(4, Pair.of((Object)1, (Object)false)), Map.entry(5, Pair.of((Object)1, (Object)false)), Map.entry(6, Pair.of((Object)2, (Object)false)), Map.entry(7, Pair.of((Object)2, (Object)false)), Map.entry(8, Pair.of((Object)2, (Object)false)), Map.entry(9, Pair.of((Object)3, (Object)false)), Map.entry(10, Pair.of((Object)3, (Object)false)), Map.entry(11, Pair.of((Object)3, (Object)false)), Map.entry(12, Pair.of((Object)4, (Object)false)), Map.entry(13, Pair.of((Object)4, (Object)false)), Map.entry(14, Pair.of((Object)4, (Object)false)), Map.entry(15, Pair.of((Object)5, (Object)false))), 5),
        EDGE("roof_tile_edge", Map.ofEntries(Map.entry(0, Pair.of((Object)0, (Object)false)), Map.entry(1, Pair.of((Object)1, (Object)true)), Map.entry(2, Pair.of((Object)1, (Object)true)), Map.entry(3, Pair.of((Object)1, (Object)true)), Map.entry(4, Pair.of((Object)1, (Object)true)), Map.entry(5, Pair.of((Object)1, (Object)true)), Map.entry(6, Pair.of((Object)1, (Object)true)), Map.entry(7, Pair.of((Object)2, (Object)true)), Map.entry(8, Pair.of((Object)2, (Object)true)), Map.entry(9, Pair.of((Object)2, (Object)true)), Map.entry(10, Pair.of((Object)2, (Object)true)), Map.entry(11, Pair.of((Object)2, (Object)true)), Map.entry(12, Pair.of((Object)2, (Object)true)), Map.entry(13, Pair.of((Object)3, (Object)true)), Map.entry(14, Pair.of((Object)3, (Object)true)), Map.entry(15, Pair.of((Object)3, (Object)true))), 3);

        final String blockName;
        final Map<Integer, Pair<Integer, Boolean>> snowStages;
        final Integer maxSnowStages;

        private RoofTileType(String blockName, Map<Integer, Pair<Integer, Boolean>> snowStages, int maxSnowStages) {
            this.blockName = blockName;
            this.snowStages = snowStages;
            this.maxSnowStages = maxSnowStages;
        }

        public Map<Integer, Pair<Integer, Boolean>> getSnowStages() {
            return this.snowStages;
        }

        public Integer getMaxSnowStages() {
            return this.maxSnowStages;
        }

        public String toString() {
            return this.blockName;
        }
    }

    public static enum SnowSide implements StringRepresentable
    {
        LEFT("left"),
        RIGHT("right"),
        NONE("none"),
        BOTH("both");

        final String name;

        private SnowSide(String name) {
            this.name = name;
        }

        public static SnowSide add(SnowSide current, SnowSide toAdd) {
            if (toAdd == NONE) {
                return current;
            }
            if (current == LEFT || current == RIGHT) {
                if (current == toAdd) {
                    return current;
                }
                return BOTH;
            }
            if (current == NONE) {
                return toAdd;
            }
            return current;
        }

        public static SnowSide remove(SnowSide current, SnowSide toRemove) {
            if (toRemove == NONE) {
                return current;
            }
            if (current == LEFT || current == RIGHT) {
                if (toRemove == BOTH || current == toRemove) {
                    return NONE;
                }
                return current;
            }
            if (current == BOTH) {
                if (toRemove == BOTH) {
                    return NONE;
                }
                return toRemove == LEFT ? RIGHT : LEFT;
            }
            return current;
        }

        public String getSerializedName() {
            return this.name;
        }
    }

    private static enum SlopeAngle {
        HIGHER,
        LOWER,
        LEVEL;

    }
}

