/*
 * Decompiled with CFR 0.152.
 */
package com.cicada.longwings.client.model;

import com.cicada.longwings.entity.ButterflyEntity;
import com.cicada.longwings.entity.ButterflyVariant;
import com.cicada.longwings.entity.EnumButterflyTraits;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Blocks;

public class ButterflyModel<T extends ButterflyEntity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("longwings", "butterfly_model"), "main");
    public final ModelPart Butterfly;
    public final ModelPart Body;
    public final ModelPart RightWing;
    public final ModelPart LeftWing;
    public final ModelPart LeftTena;
    public final ModelPart RightTena;
    private ButterflyModel butterflyModel;

    public ButterflyModel(ModelPart root) {
        this.Butterfly = root.m_171324_("Butterfly");
        this.Body = this.Butterfly.m_171324_("Body");
        this.LeftWing = this.Body.m_171324_("wingL");
        this.RightWing = this.Body.m_171324_("wingR");
        this.LeftTena = this.Body.m_171324_("tenaL");
        this.RightTena = this.Body.m_171324_("tenaR");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Butterfly = partdefinition.m_171599_("Butterfly", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-2.5f, (float)23.0f, (float)1.0f));
        PartDefinition Body = Butterfly.m_171599_("Body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)3.0f, (float)-3.25f, (float)-1.25f));
        PartDefinition BodBody_r1 = Body.m_171599_("BodBody_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.5f, -3.75f, -4.25f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition wingL = Body.m_171599_("wingL", CubeListBuilder.m_171558_().m_171514_(-21, 11).m_171480_().m_171488_(0.0f, 0.0f, -9.0f, 16.0f, 0.0f, 21.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.5f, (float)3.25f, (float)0.25f));
        PartDefinition wingR = Body.m_171599_("wingR", CubeListBuilder.m_171558_().m_171514_(-21, 11).m_171488_(-16.0f, 0.0f, -9.0f, 16.0f, 0.0f, 21.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)3.25f, (float)0.25f));
        PartDefinition tenaL = Body.m_171599_("tenaL", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.5f, (float)3.25f, (float)-3.75f));
        PartDefinition leftTena_r1 = tenaL.m_171599_("leftTena_r1", CubeListBuilder.m_171558_().m_171514_(4, -5).m_171488_(0.0f, -7.0f, -1.0f, 0.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)2.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition tenaR = Body.m_171599_("tenaR", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.5f, (float)3.25f, (float)-3.75f));
        PartDefinition rightTena_r1 = tenaR.m_171599_("rightTena_r1", CubeListBuilder.m_171558_().m_171514_(4, -5).m_171488_(0.0f, -7.0f, -1.0f, 0.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)2.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void m_7695_(PoseStack p_103111_, VertexConsumer p_103112_, int p_103113_, int p_103114_, float p_103115_, float p_103116_, float p_103117_, float p_103118_) {
        p_103111_.m_85841_(0.5f, 0.5f, 0.5f);
        this.Butterfly.m_104301_(p_103111_, p_103112_, p_103113_, p_103114_);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float animSpeed = 1.0f;
        float animVelocity = 1.0f;
        float partialTick = Minecraft.m_91087_().m_91104_() ? 0.0f : Minecraft.m_91087_().m_91296_();
        int tickCount = ((ButterflyEntity)((Object)entity)).f_19797_;
        int flyCount = ((ButterflyEntity)((Object)entity)).floatCount;
        int wingSpan = (tickCount + Math.abs(entity.m_146904_() + entity.m_146903_()) * 5) % 80;
        if (!(((ButterflyEntity)((Object)entity)).m_20096_() || ((ButterflyEntity)((Object)entity)).isOnWall() || ((ButterflyEntity)((Object)entity)).isInPlant())) {
            float wingFAnimFlapVal = (float)(Math.sin(((float)flyCount + partialTick) * 1.0f) * (double)(0.7f * animVelocity)) + 0.85f;
            float wingAnimRotVal = (float)(Math.sin(((float)flyCount + partialTick - 5.0f) * 1.0f) * (double)0.3f);
            this.RightWing.f_104205_ = wingFAnimFlapVal;
            this.LeftWing.f_104205_ = -wingFAnimFlapVal;
            this.RightWing.f_104203_ = wingAnimRotVal;
            this.LeftWing.f_104203_ = wingAnimRotVal;
            double localDeltaX = entity.m_20184_().f_82479_ * Math.cos(Math.toRadians(entity.m_146908_())) + entity.m_20184_().f_82481_ * Math.sin(Math.toRadians(entity.m_146908_()));
            double localDeltaZ = entity.m_20184_().f_82481_ * Math.cos(Math.toRadians(entity.m_146908_())) - entity.m_20184_().f_82479_ * Math.sin(Math.toRadians(entity.m_146908_()));
            float a = (float)Math.atan2(localDeltaZ * 2.0, 1.0);
            float b = (float)Math.atan2(localDeltaX * 2.0, 1.0);
            double clampedModifiedRot = Mth.m_14008_((double)(entity.m_20184_().f_82480_ * 4.0), (double)-0.5, (double)0.5);
            this.Body.f_104203_ = (float)(clampedModifiedRot + (double)((float)(Math.sin(((float)(-flyCount) - partialTick) * 0.92f) * (double)0.2f)));
            this.Body.f_104205_ = 0.0f;
            this.RightTena.f_104203_ = 0.0f;
            this.LeftTena.f_104203_ = 0.0f;
            this.LeftWing.f_104204_ = 0.0f;
            this.RightWing.f_104204_ = 0.0f;
            this.LeftWing.f_104201_ = (float)Math.PI;
            this.RightWing.f_104201_ = (float)Math.PI;
        }
        if (((ButterflyEntity)((Object)entity)).m_20096_() || ((ButterflyEntity)((Object)entity)).isOnWall() || ((ButterflyEntity)((Object)entity)).isInPlant()) {
            boolean flag = entity instanceof ButterflyEntity.MothEntity;
            float wingSpanFold = wingSpan > 12 && wingSpan < 25 ? 14.1f + (float)(Math.sin(((float)wingSpan + partialTick) * 0.25f) * 1.5) : 14.175f;
            float wingSpanOpen = (float)((double)0.12f + Math.sin(((float)wingSpan + partialTick) * 0.325f) * (double)0.025f);
            this.RightWing.f_104205_ = flag ? wingSpanOpen : wingSpanFold;
            this.LeftWing.f_104205_ = flag ? -wingSpanOpen : -wingSpanFold;
            this.Body.f_104203_ = 0.0f;
            this.RightWing.f_104203_ = 0.0f;
            this.LeftWing.f_104203_ = 0.0f;
            this.Butterfly.f_104204_ = 0.0f;
            this.RightWing.f_104204_ = 0.0f;
            this.LeftWing.f_104204_ = -0.0f;
            this.RightWing.f_104201_ = 3.2505927f;
            this.LeftWing.f_104201_ = 3.2505927f;
            float f = this.Body.f_104203_ = ((ButterflyEntity)((Object)entity)).isOnWall() ? entity.m_146909_() + 0.475f : 0.0f;
        }
        if (entity instanceof ButterflyEntity.MothEntity) {
            int windSpanMoth = tickCount + Math.abs(entity.m_146904_() + entity.m_146903_());
            this.Body.f_233553_ = 1.0f;
            this.Body.f_233554_ = 1.0f;
            this.Body.f_233555_ = 1.0f;
            if (((ButterflyEntity)((Object)entity)).m_20096_() || ((ButterflyEntity)((Object)entity)).isOnWall() || ((ButterflyEntity)((Object)entity)).isInPlant()) {
                // empty if block
            }
        }
        this.Butterfly.f_104200_ = 0.0f;
        this.Body.f_104202_ = 0.0f;
        this.Butterfly.f_104201_ = 0.0f;
        this.Butterfly.f_104205_ = 0.0f;
        this.Butterfly.f_233555_ = 1.0f;
        this.Butterfly.f_233554_ = 1.0f;
        this.Butterfly.f_233553_ = 1.0f;
        this.Body.f_233554_ = this.Body.f_233555_ = ((ButterflyEntity)((Object)entity)).getSize().floatValue();
        this.Body.f_233553_ = this.Body.f_233555_;
        EnumButterflyTraits.BodyType mothBody = EnumButterflyTraits.BodyType.MOTH;
        ButterflyVariant variantA = ButterflyVariant.ATALA;
        boolean isOnWall = ((ButterflyEntity)((Object)entity)).isOnWall();
        ArrayList<ButterflyVariant> pool = ButterflyVariant.getAllVariantPool();
        ButterflyVariant variant = ButterflyVariant.ATLAS;
        String variantString = ((ButterflyEntity)((Object)entity)).getVariant();
        boolean tool = false;
        boolean tool2 = false;
        float xOffset = 0.0f;
        float yOffset = 0.0f;
        float zOffset = 0.0f;
        for (int a = 0; a < pool.size(); ++a) {
            variant = pool.get(a);
            String vara = variant.getButterflyStringId();
            EnumButterflyTraits.BodyType vara2 = variant.bodyType();
            tool = vara.matches(variantString);
            if (!tool) continue;
            boolean bl = tool2 = vara2 == mothBody;
            if (!tool2) continue;
            xOffset = 0.5f * ((ButterflyEntity)((Object)entity)).getSize().floatValue();
            yOffset = 1.0f;
        }
        boolean flag = ((ButterflyEntity)((Object)entity)).isOnWall() && ((ButterflyEntity)((Object)entity)).m_20096_();
        float a = (float)(Math.sin(((float)((ButterflyEntity)((Object)entity)).floatCount + Minecraft.m_91087_().m_91296_()) * 0.85f) * 0.75);
        float b = entity.m_9236_().m_8055_(entity.m_20183_()).m_60713_(Blocks.f_220864_) ? -3.75f : 0.0f;
        this.Butterfly.f_104200_ = -3.0f + xOffset;
        this.Butterfly.f_104201_ = 51.0f - (4.0f + yOffset) * ((ButterflyEntity)((Object)entity)).getSize().floatValue() + (flag ? a : 0.0f) + b;
        this.Butterfly.f_104202_ = ((ButterflyEntity)((Object)entity)).isOnWall() ? -2.9f + ((ButterflyEntity)((Object)entity)).getSize().floatValue() * (4.0f + yOffset) : 0.0f;
    }
}

