/*
 * Decompiled with CFR 0.152.
 */
package com.cicada.longwings.client.renderers;

import com.cicada.longwings.client.model.ButterflyModel;
import com.cicada.longwings.client.model.MothModel;
import com.cicada.longwings.entity.ButterflyVariant;
import com.cicada.longwings.entity.EnumButterflyTraits;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class ButterflyItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private ButterflyModel butterflyModel = new ButterflyModel(Minecraft.m_91087_().m_167973_().m_171103_(ButterflyModel.LAYER_LOCATION));
    private MothModel mothModel = new MothModel(Minecraft.m_91087_().m_167973_().m_171103_(MothModel.LAYER_LOCATION));

    public ButterflyItemRenderer() {
        super(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
    }

    public void m_108829_(ItemStack p_108830_, ItemDisplayContext p_108831_, PoseStack p_108832_, MultiBufferSource p_108833_, int p_108834_, int p_108835_) {
        p_108832_.m_85836_();
        p_108832_.m_85841_(1.0f, 1.0f, 1.0f);
        p_108832_.m_252880_(0.0f, 0.0f, 0.0f);
        RenderType type = this.butterflyModel.m_103119_(this.getTextureLocation(p_108830_));
        VertexConsumer vertexconsumer = ItemRenderer.m_115222_((MultiBufferSource)p_108833_, (RenderType)type, (boolean)true, (boolean)p_108830_.m_41790_());
        this.butterflyModel.LeftWing.f_104203_ = 0.0f;
        this.butterflyModel.RightWing.f_104203_ = 0.0f;
        p_108833_.m_6299_(RenderType.m_110452_((ResourceLocation)this.getTextureLocation(p_108830_)));
        assert (Minecraft.m_91087_().f_91074_ != null);
        float partialTick = Minecraft.m_91087_().m_91104_() ? 0.0f : Minecraft.m_91087_().m_91296_();
        int wingSpan = Minecraft.m_91087_().f_91074_.f_19797_ % 50;
        if (p_108831_.m_7912_() != "gui" && p_108831_.m_7912_() != "fixed") {
            if (p_108831_.m_7912_() == "firstperson_lefthand" || p_108831_.m_7912_() == "thirdperson_lefthand") {
                wingSpan = (Minecraft.m_91087_().f_91074_.f_19797_ + 3) % 50;
            }
            this.mothModel.LeftWing.f_104205_ = wingSpan > 12 && wingSpan < 25 ? -14.1f - (float)(Math.sin(((float)wingSpan + partialTick) * 0.25f) * 1.5) : -14.175f;
            this.butterflyModel.LeftWing.f_104205_ = this.mothModel.LeftWing.f_104205_;
            this.mothModel.RightWing.f_104205_ = wingSpan > 12 && wingSpan < 25 ? 14.1f + (float)(Math.sin(((float)wingSpan + partialTick) * 0.25f) * 1.5) : 14.175f;
            this.butterflyModel.RightWing.f_104205_ = this.mothModel.RightWing.f_104205_;
            this.butterflyModel.Butterfly.f_104204_ = 0.0f;
            this.butterflyModel.Butterfly.f_104204_ = 0.0f;
            this.butterflyModel.Butterfly.f_104205_ = 0.0f;
            this.butterflyModel.RightTena.f_104205_ = 0.0f;
            this.butterflyModel.LeftTena.f_104205_ = 0.0f;
        } else if (p_108831_.m_7912_().equals("gui")) {
            this.butterflyModel.Butterfly.f_104204_ = 0.0f;
            this.butterflyModel.Butterfly.f_104203_ = 0.0f;
            this.butterflyModel.Butterfly.f_104205_ = 0.0f;
            this.butterflyModel.RightTena.f_104205_ = -1.25f;
            this.butterflyModel.LeftTena.f_104205_ = 1.25f;
            p_108832_.m_85837_(0.475, 0.5, 0.5);
            p_108832_.m_85841_(1.5f, 1.0f, 1.5f);
        } else if (p_108831_.m_7912_().equals("fixed")) {
            this.butterflyModel.RightTena.f_104205_ = -1.25f;
            this.butterflyModel.LeftTena.f_104205_ = 1.25f;
            this.butterflyModel.RightWing.f_104205_ = 0.125f;
            this.butterflyModel.LeftWing.f_104205_ = -0.125f;
        }
        ArrayList<ButterflyVariant> allPool = ButterflyVariant.getAllVariantPool();
        if (p_108830_.m_41783_() != null) {
            String variant = p_108830_.m_41783_().m_128461_("variant");
            for (int b = 0; b < allPool.size(); ++b) {
                if (!allPool.get(b).getButterflyStringId().matches(variant)) continue;
                if (allPool.get(b).bodyType() == EnumButterflyTraits.BodyType.MOTH) {
                    p_108832_.m_85837_(0.035, -0.05, 0.0);
                    this.mothModel.Butterfly.m_104301_(p_108832_, vertexconsumer, p_108834_, p_108835_);
                    continue;
                }
                this.butterflyModel.Butterfly.m_104301_(p_108832_, vertexconsumer, p_108834_, p_108835_);
            }
        } else {
            this.butterflyModel.Butterfly.m_104301_(p_108832_, vertexconsumer, p_108834_, p_108835_);
        }
        p_108832_.m_85849_();
    }

    public ResourceLocation getTextureLocation(ItemStack p_114482_) {
        if (p_114482_.m_41783_() != null) {
            return new ResourceLocation("longwings", "textures/entity/butterfly/" + p_114482_.m_41783_().m_128461_("variant") + ".png");
        }
        return new ResourceLocation("longwings", "textures/entity/butterfly/painted_lady.png");
    }

    public static class MothItemRenderer
    extends BlockEntityWithoutLevelRenderer {
        private ButterflyModel butterflyModel;
        private MothModel mothModel = new MothModel(Minecraft.m_91087_().m_167973_().m_171103_(MothModel.LAYER_LOCATION));

        public MothItemRenderer() {
            super(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
            this.butterflyModel = new ButterflyModel(Minecraft.m_91087_().m_167973_().m_171103_(ButterflyModel.LAYER_LOCATION));
        }

        public void m_108829_(ItemStack p_108830_, ItemDisplayContext p_108831_, PoseStack p_108832_, MultiBufferSource p_108833_, int p_108834_, int p_108835_) {
            float partialTick;
            p_108832_.m_85836_();
            p_108832_.m_85841_(1.0f, 1.0f, 1.0f);
            p_108832_.m_252880_(0.0f, 0.0f, 0.0f);
            RenderType type = this.mothModel.m_103119_(this.getTextureLocation(p_108830_));
            VertexConsumer vertexconsumer = ItemRenderer.m_115222_((MultiBufferSource)p_108833_, (RenderType)type, (boolean)true, (boolean)p_108830_.m_41790_());
            this.butterflyModel.LeftWing.f_104203_ = 0.0f;
            this.mothModel.LeftWing.f_104203_ = 0.0f;
            this.butterflyModel.RightWing.f_104203_ = 0.0f;
            this.mothModel.RightWing.f_104203_ = 0.0f;
            p_108833_.m_6299_(RenderType.m_110452_((ResourceLocation)this.getTextureLocation(p_108830_)));
            float f = partialTick = Minecraft.m_91087_().m_91104_() ? 0.0f : Minecraft.m_91087_().m_91296_();
            assert (Minecraft.m_91087_().f_91074_ != null);
            int wingSpan = Minecraft.m_91087_().f_91074_.f_19797_ % 50;
            if (p_108831_.m_7912_() == "fixed") {
                this.butterflyModel.Butterfly.f_104201_ = 22.0f;
                this.mothModel.Butterfly.f_104201_ = 22.0f;
            }
            if (p_108831_.m_7912_() != "gui" && p_108831_.m_7912_() != "fixed") {
                if (p_108831_.m_7912_() == "firstperson_lefthand" || p_108831_.m_7912_() == "thirdperson_lefthand") {
                    wingSpan = (Minecraft.m_91087_().f_91074_.f_19797_ + 3) % 50;
                }
                float wingSpanOpen = (float)((double)0.12f + Math.sin(((float)wingSpan + partialTick) * 0.325f) * (double)0.025f);
                this.mothModel.LeftWing.f_104205_ = this.butterflyModel.LeftWing.f_104205_ = -wingSpanOpen;
                this.mothModel.RightWing.f_104205_ = this.butterflyModel.RightWing.f_104205_ = wingSpanOpen;
                this.butterflyModel.Butterfly.f_104204_ = 0.0f;
                this.butterflyModel.Butterfly.f_104204_ = 0.0f;
                this.mothModel.Butterfly.f_104204_ = 0.0f;
                this.butterflyModel.Butterfly.f_104205_ = 0.0f;
                this.mothModel.Butterfly.f_104205_ = 0.0f;
            } else if (p_108831_.m_7912_().equals("gui")) {
                this.butterflyModel.Butterfly.f_104204_ = 0.0f;
                this.mothModel.Butterfly.f_104204_ = 0.0f;
                this.butterflyModel.Butterfly.f_104203_ = 0.0f;
                this.mothModel.Butterfly.f_104203_ = 0.0f;
                this.butterflyModel.Butterfly.f_104205_ = 0.0f;
                this.mothModel.Butterfly.f_104205_ = 0.0f;
                this.butterflyModel.RightTena.f_104205_ = -1.25f;
                this.mothModel.RightTena.f_104205_ = -1.25f;
                this.butterflyModel.LeftTena.f_104205_ = 1.25f;
                this.mothModel.LeftTena.f_104205_ = 1.25f;
                p_108832_.m_85837_(0.5, 0.5, 0.5);
                p_108832_.m_85841_(1.5f, 1.0f, 1.5f);
            } else if (p_108831_.m_7912_().equals("fixed")) {
                this.butterflyModel.RightTena.f_104205_ = -1.25f;
                this.mothModel.RightTena.f_104205_ = -1.25f;
                this.butterflyModel.LeftTena.f_104205_ = 1.25f;
                this.mothModel.LeftTena.f_104205_ = 1.25f;
                this.butterflyModel.RightWing.f_104205_ = 0.125f;
                this.mothModel.RightWing.f_104205_ = 0.125f;
                this.butterflyModel.LeftWing.f_104205_ = -0.125f;
                this.mothModel.LeftWing.f_104205_ = -0.125f;
            }
            ArrayList<ButterflyVariant> allPool = ButterflyVariant.getAllVariantPool();
            if (p_108830_.m_41783_() != null) {
                String variant = p_108830_.m_41783_().m_128461_("variant");
                for (int b = 0; b < allPool.size(); ++b) {
                    if (!allPool.get(b).getButterflyStringId().matches(variant)) continue;
                    if (allPool.get(b).bodyType() == EnumButterflyTraits.BodyType.MOTH) {
                        p_108832_.m_85837_(0.035, -0.05, 0.0);
                        this.mothModel.Butterfly.m_104301_(p_108832_, vertexconsumer, p_108834_, p_108835_);
                        continue;
                    }
                    this.butterflyModel.Butterfly.m_104301_(p_108832_, vertexconsumer, p_108834_, p_108835_);
                }
            } else {
                this.butterflyModel.Butterfly.m_104301_(p_108832_, vertexconsumer, p_108834_, p_108835_);
            }
            p_108832_.m_85849_();
        }

        public ResourceLocation getTextureLocation(ItemStack p_114482_) {
            if (p_114482_.m_41783_() != null) {
                return new ResourceLocation("longwings", "textures/entity/moth/" + p_114482_.m_41783_().m_128461_("variant") + ".png");
            }
            return new ResourceLocation("longwings", "textures/entity/moth/small_white_wave.png");
        }
    }
}

