/*
 * Decompiled with CFR 0.152.
 */
package com.cicada.longwings.event;

import com.cicada.longwings.client.particle.LongDripParticle;
import com.cicada.longwings.client.particle.LongwingsParticles;
import com.cicada.longwings.entity.ButterflyEntity;
import com.cicada.longwings.entity.LongwingsEntityTypes;
import net.minecraft.client.particle.SplashParticle;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="longwings", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EventsMod {
    @SubscribeEvent
    public static void addAttributesEvent(EntityAttributeCreationEvent event) {
        event.put(LongwingsEntityTypes.BUTTERFLY, ButterflyEntity.createAttributes());
        event.put(LongwingsEntityTypes.MOTH, ButterflyEntity.createAttributes());
    }

    @SubscribeEvent
    public static void spawnPlacementRegister(SpawnPlacementRegisterEvent event) {
        event.register(LongwingsEntityTypes.BUTTERFLY, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ButterflyEntity::checkButterflySpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
        event.register(LongwingsEntityTypes.MOTH, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ButterflyEntity.MothEntity::checkMothSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onParticleTypeRegistry(RegisterParticleProvidersEvent event) {
        event.registerSprite((ParticleType)LongwingsParticles.FALLING_SUGAR_WATER, LongDripParticle::createSugarWaterFallParticle);
        event.registerSprite((ParticleType)LongwingsParticles.FALLING_HONEY_WATER, LongDripParticle::createHoneyWaterFallParticle);
        event.registerSprite((ParticleType)LongwingsParticles.DRIPPING_APPLE_BRINE, LongDripParticle::createAppleyDripParticle);
        event.registerSprite((ParticleType)LongwingsParticles.DRIPPING_MELON_BRINE, LongDripParticle::createMelonDripParticle);
        event.registerSprite((ParticleType)LongwingsParticles.DRIPPING_BERRY_BRINE, LongDripParticle::createBerryDripParticle);
        event.registerSprite((ParticleType)LongwingsParticles.FALLING_APPLE_BRINE, LongDripParticle::createAppleFallParticle);
        event.registerSprite((ParticleType)LongwingsParticles.FALLING_MELON_BRINE, LongDripParticle::createMelonFallParticle);
        event.registerSprite((ParticleType)LongwingsParticles.FALLING_BERRY_BRINE, LongDripParticle::createBerryFallParticle);
        event.registerSprite((ParticleType)LongwingsParticles.LANDING_APPLE_BRINE, LongDripParticle::createBrineLandParticle);
        event.registerSprite((ParticleType)LongwingsParticles.LANDING_MELON_BRINE, LongDripParticle::createBrineLandParticle);
        event.registerSprite((ParticleType)LongwingsParticles.LANDING_BERRY_BRINE, LongDripParticle::createBrineLandParticle);
        event.registerSpriteSet((ParticleType)LongwingsParticles.LANDING_SUGAR_WATER, SplashParticle.Provider::new);
        event.registerSpriteSet((ParticleType)LongwingsParticles.SPLASH_H0NEY_WATER, SplashParticle.Provider::new);
    }
}

