/*
 * Decompiled with CFR 0.152.
 */
package com.cicada.longwings;

import com.cicada.longwings.api.LongwingsHandler;
import com.cicada.longwings.block.LongwingsBlocks;
import com.cicada.longwings.client.model.ButterflyModel;
import com.cicada.longwings.client.model.CatchingNetModel;
import com.cicada.longwings.client.model.MothModel;
import com.cicada.longwings.client.renderers.ButterflyEntityRenderer;
import com.cicada.longwings.client.renderers.ButterflyItemRenderer;
import com.cicada.longwings.client.renderers.CatchingNetRenderer;
import com.cicada.longwings.entity.LongwingsEntityTypes;
import com.cicada.longwings.item.LongwingsItems;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.class_1268;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5601;

@Environment(value=EnvType.CLIENT)
public class LongwingsClientFabric
implements ClientModInitializer {
    public void onInitializeClient() {
        EntityModelLayerRegistry.registerModelLayer((class_5601)CatchingNetModel.LAYER_LOCATION, CatchingNetModel::createBodyLayer);
        EntityModelLayerRegistry.registerModelLayer((class_5601)ButterflyModel.LAYER_LOCATION, ButterflyModel::createBodyLayer);
        EntityModelLayerRegistry.registerModelLayer((class_5601)MothModel.LAYER_LOCATION, MothModel::createBodyLayer);
        EntityRendererRegistry.register(LongwingsEntityTypes.BUTTERFLY, ButterflyEntityRenderer::new);
        EntityRendererRegistry.register(LongwingsEntityTypes.MOTH, ButterflyEntityRenderer.MothEntityRenderer::new);
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)LongwingsItems.CATCHING_NET_ITEM, (itemStack, itemDisplayContext, poseStack, multiBufferSource, i, i1) -> new CatchingNetRenderer().method_3166(itemStack, itemDisplayContext, poseStack, multiBufferSource, i, i1));
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)LongwingsItems.BUTTERFLY_ITEM, (itemStack, itemDisplayContext, poseStack, multiBufferSource, i, i1) -> new ButterflyItemRenderer().method_3166(itemStack, itemDisplayContext, poseStack, multiBufferSource, i, i1));
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)LongwingsItems.MOTH_ITEM, (itemStack, itemDisplayContext, poseStack, multiBufferSource, i, i1) -> new ButterflyItemRenderer.MothItemRenderer().method_3166(itemStack, itemDisplayContext, poseStack, multiBufferSource, i, i1));
        this.applyRenderTypes();
        this.displayHandbookHud();
        this.registerParticlesToFactory();
    }

    private void registerParticlesToFactory() {
    }

    private void setRenderType(class_2248 block, class_1921 renderType) {
        BlockRenderLayerMap.INSTANCE.putBlock(block, renderType);
    }

    private void displayHandbookHud() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 != null) {
                boolean hasLepidopterapediaInHand;
                class_1799 getMainItem = client.field_1724.method_5998(class_1268.field_5808);
                class_1799 getOffItem = client.field_1724.method_5998(class_1268.field_5810);
                boolean bl = hasLepidopterapediaInHand = getMainItem.method_31574((class_1792)LongwingsItems.LEPIDOPTERAPEDIA) || getOffItem.method_31574((class_1792)LongwingsItems.LEPIDOPTERAPEDIA);
                if (hasLepidopterapediaInHand) {
                    class_1959 biome = (class_1959)client.field_1724.method_37908().method_22385().method_22393(client.field_1724.method_24515()).comp_349();
                    float getBiomeTemp = LongwingsHandler.getBiomeTemperature(biome);
                    float getBiomeHumid = LongwingsHandler.getBiomeHumidity(biome);
                    class_5250 component = class_2561.method_43471((String)("\u2600 : " + getBiomeTemp + " | \ud83c\udf27 : " + getBiomeHumid));
                    class_5250 componentShift = class_2561.method_43470((String)(class_2561.method_43471((String)"title.longwings.temperature").getString() + " : " + getBiomeTemp + " | " + class_2561.method_43471((String)"title.longwings.humidity").getString() + " : " + getBiomeHumid));
                    client.field_1724.method_7353((class_2561)(client.field_1724.method_18276() ? componentShift : component), true);
                }
            }
        });
    }

    private void applyRenderTypes() {
        this.setRenderType((class_2248)LongwingsBlocks.DRIPLURE, class_1921.method_23581());
        this.setRenderType(LongwingsBlocks.NETTING, class_1921.method_23583());
        this.setRenderType((class_2248)LongwingsBlocks.BERRY_BUTTERFLY_DRIPLURE, class_1921.method_23583());
        this.setRenderType((class_2248)LongwingsBlocks.APPLE_BUTTERFLY_DRIPLURE, class_1921.method_23583());
        this.setRenderType((class_2248)LongwingsBlocks.MELON_BUTTERFLY_DRIPLURE, class_1921.method_23583());
        this.setRenderType(LongwingsBlocks.SUGAR_WATER_BOWL, class_1921.method_23583());
        this.setRenderType(LongwingsBlocks.HONEY_WATER_BOWL, class_1921.method_23583());
        this.setRenderType(LongwingsBlocks.APPLE_BRINE_BOWL, class_1921.method_23583());
        this.setRenderType(LongwingsBlocks.BERRY_BRINE_BOWL, class_1921.method_23583());
        this.setRenderType(LongwingsBlocks.MELON_BRINE_BOWL, class_1921.method_23583());
        this.setRenderType((class_2248)LongwingsBlocks.FERMENTED_FRUIT_BLOCK, class_1921.method_23583());
        this.setRenderType((class_2248)LongwingsBlocks.APPLES, class_1921.method_23583());
        this.setRenderType((class_2248)LongwingsBlocks.BRINE, class_1921.method_23583());
        this.setRenderType(LongwingsBlocks.APPLES_BRINE_JAR, class_1921.method_23583());
        this.setRenderType(LongwingsBlocks.BERRY_BRINE_JAR, class_1921.method_23583());
        this.setRenderType(LongwingsBlocks.MELON_BRINE_JAR, class_1921.method_23583());
        this.setRenderType(LongwingsBlocks.GLASS_JAR, class_1921.method_23583());
        this.setRenderType(LongwingsBlocks.BUTTERFLY_EGGS, class_1921.method_23583());
        this.setRenderType(LongwingsBlocks.MOTH_EGGS, class_1921.method_23583());
    }
}

