/*
 * Decompiled with CFR 0.152.
 */
package com.cicada.longwings;

import com.cicada.longwings.LongwingsSoundsFabric;
import com.cicada.longwings.api.FabricBiomeInfoHandler;
import com.cicada.longwings.api.FabricHandbookHandler;
import com.cicada.longwings.api.LongwingsHandler;
import com.cicada.longwings.block.LongwingsBlocksFabric;
import com.cicada.longwings.client.LongwingsParticlesFabric;
import com.cicada.longwings.effect.LongwingsEffects;
import com.cicada.longwings.effect.LongwingsEffectsFabric;
import com.cicada.longwings.entity.ButterflyEntity;
import com.cicada.longwings.entity.LongwingsEntityTypes;
import com.cicada.longwings.entity.LongwingsEntityTypesFabric;
import com.cicada.longwings.item.LongwingsItemsFabric;
import com.cicada.longwings.item.LongwingsTab;
import com.cicada.longwings.networking.BookmarkPageC2SPacket;
import java.util.function.Predicate;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3481;

public class LongwingsFabric
implements ModInitializer {
    public void onInitialize() {
        LongwingsSoundsFabric.registerSounds();
        LongwingsBlocksFabric.registerBlocks();
        LongwingsItemsFabric.registerItems();
        LongwingsBlocksFabric.registerBlockEntities();
        LongwingsEffectsFabric.registerEffects();
        LongwingsEntityTypesFabric.registerEntityTypes();
        LongwingsParticlesFabric.registerParticles();
        LongwingsTab.registerTabs();
        this.applyBreakBlockEvent();
        this.registerPackets();
        this.handleSpawnPlacements();
        LongwingsHandler.setBiomeHandler(new FabricBiomeInfoHandler());
        LongwingsHandler.setHandbookHandler(new FabricHandbookHandler());
    }

    private void handleSpawnPlacements() {
        BiomeModifications.addSpawn((Predicate)BiomeSelectors.foundInOverworld(), (class_1311)class_1311.field_6294, LongwingsEntityTypes.BUTTERFLY, (int)8, (int)1, (int)1);
        BiomeModifications.addSpawn((Predicate)BiomeSelectors.foundInOverworld(), (class_1311)class_1311.field_6294, LongwingsEntityTypes.MOTH, (int)4, (int)1, (int)2);
        class_1317.method_20637(LongwingsEntityTypes.BUTTERFLY, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, ButterflyEntity::checkButterflySpawnRules);
        class_1317.method_20637(LongwingsEntityTypes.MOTH, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, ButterflyEntity.MothEntity::checkMothSpawnRules);
    }

    private void applyBreakBlockEvent() {
        PlayerBlockBreakEvents.AFTER.register((level, player, blockPos, blockState, blockEntity) -> {
            if (player.method_6059(LongwingsEffects.SEED_SNIFFER) && blockState.method_26164(class_3481.field_29822) && level.method_8409().method_43048(25) < 2) {
                class_1799 stack = Math.random() * 2.0 > 1.0 ? new class_1799((class_1935)class_1802.field_43195.method_8389()) : new class_1799((class_1935)class_1802.field_42711.method_8389());
                class_1542 itementity = new class_1542(player.method_37908(), (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), stack);
                level.method_8649((class_1297)itementity);
            }
        });
    }

    private void registerPackets() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)new class_2960("longwings", "sync_data"), (minecraftServer, serverPlayer, serverGamePacketListener, friendlyByteBuf, packetSender) -> {
            BookmarkPageC2SPacket packet = BookmarkPageC2SPacket.read(friendlyByteBuf);
            minecraftServer.execute(() -> {
                class_1268 hand = serverPlayer.method_6058();
                class_1799 stack = serverPlayer.method_5998(packet.getOpenMainHand() ? class_1268.field_5808 : class_1268.field_5810);
                if (packet.getBookmarked()) {
                    stack.method_7948().method_10582("bookmarked", "true");
                    stack.method_7948().method_10567("page", packet.getBookmarkedPage());
                } else if (stack.method_7969() != null) {
                    stack.method_7969().method_10551("bookmarked");
                    stack.method_7969().method_10551("page");
                }
            });
        });
    }
}

