/*
 * Decompiled with CFR 0.152.
 */
package com.cicada.longwings.client.gui;

import com.cicada.longwings.api.LongwingsHandler;
import com.cicada.longwings.client.model.ButterflyModel;
import com.cicada.longwings.client.model.MothModel;
import com.cicada.longwings.entity.ButterflyVariant;
import com.cicada.longwings.entity.EnumButterflyTraits;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_1921;
import net.minecraft.class_1959;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_474;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_7417;
import org.joml.Vector3f;

public class HandbookScreen
extends class_437 {
    public static final class_2561 TITLE = class_2561.method_43471((String)"gui.longwings.handbook_screen");
    private ButterflyModel<?> butterflyModel;
    private MothModel<?> mothModel;
    ArrayList<ButterflyVariant> butterflyList = new ArrayList();
    ArrayList<ButterflyVariant> mothList = new ArrayList();
    private class_4185 doneButton;
    private class_4185 atlasButton;
    private class_4185 sortButton;
    private class_474 pageFo;
    private class_474 pageBa;
    private BookmarkButton bookmarkButton;
    private ButterflyIndexButton butterflyIndexButton;
    private final class_1959 biome;
    private final boolean openedByMainHand;
    private int pages;
    private boolean bookmarked;
    private List<String> unlockedButterflyList = List.of("");
    private EnumButterflyTraits.ButterflySorts sortValue = EnumButterflyTraits.ButterflySorts.INDEX;

    public HandbookScreen(int page, boolean hand, boolean bookmarked, List<String> longwingsList, class_1959 biome) {
        super(TITLE);
        this.pages = page;
        this.biome = biome;
        this.openedByMainHand = hand;
        this.bookmarked = bookmarked;
        if (longwingsList != null) {
            this.unlockedButterflyList = longwingsList;
        }
    }

    protected void method_25426() {
        int indexYPos;
        int indexXPos;
        int indexSz;
        boolean canSpawnInBiome;
        boolean isUnlocked;
        ButterflyVariant variantInSlot;
        int a;
        int i = (this.field_22789 - 220) / 2;
        int j = (this.field_22790 - 220) / 2;
        float biomeTemp = LongwingsHandler.getBiomeTemperature(this.biome);
        float biomeHumid = LongwingsHandler.getBiomeHumidity(this.biome);
        List<String> unlockedButterflyList = this.unlockedButterflyList;
        ArrayList<ButterflyVariant> butterflyList = this.butterflyList;
        ArrayList<ButterflyVariant> mothList = this.mothList;
        if (butterflyList.isEmpty() && mothList.isEmpty()) {
            butterflyList.addAll(Arrays.asList(ButterflyVariant.getButterflyVariantPool()));
            mothList.addAll(Arrays.asList(ButterflyVariant.getMothVariantPool()));
        }
        if (this.pages == 2) {
            int perRow = 12;
            int rowNum = 0;
            for (a = 0; a < butterflyList.size(); ++a) {
                int indexB = a;
                variantInSlot = (ButterflyVariant)butterflyList.get(indexB);
                isUnlocked = unlockedButterflyList != null && !unlockedButterflyList.stream().anyMatch(s -> s.matches(variantInSlot.getButterflyStringId()));
                boolean bl = canSpawnInBiome = biomeTemp >= variantInSlot.minTemp() && biomeTemp <= variantInSlot.maxTemp() && biomeHumid >= variantInSlot.minHumidity() && biomeHumid <= variantInSlot.maxHumidity();
                if (indexB % perRow == 0) {
                    ++rowNum;
                }
                indexSz = 15;
                indexXPos = i + indexSz * (indexB % perRow) + 19;
                indexYPos = j + indexSz * rowNum + 9;
                if (indexB >= 48) {
                    indexXPos += 15;
                }
                this.method_37063((class_364)new ButterflyIndexButton(indexXPos, indexYPos, p_93751_ -> {
                    this.pages = 4 + indexB;
                    this.updateButtonVisibility();
                }, "butterfly/", variantInSlot.getButterflyStringId(), isUnlocked, canSpawnInBiome));
            }
        }
        if (this.pages == 3) {
            int rowNum = 0;
            int perRow = 6;
            for (a = 0; a < this.mothList.size(); ++a) {
                int indexM = a;
                variantInSlot = this.mothList.get(indexM);
                isUnlocked = unlockedButterflyList != null && !unlockedButterflyList.stream().anyMatch(s -> s.matches(variantInSlot.getButterflyStringId()));
                boolean bl = canSpawnInBiome = biomeTemp >= variantInSlot.minTemp() && biomeTemp <= variantInSlot.maxTemp() && biomeHumid >= variantInSlot.minHumidity() && biomeHumid <= variantInSlot.maxHumidity();
                if (indexM % perRow == 0) {
                    ++rowNum;
                }
                indexSz = 15;
                indexXPos = i + indexSz * (indexM % perRow) + 45 + 19;
                indexYPos = j + indexSz * rowNum + 14;
                if (indexM >= 18) {
                    indexXPos += 15;
                }
                this.method_37063((class_364)new ButterflyIndexButton(indexXPos, indexYPos, p_93751_ -> {
                    this.pages = 4 + this.butterflyList.size() + indexM;
                    this.updateButtonVisibility();
                }, "moth/", this.mothList.get(indexM).getButterflyStringId(), isUnlocked, canSpawnInBiome));
            }
        }
        this.bookmarkButton = new BookmarkButton(i + 230, j - 18, p_93751_ -> {
            this.bookmarked = !this.bookmarked;
        });
        int xOffset = 0;
        this.doneButton = class_4185.method_46430((class_2561)class_5244.field_24334, p_93751_ -> this.method_25419()).method_46434(this.field_22789 / 2 - (25 + xOffset), j + 152, 73, 20).method_46431();
        this.atlasButton = class_4185.method_46430((class_2561)class_5244.field_39003, p_93751_ -> {
            this.pages = this.pages == 2 || this.pages > 3 + this.butterflyList.size() ? 3 : 2;
            this.updateButtonVisibility();
        }).method_46434(this.field_22789 / 2 - (50 + xOffset), j + 152, 20, 20).method_46431();
        this.sortButton = class_4185.method_46430((class_2561)class_5244.field_39003, p_93751_ -> {
            HandbookScreen handbookScreen = this;
            this.sortValue = EnumButterflyTraits.ButterflySorts.values()[(this.sortValue.ordinal() + 1) % handbookScreen.sortValue.values().length];
            System.out.println((Object)this.sortValue);
            this.updateButtonVisibility();
        }).method_46434(this.field_22789 / 2 + (53 - xOffset), j + 152, 20, 20).method_46431();
        if (this.pages > 1) {
            this.pageBa = new class_474(i - 28, j + 119, false, p_93751_ -> {
                this.pageBa.method_25365(false);
                this.pageBa.field_22763 = false;
                --this.pages;
                this.updateButtonVisibility();
            }, true);
            this.method_37063((class_364)this.pageBa);
        }
        if (this.pages < 3 + ButterflyVariant.getAllVariantPool().size()) {
            this.pageFo = new class_474(i + 221, j + 119, true, p_93751_ -> {
                this.pageFo.method_25365(false);
                this.pageFo.field_22763 = false;
                ++this.pages;
                this.updateButtonVisibility();
            }, true);
            this.method_37063((class_364)this.pageFo);
        }
        this.method_37063((class_364)this.bookmarkButton);
        this.method_37063((class_364)this.doneButton);
        this.method_37063((class_364)this.atlasButton);
        this.butterflyModel = new ButterflyModel(class_310.method_1551().method_31974().method_32072(ButterflyModel.LAYER_LOCATION));
        this.mothModel = new MothModel(class_310.method_1551().method_31974().method_32072(MothModel.LAYER_LOCATION));
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return super.method_25406(mouseX, mouseY, button);
    }

    private void updateButtonVisibility() {
        this.method_37067();
        this.method_25426();
    }

    private void renderText(class_332 stack, String title, float xAdd, float yAdd, float zAdd, float xScale, float yScale, float zScale, boolean doDropshadow) {
        stack.method_51448().method_22903();
        stack.method_51448().method_46416(xAdd, yAdd, zAdd);
        stack.method_51448().method_22905(xScale, yScale, zScale);
        String a = title;
        if (doDropshadow) {
            stack.method_51433(this.field_22793, a, 0, 0, 15589834, false);
        }
        stack.method_51433(this.field_22793, a, 0, 0, 12689522, false);
        stack.method_51448().method_22909();
    }

    private void renderProp(class_332 p_289697_, int p_289667_, int p_289669_, float p_289670_, class_2960 texture, boolean largeBody) {
        float f = class_3532.method_16439((float)p_289670_, (float)1.0f, (float)1.0f);
        float f1 = class_3532.method_16439((float)p_289670_, (float)1.0f, (float)1.0f);
        class_4588 vertexconsumer = p_289697_.method_51450().getBuffer(class_1921.method_23580((class_2960)texture));
        class_4588 vertexconsumer2 = p_289697_.method_51450().getBuffer(class_1921.method_23576((class_2960)texture));
        float f3 = -(1.0f - f) * 90.0f - 90.0f;
        p_289697_.method_51448().method_22903();
        float f2 = 40.0f;
        p_289697_.method_51448().method_22905(45.0f, 45.0f, 1.0f);
        p_289697_.method_51448().method_46416((1.0f - f) * 0.2f, (1.0f - f) * 0.1f, 1.0f);
        float f4 = class_3532.method_15363((float)(class_3532.method_22450((float)(f1 + 0.25f)) * 1.6f - 0.3f), (float)0.0f, (float)1.0f);
        float f5 = class_3532.method_15363((float)(class_3532.method_22450((float)(f1 + 0.75f)) * 1.6f - 0.3f), (float)0.0f, (float)1.0f);
        p_289697_.method_51448().method_46416(0.56f, -0.7f, 0.525f);
        RenderSystem.setShaderLights((Vector3f)new Vector3f(0.0f, 2.0f, -50.0f).normalize(), (Vector3f)new Vector3f(0.0f, -2.0f, -50.0f).normalize());
        if (!largeBody) {
            this.butterflyModel.Butterfly.field_3674 = (float)Math.PI;
            this.butterflyModel.Butterfly.field_3654 = 1.5707964f;
            this.butterflyModel.LeftTena.field_3674 = 1.5f;
            this.butterflyModel.RightTena.field_3674 = -1.5f;
            this.butterflyModel.Butterfly.field_3675 = 0.0f;
            this.butterflyModel.Butterfly.field_37938 = 1.0f;
            this.butterflyModel.Butterfly.field_3655 = 15.0f;
            this.butterflyModel.Body.field_3654 = 0.0f;
            this.butterflyModel.Body.field_3675 = 0.0f;
            this.butterflyModel.Body.field_3674 = 0.0f;
            this.butterflyModel.Body.field_3657 = 0.0f;
            p_289697_.method_51448().method_22903();
            p_289697_.method_51448().method_22903();
            p_289697_.method_51448().method_46416(0.062f, 0.012f, 0.0f);
            p_289697_.method_51448().method_22905(1.05f, 1.05f, 0.0f);
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            class_1921 renderType = class_1921.method_29379((class_2960)texture);
            class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
            class_4588 vertexConsumer = bufferSource.getBuffer(renderType);
            this.butterflyModel.Butterfly.method_22698(p_289697_.method_51448(), vertexConsumer, 0xF000F0, class_4608.field_21444);
            bufferSource.method_22994(renderType);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            p_289697_.method_51448().method_22909();
            p_289697_.method_51448().method_22903();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            class_4597.class_4598 bufferSource2 = class_310.method_1551().method_22940().method_23000();
            class_4588 vertexConsumer2 = bufferSource2.getBuffer(class_1921.method_29379((class_2960)texture));
            this.butterflyModel.Butterfly.method_22698(p_289697_.method_51448(), vertexConsumer2, 0xF000F0, class_4608.field_21444);
            bufferSource.method_22994(class_1921.method_29379((class_2960)texture));
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            p_289697_.method_51448().method_22909();
            p_289697_.method_51448().method_22909();
        } else {
            this.mothModel.Butterfly.field_3674 = (float)Math.PI;
            this.mothModel.Butterfly.field_3654 = 1.5707964f;
            this.mothModel.LeftTena.field_3674 = 1.5f;
            this.mothModel.RightTena.field_3674 = -1.5f;
            this.mothModel.Butterfly.field_3675 = 0.0f;
            this.mothModel.Butterfly.field_37938 = 1.0f;
            this.mothModel.Butterfly.field_3655 = 15.0f;
            p_289697_.method_51448().method_22903();
            p_289697_.method_51448().method_46416(0.15f, 0.0f, 0.0f);
            p_289697_.method_51448().method_22903();
            p_289697_.method_51448().method_46416(0.062f, 0.012f, 0.0f);
            p_289697_.method_51448().method_22905(1.05f, 1.05f, 0.0f);
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            class_1921 renderType = class_1921.method_29379((class_2960)texture);
            class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
            class_4588 vertexConsumer = bufferSource.getBuffer(renderType);
            this.mothModel.Butterfly.method_22698(p_289697_.method_51448(), vertexconsumer, 0xF000F0, class_4608.field_21444);
            bufferSource.method_22994(renderType);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            p_289697_.method_51448().method_22909();
            p_289697_.method_51448().method_22903();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            class_4597.class_4598 bufferSource2 = class_310.method_1551().method_22940().method_23000();
            class_4588 vertexConsumer2 = bufferSource2.getBuffer(class_1921.method_29379((class_2960)texture));
            this.mothModel.Butterfly.method_22698(p_289697_.method_51448(), vertexconsumer, 0xF000F0, class_4608.field_21444);
            bufferSource.method_22994(class_1921.method_29379((class_2960)texture));
            p_289697_.method_51448().method_22909();
            p_289697_.method_51448().method_22909();
        }
        p_289697_.method_51448().method_22909();
    }

    private void renderLocatePortion(class_332 stack, int mouseX, int mouseY, float parT, String textureString, String textureID, String type, String rarity, String species, String family) {
        ButterflyVariant lepidoptera = ButterflyVariant.BLUE_MORPHO;
        for (int a = 0; a < ButterflyVariant.getAllVariantPool().size(); ++a) {
            if (!ButterflyVariant.getAllVariantPool().get(a).getButterflyStringId().matches(textureString)) continue;
            lepidoptera = ButterflyVariant.getAllVariantPool().get(a);
        }
        float minTemp = lepidoptera.minTemp();
        float maxTemp = lepidoptera.maxTemp();
        float minHumid = lepidoptera.minHumidity();
        float maxHumid = lepidoptera.maxHumidity();
        boolean validBiome = true;
        if (this.biome == null) {
            validBiome = false;
        }
        stack.method_51448().method_22903();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.71f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int offsetX = 2;
        int offsetY = -3;
        stack.method_51448().method_22903();
        stack.method_51448().method_46416(0.5f, 26.0f - minTemp - (float)((int)(maxTemp * 13.0f)), 0.0f);
        stack.method_25302(new class_2960("longwings", "textures/gui/handbook.png"), 215 + offsetX, 91 + offsetY, 35, 122, 7, 5 + (int)((maxTemp - minTemp) * 13.0f));
        stack.method_51448().method_22909();
        stack.method_51448().method_22903();
        stack.method_51448().method_46416(0.5f, 26.0f - minHumid - (float)((int)(maxHumid * 13.0f)), 0.0f);
        stack.method_25302(new class_2960("longwings", "textures/gui/handbook.png"), 223 + offsetX, 91 + offsetY, 43, 122, 7, 5 + (int)((maxHumid - minHumid) * 13.0f));
        stack.method_51448().method_22909();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        stack.method_51448().method_22909();
        float biomeTemp = LongwingsHandler.getBiomeTemperature(this.biome);
        float biomeHumid = LongwingsHandler.getBiomeHumidity(this.biome);
        if (validBiome) {
            stack.method_51448().method_22903();
            stack.method_51448().method_46416(0.0f, Math.min(-0.5f + -(biomeTemp * 13.5f), 0.0f), 0.0f);
            stack.method_25302(new class_2960("longwings", "textures/gui/handbook.png"), 208 + offsetX, 118 + offsetY, 32, 155, 18, 25);
            stack.method_51448().method_22909();
            stack.method_51448().method_22903();
            stack.method_51448().method_46416(0.0f, Math.min(-0.5f + -biomeHumid * 13.5f, 0.0f), 0.0f);
            stack.method_25302(new class_2960("longwings", "textures/gui/handbook.png"), 216 + offsetX, 118 + offsetY, 32, 155, 18, 25);
            stack.method_51448().method_22909();
        }
        if (validBiome) {
            boolean tempFlag;
            boolean humidFlag = biomeHumid >= minHumid && biomeHumid <= maxHumid;
            boolean bl = tempFlag = biomeTemp >= minTemp && biomeTemp <= maxTemp;
            if (humidFlag && tempFlag) {
                this.renderText(stack, class_2561.method_43471((String)"title.longwings.spawn_confirm_1").getString(), 233.0f, 127.0f, 0.0f, 0.32f, 0.32f, 1.0f, true);
                this.renderText(stack, class_2561.method_43471((String)"title.longwings.spawn_confirm_2").getString(), 233.0f, 130.0f, 0.0f, 0.32f, 0.32f, 1.0f, true);
            }
            stack.method_25302(new class_2960("longwings", "textures/gui/handbook.png"), 214 + offsetX, 129 + offsetY, biomeTemp >= minTemp && biomeTemp <= maxTemp ? 47 : 55, 155, 9, 45);
            stack.method_25302(new class_2960("longwings", "textures/gui/handbook.png"), 222 + offsetX, 129 + offsetY, biomeHumid >= minHumid && biomeHumid <= maxHumid ? 47 : 55, 155, 9, 45);
        }
    }

    private void renderLurePortion(class_332 stack, int mouseX, int mouseY, float parT, String textureString, String textureID, String type, String rarity, String species, String family) {
        boolean flagC;
        ButterflyVariant lepidoptera = ButterflyVariant.BLUE_MORPHO;
        for (int a = 0; a < ButterflyVariant.getAllVariantPool().size(); ++a) {
            if (!ButterflyVariant.getAllVariantPool().get(a).getButterflyStringId().matches(textureString)) continue;
            lepidoptera = ButterflyVariant.getAllVariantPool().get(a);
        }
        stack.method_51448().method_22903();
        int brineCount = 0;
        int offset = 9;
        boolean flagA = lepidoptera.minTemp() >= 0.9f || lepidoptera.maxTemp() >= 0.9f;
        boolean flagB = (lepidoptera.minTemp() > 0.4f || lepidoptera.maxTemp() > 0.4f) && (lepidoptera.minTemp() < 0.9f || lepidoptera.maxTemp() < 0.9f);
        boolean bl = flagC = lepidoptera.minTemp() <= 0.4f || lepidoptera.maxTemp() <= 0.4f;
        if (flagA) {
            offset -= 3;
        }
        if (flagB) {
            offset -= 3;
        }
        if (flagC) {
            offset -= 3;
        }
        stack.method_51448().method_46416((float)(offset + 0), -2.0f, 0.0f);
        stack.method_51448().method_22903();
        this.renderText(stack, class_2561.method_43471((String)"title.longwings.lure").getString() + ":", 162.0f, 126.0f, 0.0f, 0.4f, 0.4f, 0.7f, true);
        stack.method_51448().method_46416(172.0f, 123.0f, 0.0f);
        stack.method_51448().method_22905(0.035f, 0.035f, 0.035f);
        if (flagA) {
            stack.method_25302(new class_2960("longwings", "textures/item/watermelon_butterfly_brine.png"), 0, 0, 0, 0, 225, 284);
            ++brineCount;
        }
        if (flagB) {
            stack.method_51448().method_22903();
            stack.method_51448().method_46416((float)(165 * brineCount), 0.0f, 0.0f);
            stack.method_25302(new class_2960("longwings", "textures/item/apple_butterfly_brine.png"), 0, 0, 0, 0, 225, 284);
            stack.method_51448().method_22909();
            ++brineCount;
        }
        if (flagC) {
            stack.method_51448().method_22903();
            stack.method_51448().method_46416((float)(165 * brineCount), 0.0f, 0.0f);
            stack.method_25302(new class_2960("longwings", "textures/item/sweet_berry_butterfly_brine.png"), 0, 0, 0, 0, 225, 284);
            stack.method_51448().method_22909();
            ++brineCount;
        }
        stack.method_51448().method_22909();
        stack.method_51448().method_22909();
        boolean activeDay = lepidoptera.mostlyActive() == EnumButterflyTraits.ButterflyMostActive.DIURNAL;
        stack.method_51448().method_22903();
        stack.method_51448().method_46416(195.5f, -1.5f, 0.0f);
        if (activeDay) {
            stack.method_25302(new class_2960("longwings", "textures/gui/handbook.png"), 0, 119, 50, 124, 17, 15);
        } else {
            stack.method_25302(new class_2960("longwings", "textures/gui/handbook.png"), 0, 121, 50, 138, 118, 15);
        }
        stack.method_51448().method_22909();
    }

    private void renderSpeciesPage(class_332 stack, int mouseX, int mouseY, float parT, String textureString, String textureID, String type, String rarity, String species, String family) {
        float minHumid = 0.0f;
        float maxHumid = 0.0f;
        float minTemp = 1.0f;
        float maxTemp = 1.0f;
        boolean validBiome = true;
        EnumButterflyTraits.ButterflySizes typeSize = EnumButterflyTraits.ButterflySizes.NORMAL;
        EnumButterflyTraits.ButterflyRarity typeRarity = EnumButterflyTraits.ButterflyRarity.COMMON;
        String habitat = "This isnt functional yet";
        if (this.biome == null) {
            validBiome = false;
        }
        ButterflyVariant lepidoptera = ButterflyVariant.BLUE_MORPHO;
        for (int a = 0; a < ButterflyVariant.getAllVariantPool().size(); ++a) {
            if (!ButterflyVariant.getAllVariantPool().get(a).getButterflyStringId().matches(textureString)) continue;
            lepidoptera = ButterflyVariant.getAllVariantPool().get(a);
        }
        minHumid = lepidoptera.minHumidity();
        maxHumid = lepidoptera.maxHumidity();
        minTemp = lepidoptera.minTemp();
        maxTemp = lepidoptera.maxTemp();
        typeSize = lepidoptera.size();
        int spawnWeight = lepidoptera.getButterflySpawnRarity();
        if (spawnWeight <= 3) {
            typeRarity = EnumButterflyTraits.ButterflyRarity.EXTREMELY_RARE;
        }
        if (spawnWeight >= 4) {
            typeRarity = EnumButterflyTraits.ButterflyRarity.RARE;
        }
        if (spawnWeight >= 6) {
            typeRarity = EnumButterflyTraits.ButterflyRarity.UNCOMMON;
        }
        if (spawnWeight >= 8) {
            typeRarity = EnumButterflyTraits.ButterflyRarity.COMMON;
        }
        stack.method_51448().method_22903();
        float reductionValue = textureID.toString().length() - 12;
        float scale = 0.85f;
        float yModifier = 0.0f;
        float xTranslation = 0.0f;
        if (textureID.toString().length() > 12) {
            scale = 0.85f - 0.025f * reductionValue;
            yModifier = 0.22f * reductionValue;
            xTranslation = 0.55f * reductionValue;
        }
        this.renderText(stack, textureID, 163.0f, 54.0f + yModifier + 7.0f, 0.0f, scale, scale, scale, true);
        stack.method_51448().method_22909();
        this.renderText(stack, this.pages > 3 + ButterflyVariant.getButterflyVariantPool().length ? "Moth" : "Butterfly", 163.0f, 69.0f, 0.0f, 0.55f, 0.55f, 0.7f, true);
        stack.method_51448().method_22903();
        stack.method_51448().method_46416(185.0f, 34.0f, 0.0f);
        stack.method_51448().method_22905(0.17f, 0.17f, 1.0f);
        if (this.pages > 3 + ButterflyVariant.getButterflyVariantPool().length) {
            stack.method_25302(new class_2960("longwings", "textures/gui/atlas_type_icons.png"), 32, 32, 125, 0, 115, 255);
        } else {
            stack.method_25302(new class_2960("longwings", "textures/gui/atlas_type_icons.png"), 32, 32, 0, 0, 115, 255);
        }
        stack.method_51448().method_22909();
        this.renderText(stack, class_2561.method_43471((String)"title.longwings.family").getString() + ": " + class_2561.method_43471((String)("title.longwings.family." + family.toLowerCase())).getString(), 162.0f, 93.0f, 0.0f, 0.4f, 0.4f, 0.7f, true);
        this.renderText(stack, class_2561.method_43471((String)"title.longwings.size").getString() + ": " + class_2561.method_43471((String)("title.longwings.size." + typeSize.toString().toLowerCase())).getString(), 162.0f, 99.0f, 0.0f, 0.4f, 0.4f, 0.7f, true);
        this.renderText(stack, class_2561.method_43471((String)"title.longwings.rarity").getString() + ": " + class_2561.method_43471((String)("title.longwings.rarity." + typeRarity.toString().toLowerCase())).getString(), 162.0f, 105.0f, 0.0f, 0.4f, 0.4f, 0.7f, true);
        this.renderText(stack, class_2561.method_43471((String)"title.longwings.about").getString() + " ", 163.0f, 82.0f, 0.0f, 0.55f, 0.55f, 0.7f, true);
        this.renderText(stack, "_", 162.0f, 83.5f, 0.0f, 4.15f, 0.55f, 0.7f, false);
        this.renderText(stack, class_2561.method_43471((String)"title.longwings.locate").getString() + " ", 213.0f, 82.0f, 0.0f, 0.55f, 0.55f, 0.7f, true);
        this.renderText(stack, "_", 212.0f, 83.5f, 0.0f, 3.85f, 0.55f, 0.7f, false);
        this.renderLocatePortion(stack, mouseX, mouseY, parT, textureString, textureID, type, rarity, species, family);
        this.renderLurePortion(stack, mouseX, mouseY, parT, textureString, textureID, type, rarity, species, family);
        class_2960 location = new class_2960("longwings", "textures/entity/butterfly/" + textureString + ".png");
        if (this.pages > 3 + this.butterflyList.size() && this.pages < 4 + this.butterflyList.size() + this.mothList.size()) {
            location = new class_2960("longwings", "textures/entity/moth/" + textureString + ".png");
        }
        if (this.pages >= 3) {
            stack.method_51448().method_22903();
            stack.method_51448().method_46416(72.0f, 61.0f, 1.0f);
            boolean hasMothBody = lepidoptera.bodyType() == EnumButterflyTraits.BodyType.MOTH;
            this.renderProp(stack, mouseX, mouseY, parT, location, hasMothBody);
            stack.method_51448().method_22909();
        }
        float minValue = lepidoptera.minTemp();
        float maxValue = lepidoptera.maxTemp();
    }

    private void renderSpeciesPagesAlt(class_332 stack, int mouseX, int mouseY, float parT) {
        if (this.pages <= 1) {
            stack.method_25302(new class_2960("longwings", "textures/gui/handbook_title.png"), 32, 32, 0, 0, 225, 122);
        } else if (this.pages == 2 || this.pages == 3) {
            stack.method_25302(new class_2960("longwings", "textures/gui/handbook_atlas.png"), 32, 32, 0, 0, 225, 122);
            if (this.pages == 2) {
                stack.method_51448().method_22903();
                stack.method_51448().method_46416(118.5f, 35.0f, 0.0f);
                stack.method_51448().method_22905(0.2f, 0.2f, 0.2f);
                stack.method_25302(new class_2960("longwings", "textures/gui/atlas_type_icons.png"), 32, 32, 0, 0, 115, 255);
                stack.method_51448().method_22903();
                stack.method_51448().method_46416(125.0f, 55.0f, 0.0f);
                stack.method_51448().method_22905(0.5f, 0.5f, 1.0f);
                stack.method_25302(new class_2960("longwings", "textures/gui/atlas_type_icons.png"), 32, 32, 125, 0, 115, 255);
                stack.method_51448().method_22909();
                stack.method_51448().method_22909();
            }
            if (this.pages == 3) {
                stack.method_51448().method_22903();
                stack.method_51448().method_46416(135.5f, 35.0f, 0.0f);
                stack.method_51448().method_22905(0.2f, 0.2f, 0.2f);
                stack.method_25302(new class_2960("longwings", "textures/gui/atlas_type_icons.png"), 32, 32, 125, 0, 115, 255);
                stack.method_51448().method_22903();
                stack.method_51448().method_46416(-50.0f, 55.0f, 0.0f);
                stack.method_51448().method_22905(0.5f, 0.5f, 1.0f);
                stack.method_25302(new class_2960("longwings", "textures/gui/atlas_type_icons.png"), 32, 32, 0, 0, 115, 255);
                stack.method_51448().method_22909();
                stack.method_51448().method_22909();
            }
        } else if (this.pages >= 4 && this.pages <= 3 + this.butterflyList.size() + this.mothList.size()) {
            ArrayList<ButterflyVariant> variantList;
            stack.method_25302(new class_2960("longwings", "textures/gui/handbook.png"), 32, 32, 0, 0, 225, 122);
            int commonPages = this.pages > this.butterflyList.size() + 3 ? this.pages - this.butterflyList.size() - 4 : this.pages - 4;
            ArrayList<ButterflyVariant> arrayList = variantList = this.pages <= 4 + commonPages ? this.butterflyList : this.mothList;
            if (commonPages < this.butterflyList.size() + this.mothList.size()) {
                this.renderSpeciesPage(stack, mouseX, mouseY, parT, variantList.get(commonPages).id(), class_5250.method_43477((class_7417)class_2561.method_43471((String)("title.longwings." + variantList.get(commonPages).id())).method_10851()).getString(), variantList.get(commonPages).getButterflyClimateType(), String.valueOf(Math.round((float)variantList.get(commonPages).getButterflySpawnRarity() / (float)variantList.size() * 100.0f) + "%"), variantList.get(commonPages).id(), variantList.get(commonPages).getButterflyFamilyType().name());
            }
        }
        if (this.bookmarked) {
            stack.method_51448().method_22903();
            stack.method_51448().method_22904(0.3, 0.2, 0.0);
            stack.method_25302(new class_2960("longwings", "textures/gui/handbook_atlas.png"), 223, 34, 0, 159, 18, 20);
            stack.method_51448().method_22909();
        }
    }

    public void method_25394(class_332 stack, int mouseX, int mouseY, float parT) {
        int i = (this.field_22789 - 220) / 2;
        int j = (this.field_22790 - 220) / 2;
        stack.method_51448().method_22903();
        stack.method_51448().method_22903();
        stack.method_51448().method_22905(1.0f, 1.0f, 1.0f);
        stack.method_51448().method_22903();
        stack.method_51448().method_46416((float)i - 91.5f, (float)(j - 70), 0.0f);
        stack.method_51448().method_22905(1.4f, 1.4f, 1.4f);
        this.renderSpeciesPagesAlt(stack, mouseX, mouseY, parT);
        stack.method_51448().method_22909();
        super.method_25394(stack, mouseX, mouseY, parT);
        stack.method_51448().method_22903();
        stack.method_51448().method_46416((float)this.atlasButton.method_46426() + 4.8f, (float)this.atlasButton.method_46427() + 4.0f, 0.0f);
        stack.method_51448().method_22905(0.05f, 0.05f, 0.05f);
        stack.method_25302(new class_2960("longwings", "textures/gui/index.png"), 0, 0, 0, 0, 250, 250);
        stack.method_51448().method_22909();
        if (this.sortButton.method_25367()) {
            stack.method_25300(this.field_22793, "|", this.sortButton.method_46426() + 10, this.sortButton.method_46427() + 23, 0xFFFFFF);
            stack.method_25300(this.field_22793, "Sort: " + this.sortValue.toString().toLowerCase(), this.sortButton.method_46426() + 10, this.sortButton.method_46427() + 32, 0xFFFFFF);
        }
        stack.method_51448().method_22909();
        stack.method_51448().method_22909();
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return super.method_25405(mouseX, mouseY);
    }

    public void method_25419() {
        this.sendBookmarkClientData(this.pages, this.openedByMainHand, this.bookmarked);
        super.method_25419();
    }

    public boolean method_25422() {
        return true;
    }

    public void sendBookmarkClientData(int pages, boolean openedByMainHand, boolean bookmarked) {
        LongwingsHandler.getHandbookHandler().onCloseSyncData(pages, openedByMainHand, bookmarked);
    }

    public class ButterflyIndexButton
    extends class_4185 {
        String prefixString;
        String typeIdString;
        private ButterflyModel butterflyModel;
        boolean locked;
        boolean canSpawn;

        public ButterflyIndexButton(int p_99225_, int p_99226_, class_4185.class_4241 p_99228_, String prefix, String butterflyID, boolean locked, boolean canSpawn) {
            super(p_99225_, p_99226_, 15, 15, class_5244.field_39003, p_99228_, field_40754);
            this.prefixString = "error";
            this.typeIdString = "error";
            this.prefixString = prefix;
            this.typeIdString = butterflyID;
            this.locked = locked;
            this.canSpawn = canSpawn;
        }

        public void renderSelectedText(class_332 p_283468_) {
            class_5250 typeComponent = class_2561.method_43471((String)("title.longwings." + this.typeIdString));
            String string = typeComponent.getString();
            p_283468_.method_51448().method_22903();
            p_283468_.method_51448().method_46416((float)p_283468_.method_51421() / 2.0f, (float)p_283468_.method_51443() / 2.0f, 1.0f);
            HandbookScreen.this.renderText(p_283468_, string, -((float)string.length() * 1.8f), HandbookScreen.this.pages == 3 ? -12.0f : -2.0f, 1.0f, 0.7f, 0.7f, 1.0f, false);
            p_283468_.method_51448().method_22903();
            p_283468_.method_51448().method_22905(1.5f, 5.0f, 1.0f);
            p_283468_.method_51448().method_46416(-10.0f, -5.0f, 0.0f);
            p_283468_.method_51448().method_22909();
            p_283468_.method_51448().method_22909();
        }

        public void method_48579(class_332 p_283468_, int p_282922_, int p_283637_, float p_282459_) {
            int h = (p_283468_.method_51421() - 220) / 2;
            int i = (p_283468_.method_51443() - 220) / 2;
            int j = 192;
            int a = (this.field_22758 - 250) / 2;
            p_283468_.method_51448().method_22903();
            p_283468_.method_51448().method_46416((float)this.method_46426(), (float)this.method_46427(), 0.0f);
            p_283468_.method_51448().method_22905(1.5f, 1.5f, 1.0f);
            boolean mothBodyCheck = false;
            ArrayList<ButterflyVariant> allTypePool = ButterflyVariant.getAllVariantPool();
            for (int b = 0; b < allTypePool.size(); ++b) {
                if (!allTypePool.get(b).getButterflyStringId().matches(this.typeIdString.toLowerCase()) || allTypePool.get(b).bodyType() != EnumButterflyTraits.BodyType.MOTH) continue;
                mothBodyCheck = true;
            }
            if (HandbookScreen.this.pages == 2 || HandbookScreen.this.pages == 3) {
                class_2960 location = new class_2960("longwings", "textures/entity/" + this.prefixString + this.typeIdString + ".png");
                if (this.locked) {
                    p_283468_.method_51448().method_22903();
                    p_283468_.method_51448().method_46416(-0.5f, 0.0f, 0.0f);
                    if (this.canSpawn) {
                        p_283468_.method_25302(new class_2960("longwings", "textures/gui/handbook_atlas.png"), 1, 0, 57, j + 185 + 1, 10, 10);
                    } else {
                        p_283468_.method_25302(new class_2960("longwings", "textures/gui/handbook_atlas.png"), 1, 0, 57, j + 185 + 1, 10, 10);
                    }
                    p_283468_.method_51448().method_22909();
                } else if (this.method_49606() || this.method_25370()) {
                    p_283468_.method_51448().method_22903();
                    p_283468_.method_51448().method_46416(-2.0f, -1.0f, 0.0f);
                    p_283468_.method_25302(new class_2960("longwings", "textures/gui/handbook_atlas.png"), 0, -1, 46, j + 185 + 1, 12, 12);
                    p_283468_.method_51448().method_22909();
                    p_283468_.method_51448().method_22903();
                    p_283468_.method_51448().method_46416(-8.0f, -25.0f, 1.0f);
                    p_283468_.method_51448().method_22905(0.525f, 0.525f, 1.0f);
                    HandbookScreen.this.renderProp(p_283468_, p_282922_, p_282922_, p_282459_, location, mothBodyCheck);
                    p_283468_.method_51448().method_22909();
                } else {
                    p_283468_.method_51448().method_22903();
                    p_283468_.method_51448().method_22904(-0.4, 0.0, 0.0);
                    p_283468_.method_25302(new class_2960("longwings", "textures/gui/handbook_atlas.png"), 0, 0, 34, j + 185 + 1, 12, 12);
                    p_283468_.method_51448().method_22909();
                    p_283468_.method_51448().method_22903();
                    p_283468_.method_51448().method_46416(3.0f, 1.0f, 0.0f);
                    p_283468_.method_51448().method_22905(0.125f, 0.124f, 1.0f);
                    HandbookScreen.this.renderProp(p_283468_, p_282922_, p_282922_, p_282459_, location, mothBodyCheck);
                    p_283468_.method_51448().method_22909();
                }
            }
            p_283468_.method_51448().method_22909();
            if (!this.locked && this.method_25367()) {
                this.renderSelectedText(p_283468_);
            }
        }

        public void method_25354(class_1144 p_99231_) {
            p_99231_.method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
        }
    }

    public class BookmarkButton
    extends class_4185 {
        public BookmarkButton(int p_99225_, int p_99226_, class_4185.class_4241 p_99228_) {
            super(p_99225_, p_99226_, 13, 20, class_5244.field_39003, p_99228_, field_40754);
        }

        public void method_48579(class_332 p_283468_, int p_282922_, int p_283637_, float p_282459_) {
        }

        public void method_25354(class_1144 p_99231_) {
            p_99231_.method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17481, (float)2.0f));
        }
    }
}

